/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.providers.web;

import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IHttpSessionActivationListener;
import com.tssap.j2ee.core.web.IHttpSessionAttributeListener;
import com.tssap.j2ee.core.web.IHttpSessionBindingListener;
import com.tssap.j2ee.core.web.IHttpSessionListener;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IServletContextAttributeListener;
import com.tssap.j2ee.core.web.IServletContextListener;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebMethod;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;

public class WebModelMetaInfo {
    public static final String WEB_NATURE = "com.tssap.j2ee.core.web.webNature";
    public static final String WEB_DOMAIN = "com.tssap.j2ee.core.web";
    public static final String JSP_FILE_EXTENSION = "jsp";
    public static final String HTM_FILE_EXTENSION = "htm";
    public static final String HTML_FILE_EXTENSION = "html";
    public static final String REFRESH_HIERARCHY = "$refreshHierarchy";
    public static final String SERVLET_METACLASS = "com.tssap.j2ee.core.web.Servlet";
    public static final String FILTER_METACLASS = "com.tssap.j2ee.core.web.Filter";
    public static final String JSP_METACLASS = "com.tssap.j2ee.core.web.JSP";
    public static final String HTML_METACLASS = "com.tssap.j2ee.core.web.HTML";
    public static final String HTTP_SESSION_ATTRIBUTE_LISTENER_METACLASS = "com.tssap.j2ee.core.web.HttpSessionAttributeListener";
    public static final String HTTP_SESSION_ACTIVATION_LISTENER_METACLASS = "com.tssap.j2ee.core.web.HttpSessionActivationListener";
    public static final String HTTP_SESSION_BINDING_LISTENER_METACLASS = "com.tssap.j2ee.core.web.HttpSessionBindingListener";
    public static final String HTTP_SESSION_LISTENER_METACLASS = "com.tssap.j2ee.core.web.HttpSessionListener";
    public static final String SERVLET_CONTEXT_ATTRIBUTE_LISTENER_METACLASS = "com.tssap.j2ee.core.web.ServletContextAttributeListener";
    public static final String SERVLET_CONTEXT_LISTENER_METACLASS = "com.tssap.j2ee.core.web.ServletContextListener";
    public static final String WEB_METHOD_METACLASS = "com.tssap.j2ee.core.web.WebMethod";
    public static final String SERVLET_METHOD_METACLASS = "com.tssap.j2ee.core.web.ServletMethod";
    public static final String WEB_CONTENT = "com.tssap.j2ee.core.web.WebContent";
    public static final String WEB_CONTENT_DIAGRAM = "WebContentDiagram";
    public static final String WEB_RESOURCE = "com.tssap.j2ee.core.web.Resource";
    public static final String HTTP_SERVLET_PROPERTY = "httpServlet";
    public static final String GET_METHOD = "doGet";
    public static final String POST_METHOD = "doPost";
    public static final String HEAD_METHOD = "doHead";
    public static final String PUT_METHOD = "doPut";
    public static final String DELETE_METHOD = "doDelete";
    public static final String OPTIONS_METHOD = "doOptions";
    public static final String TRACE_METHOD = "doTrace";
    public static final String SERVICE_METHOD = "service";
    public static final String INIT_METHOD = "init";
    public static final String DESTROY_METHOD = "destroy";
    public static final String DO_FILTER_METHOD = "doFilter";
    public static final String SINGLE_THREADED = "singleThreaded";
    public static final String IMPORTED = "imported";
    public static final String PARAMETER_ARRAY_PROPERTY = "parameterArray";
    public static final String PARAMETER_NAME_ARRAY_PROPERTY = "parameterNameArray";
    public static final String EXCEPTION_ARRAY_PROPERTY = "exceptionArray";
    public static final String IMETHOD_PROPERTY = "org.eclipse.jdt.core.IMethod";
    public static final String BASE_CLASS_PROPERTY = "baseClass";
    private static final String REGISTRY_SUFFIX = ".Registry";
    private static final String REGISTRY_DOMAIN = "com.tssap.j2ee.core.web.Registry";
    private static final String SERVLET_REGISTRY_BASE = "Servlet Registry";
    private static final String FILTER_REGISTRY_BASE = "Filter Registry";
    private static final String JSP_REGISTRY_BASE = "JSP Registry";
    private static final String LISTENER_REGISTRY_BASE = "Listener Registry";
    public static final UniqueName SERVLET_REGISTRY = WebModelMetaInfo.getRegistry("Servlet Registry");
    public static final UniqueName FILTER_REGISTRY = WebModelMetaInfo.getRegistry("Filter Registry");
    public static final UniqueName JSP_REGISTRY = WebModelMetaInfo.getRegistry("JSP Registry");
    public static final UniqueName LISTENER_REGISTRY = WebModelMetaInfo.getRegistry("Listener Registry");
    private static final HashMap METACLASSES_TO_REGISTRY_UINS = new HashMap();
    public static final String JSP_LOCATION_PROPERTY;
    public static final String ITYPE_PROPERTY;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IType;

    public static UniqueName getUniqueName(IWebElement element) {
        if (element instanceof WebProject) {
            WebProject project = (WebProject)element;
            return ModelUinSupport.createModelUin((String)project.getProject().getName());
        }
        if (element instanceof IJSP) {
            return WebModelMetaInfo.getUniqueName((IJSP)element);
        }
        if (element instanceof IServlet) {
            return WebModelMetaInfo.getUniqueName((IServlet)element);
        }
        if (element instanceof IFilter) {
            return WebModelMetaInfo.getUniqueName((IFilter)element);
        }
        if (element instanceof IHttpSessionAttributeListener) {
            return WebModelMetaInfo.getUniqueName((IHttpSessionAttributeListener)element);
        }
        if (element instanceof IHttpSessionActivationListener) {
            return WebModelMetaInfo.getUniqueName((IHttpSessionActivationListener)element);
        }
        if (element instanceof IHttpSessionBindingListener) {
            return WebModelMetaInfo.getUniqueName((IHttpSessionBindingListener)element);
        }
        if (element instanceof IHttpSessionListener) {
            return WebModelMetaInfo.getUniqueName((IHttpSessionListener)element);
        }
        if (element instanceof IServletContextAttributeListener) {
            return WebModelMetaInfo.getUniqueName((IServletContextAttributeListener)element);
        }
        if (element instanceof IServletContextListener) {
            return WebModelMetaInfo.getUniqueName((IServletContextListener)element);
        }
        if (element instanceof IWebMethod) {
            return WebModelMetaInfo.getUniqueName((IWebMethod)element);
        }
        return null;
    }

    public static boolean isServletUniqueName(UniqueName uniqueName) {
        return SERVLET_METACLASS.equals(uniqueName.getSubDomain()) && WebModelMetaInfo.isSourceElementUniqueName(uniqueName);
    }

    public static boolean isFilterUniqueName(UniqueName uniqueName) {
        return FILTER_METACLASS.equals(uniqueName.getSubDomain()) && WebModelMetaInfo.isSourceElementUniqueName(uniqueName);
    }

    public static boolean isJSPUniqueName(UniqueName uniqueName) {
        return JSP_METACLASS.equals(uniqueName.getSubDomain()) && WEB_DOMAIN.equals(uniqueName.getDomain()) && uniqueName.getParametersCount() == 0;
    }

    public static boolean isHttpSessionAttributeListenerUniqueName(UniqueName uniqueName) {
        return HTTP_SESSION_ATTRIBUTE_LISTENER_METACLASS.equals(uniqueName.getSubDomain()) && WebModelMetaInfo.isSourceElementUniqueName(uniqueName);
    }

    public static boolean isHttpSessionActivationListenerUniqueName(UniqueName uniqueName) {
        return HTTP_SESSION_ACTIVATION_LISTENER_METACLASS.equals(uniqueName.getSubDomain()) && WebModelMetaInfo.isSourceElementUniqueName(uniqueName);
    }

    public static boolean isHttpSessionBindingListenerUniqueName(UniqueName uniqueName) {
        return HTTP_SESSION_BINDING_LISTENER_METACLASS.equals(uniqueName.getSubDomain()) && WebModelMetaInfo.isSourceElementUniqueName(uniqueName);
    }

    public static boolean isHttpSessionListenerUniqueName(UniqueName uniqueName) {
        return HTTP_SESSION_LISTENER_METACLASS.equals(uniqueName.getSubDomain()) && WebModelMetaInfo.isSourceElementUniqueName(uniqueName);
    }

    public static boolean isServletContextAttributeListenerUniqueName(UniqueName uniqueName) {
        return SERVLET_CONTEXT_ATTRIBUTE_LISTENER_METACLASS.equals(uniqueName.getSubDomain()) && WebModelMetaInfo.isSourceElementUniqueName(uniqueName);
    }

    public static boolean isServletContextListenerUniqueName(UniqueName uniqueName) {
        return SERVLET_CONTEXT_LISTENER_METACLASS.equals(uniqueName.getSubDomain()) && WebModelMetaInfo.isSourceElementUniqueName(uniqueName);
    }

    public static boolean isWebListener(UniqueName uniqueName) {
        if (WebModelMetaInfo.isHttpSessionAttributeListenerUniqueName(uniqueName)) {
            return true;
        }
        if (WebModelMetaInfo.isHttpSessionActivationListenerUniqueName(uniqueName)) {
            return true;
        }
        if (WebModelMetaInfo.isHttpSessionBindingListenerUniqueName(uniqueName)) {
            return true;
        }
        if (WebModelMetaInfo.isHttpSessionListenerUniqueName(uniqueName)) {
            return true;
        }
        if (WebModelMetaInfo.isServletContextAttributeListenerUniqueName(uniqueName)) {
            return true;
        }
        return WebModelMetaInfo.isServletContextListenerUniqueName(uniqueName);
    }

    private static boolean isSourceElementUniqueName(UniqueName uniqueName) {
        return WEB_DOMAIN.equals(uniqueName.getDomain()) && uniqueName.getParametersCount() == 0;
    }

    public static boolean isWebMethodUniqueName(UniqueName uniqueName) {
        return WEB_METHOD_METACLASS.equals(uniqueName.getSubDomain()) && WEB_DOMAIN.equals(uniqueName.getDomain()) && uniqueName.getParametersCount() == 0;
    }

    public static String getFilterPackageName(UniqueName uin) {
        return uin.getLocation();
    }

    public static String getFilterClassName(UniqueName uin) {
        return uin.getName();
    }

    public static String getFilterClassFqn(UniqueName uin) {
        String packageName = WebModelMetaInfo.getFilterPackageName(uin);
        String className = WebModelMetaInfo.getFilterClassName(uin);
        if (packageName != null && packageName.trim().length() > 0) {
            className = packageName + '.' + className;
        }
        return className;
    }

    public static String getWebListenerPackageName(UniqueName uin) {
        return uin.getLocation();
    }

    public static String getWebListenerClassName(UniqueName uin) {
        return uin.getName();
    }

    public static String getWebListenerClassFqn(UniqueName uin) {
        String packageName = WebModelMetaInfo.getWebListenerPackageName(uin);
        String className = WebModelMetaInfo.getWebListenerClassName(uin);
        if (packageName != null && packageName.trim().length() > 0) {
            className = packageName + '.' + className;
        }
        return className;
    }

    public static String getServletPackageName(UniqueName uin) {
        return uin.getLocation();
    }

    public static String getServletClassName(UniqueName uin) {
        return uin.getName();
    }

    public static String getServletClassFqn(UniqueName uin) {
        String packageName = WebModelMetaInfo.getServletPackageName(uin);
        String className = WebModelMetaInfo.getServletClassName(uin);
        if (packageName != null && packageName.trim().length() > 0) {
            className = packageName + '.' + className;
        }
        return className;
    }

    public static String getJspFileName(UniqueName uin) {
        return uin.getName();
    }

    public static UniqueName getUniqueName(IServlet servlet) {
        return WebModelMetaInfo.getSourceElementUniqueName((ISourceWebElement)servlet, SERVLET_METACLASS);
    }

    public static UniqueName getUniqueName(IFilter filter) {
        return WebModelMetaInfo.getSourceElementUniqueName((ISourceWebElement)filter, FILTER_METACLASS);
    }

    public static UniqueName getUniqueName(IJSP jsp) {
        if (jsp == null) {
            return null;
        }
        IFile file = jsp.getFile();
        return WebModelMetaInfo.getJSPUniqueName(file);
    }

    public static UniqueName getUniqueName(IHttpSessionAttributeListener listener) {
        return WebModelMetaInfo.getSourceElementUniqueName((ISourceWebElement)listener, HTTP_SESSION_ATTRIBUTE_LISTENER_METACLASS);
    }

    public static UniqueName getUniqueName(IHttpSessionActivationListener listener) {
        return WebModelMetaInfo.getSourceElementUniqueName((ISourceWebElement)listener, HTTP_SESSION_ACTIVATION_LISTENER_METACLASS);
    }

    public static UniqueName getUniqueName(IHttpSessionBindingListener listener) {
        return WebModelMetaInfo.getSourceElementUniqueName((ISourceWebElement)listener, HTTP_SESSION_BINDING_LISTENER_METACLASS);
    }

    public static UniqueName getUniqueName(IHttpSessionListener listener) {
        return WebModelMetaInfo.getSourceElementUniqueName((ISourceWebElement)listener, HTTP_SESSION_LISTENER_METACLASS);
    }

    public static UniqueName getUniqueName(IServletContextAttributeListener listener) {
        return WebModelMetaInfo.getSourceElementUniqueName((ISourceWebElement)listener, SERVLET_CONTEXT_ATTRIBUTE_LISTENER_METACLASS);
    }

    public static UniqueName getUniqueName(IServletContextListener listener) {
        return WebModelMetaInfo.getSourceElementUniqueName((ISourceWebElement)listener, SERVLET_CONTEXT_LISTENER_METACLASS);
    }

    private static UniqueName getSourceElementUniqueName(ISourceWebElement element, String metaclass) {
        String name;
        String location;
        if (element == null) {
            return null;
        }
        IType type = element.getType();
        if (type == null) {
            String fqn = element.getTypeName();
            int dotIndex = fqn.lastIndexOf(46);
            if (dotIndex == -1) {
                location = "";
                name = fqn;
            } else {
                location = fqn.substring(0, dotIndex);
                name = fqn.substring(dotIndex + 1);
            }
        } else {
            location = type.getPackageFragment().getElementName();
            name = type.getElementName();
        }
        return ModelAccess.createUniqueName((String)WEB_DOMAIN, (String)metaclass, (String)location, (String)name, null);
    }

    public static UniqueName getSourceElementUniqueName(String FQName, String metaclass) {
        String name;
        String location;
        int dotIndex = FQName.lastIndexOf(46);
        if (dotIndex == -1) {
            location = "";
            name = FQName;
        } else {
            location = FQName.substring(0, dotIndex);
            name = FQName.substring(dotIndex + 1);
        }
        return ModelAccess.createUniqueName((String)WEB_DOMAIN, (String)metaclass, (String)location, (String)name, null);
    }

    public static UniqueName getUniqueName(IWebMethod method) {
        String name = method.getName();
        ISourceWebElement parent = (ISourceWebElement)method.getParent();
        String parentFQN = parent.getTypeName();
        return ModelAccess.createUniqueName((String)WEB_DOMAIN, (String)WEB_METHOD_METACLASS, (String)parentFQN, (String)name, null);
    }

    public static UniqueName getElementUniqueNameForRegistryEntry(ReferenceUniqueName referenceUin, String registryType) {
        if (!WebModelMetaInfo.isRegistryUniqueName(referenceUin, registryType)) {
            return null;
        }
        String domain = referenceUin.getSubDomain();
        String subDomain = referenceUin.getLocation();
        String location = referenceUin.getName();
        String name = referenceUin.getParameter(0);
        int paramCount = referenceUin.getParametersCount() - 1;
        String[] parameters = new String[paramCount];
        int i = 0;
        while (i < paramCount) {
            parameters[i] = referenceUin.getParameter(i + 1);
            ++i;
        }
        UniqueName expectedDereferencedUin = ModelAccess.createUniqueName((String)domain, (String)subDomain, (String)location, (String)name, (String[])parameters);
        if (expectedDereferencedUin.equals(referenceUin.getReferencedUniqueName())) {
            return expectedDereferencedUin;
        }
        return null;
    }

    public static ReferenceUniqueName getRegistryUniqueName(UniqueName elementUin, String registryType) {
        String subDomain = elementUin.getDomain();
        String location = elementUin.getSubDomain();
        String name = elementUin.getLocation();
        int paramCount = elementUin.getParametersCount() + 1;
        String[] parameters = new String[paramCount];
        parameters[0] = elementUin.getName();
        int i = 1;
        while (i < paramCount) {
            parameters[i] = elementUin.getParameter(i - 1);
            ++i;
        }
        UniqueName baseRefUniqueName = ModelAccess.createUniqueName((String)registryType, (String)subDomain, (String)location, (String)name, (String[])parameters);
        return ModelAccess.createReferenceUniqueName((UniqueName)baseRefUniqueName, (UniqueName)elementUin);
    }

    public static boolean isRegistryUniqueName(ReferenceUniqueName referenceUin, String registryType) {
        if (!registryType.equals(referenceUin.getDomain())) {
            return false;
        }
        return referenceUin.getParametersCount() >= 1;
    }

    public static String getRegistryType(UniqueName registry) {
        return registry.getName();
    }

    public static UniqueName getRegistry(String registryType) {
        return ModelAccess.createUniqueName((String)REGISTRY_DOMAIN, null, (String)registryType);
    }

    public static UniqueName getRegistryForElement(IWebElement element) {
        String metaclass = WebModelMetaInfo.getMetaclass(element);
        return (UniqueName)METACLASSES_TO_REGISTRY_UINS.get(metaclass);
    }

    private static String getMetaclass(IWebElement element) {
        if (element instanceof IJSP) {
            return JSP_METACLASS;
        }
        if (element instanceof IServlet) {
            return SERVLET_METACLASS;
        }
        if (element instanceof IFilter) {
            return FILTER_METACLASS;
        }
        if (element instanceof IHttpSessionAttributeListener) {
            return HTTP_SESSION_ATTRIBUTE_LISTENER_METACLASS;
        }
        if (element instanceof IHttpSessionActivationListener) {
            return HTTP_SESSION_ACTIVATION_LISTENER_METACLASS;
        }
        if (element instanceof IHttpSessionBindingListener) {
            return HTTP_SESSION_BINDING_LISTENER_METACLASS;
        }
        if (element instanceof IHttpSessionListener) {
            return HTTP_SESSION_LISTENER_METACLASS;
        }
        if (element instanceof IServletContextAttributeListener) {
            return SERVLET_CONTEXT_ATTRIBUTE_LISTENER_METACLASS;
        }
        if (element instanceof IServletContextListener) {
            return SERVLET_CONTEXT_LISTENER_METACLASS;
        }
        return null;
    }

    public static UniqueName getJSPUniqueName(IFile jspFile) {
        String location = jspFile.getProject().getName();
        String name = jspFile.getProjectRelativePath().toString();
        return ModelAccess.createUniqueName((String)WEB_DOMAIN, (String)JSP_METACLASS, (String)location, (String)name, null);
    }

    public static UniqueName getRegistryForElement(String metaclass) {
        return (UniqueName)METACLASSES_TO_REGISTRY_UINS.get(metaclass);
    }

    public static UniqueName getWebContentElementUniqueName(IPath path, String subDomain) {
        String location = path.toString();
        String name = path.lastSegment();
        String[] parameters = null;
        UniqueName uin = ModelAccess.createUniqueName((String)WEB_DOMAIN, (String)subDomain, (String)location, (String)name, parameters);
        return uin;
    }

    public static UniqueName getWebContentElementUniqueName(IResource resource) {
        String location = resource.getFullPath().toString();
        String name = resource.getName();
        String[] parameters = null;
        String subDomain = "";
        if (resource instanceof IContainer) {
            subDomain = WEB_CONTENT;
        } else {
            String extension = resource.getFileExtension();
            if (JSP_FILE_EXTENSION.equals(extension)) {
                return WebModelMetaInfo.getJSPUniqueName((IFile)resource);
            }
            subDomain = HTML_FILE_EXTENSION.equals(extension) || HTM_FILE_EXTENSION.equals(extension) ? HTML_METACLASS : WEB_RESOURCE;
        }
        UniqueName uin = ModelAccess.createUniqueName((String)WEB_DOMAIN, (String)subDomain, (String)location, (String)name, parameters);
        return uin;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        METACLASSES_TO_REGISTRY_UINS.put(SERVLET_METACLASS, SERVLET_REGISTRY);
        METACLASSES_TO_REGISTRY_UINS.put(FILTER_METACLASS, FILTER_REGISTRY);
        METACLASSES_TO_REGISTRY_UINS.put(JSP_METACLASS, JSP_REGISTRY);
        METACLASSES_TO_REGISTRY_UINS.put(HTTP_SESSION_ATTRIBUTE_LISTENER_METACLASS, LISTENER_REGISTRY);
        METACLASSES_TO_REGISTRY_UINS.put(HTTP_SESSION_ACTIVATION_LISTENER_METACLASS, LISTENER_REGISTRY);
        METACLASSES_TO_REGISTRY_UINS.put(HTTP_SESSION_BINDING_LISTENER_METACLASS, LISTENER_REGISTRY);
        METACLASSES_TO_REGISTRY_UINS.put(HTTP_SESSION_LISTENER_METACLASS, LISTENER_REGISTRY);
        METACLASSES_TO_REGISTRY_UINS.put(SERVLET_CONTEXT_ATTRIBUTE_LISTENER_METACLASS, LISTENER_REGISTRY);
        METACLASSES_TO_REGISTRY_UINS.put(SERVLET_CONTEXT_LISTENER_METACLASS, LISTENER_REGISTRY);
        JSP_LOCATION_PROPERTY = (class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = WebModelMetaInfo.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile).getName();
        ITYPE_PROPERTY = (class$org$eclipse$jdt$core$IType == null ? (class$org$eclipse$jdt$core$IType = WebModelMetaInfo.class$("org.eclipse.jdt.core.IType")) : class$org$eclipse$jdt$core$IType).getName();
    }
}

