/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.util;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultDataEnconding;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class XMLValueEncoder {
    public static SOAPElement addSOAPElement(SOAPEnvelope envelope, SOAPElement parent, String nameOfElement, String prefix, String attribute, String type, Object objectToSerialize, ISOAPMessageContext context) throws SOAPServiceException {
        try {
            Name childName = null;
            childName = context.isDocumentStyleEncoding() ? envelope.createName(nameOfElement, context.getPrefixForNamespace(context.getTargetNamespaceMethod()), context.getTargetNamespaceMethod()) : (context.getTargetNamespaceMethod() != null ? envelope.createName(nameOfElement, context.getPrefixForNamespace(context.getTargetNamespaceMethod()), context.getTargetNamespaceMethod()) : envelope.createName(nameOfElement));
            SOAPElement elementToCreate = null;
            elementToCreate = context.isDocumentStyleEncoding() && context.isSimpleTypeCurrentProcess() ? parent : parent.addChildElement(childName);
            Name typeName = XMLValueEncoder.generateName(envelope, attribute, prefix, context);
            if (!context.isLitteralStyleEncoding() && type != null) {
                elementToCreate.addAttribute(typeName, type);
            }
            return elementToCreate;
        }
        catch (Exception ex) {
            throw new PRTFaultDataEnconding((Object)null, ex);
        }
    }

    public static void AddNullAttribute(SOAPEnvelope envelope, SOAPElement element, ISOAPMessageContext context) throws SOAPException {
        if (!context.isDocumentStyleEncoding()) {
            Name attr = envelope.createName("nil", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.addAttribute(attr, "true");
        } else {
            element.detachNode();
        }
    }

    private static Name generateName(SOAPEnvelope envelope, String type, String prefix, ISOAPMessageContext context) throws SOAPServiceException {
        try {
            return envelope.createName(type, prefix, context.getNamespaceFromPrefix(prefix));
        }
        catch (Exception ex) {
            throw new PRTFaultDataEnconding((Object)null, ex);
        }
    }

    public static String constructValueForArrayOfArray(String encodedStyle, String type, int size, ISOAPMessageContext context) {
        String prefix = context.getPrefixForNamespace(encodedStyle);
        if (prefix == null) {
            prefix = context.addNamespaceDeclaration(encodedStyle);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(":");
        buf.append(type);
        buf.append("[]");
        buf.append("[");
        buf.append(size);
        buf.append("]");
        return buf.toString();
    }

    public static String contructValueForArray(String encodedStyle, String type, int size, ISOAPMessageContext context) {
        String prefix = context.getPrefixForNamespace(encodedStyle);
        if (prefix == null) {
            prefix = context.addNamespaceDeclaration(encodedStyle);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(":");
        buf.append(type);
        buf.append("[");
        buf.append(size);
        buf.append("]");
        return buf.toString();
    }

    public static String contructValueForArray(String encodedStyle, String type, int sizeRaws, int sizeColumns, ISOAPMessageContext context) {
        String prefix = context.getPrefixForNamespace(encodedStyle);
        if (prefix == null) {
            prefix = context.addNamespaceDeclaration(encodedStyle);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(":");
        buf.append(type);
        buf.append("[");
        buf.append(sizeRaws);
        buf.append(",");
        buf.append(sizeColumns);
        buf.append("]");
        return buf.toString();
    }

    public static String constructValueforType(String namespace, String type, ISOAPMessageContext context) {
        String prefix = context.getPrefixForNamespace(namespace);
        if (prefix == null) {
            prefix = context.addNamespaceDeclaration(namespace);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(":");
        buf.append(type);
        return buf.toString();
    }

    public static boolean isNullable(Class type) {
        return !type.isPrimitive() && (!type.isArray() || !type.getComponentType().isPrimitive());
    }

    public static ByteArrayOutputStream convertFromException(Exception target) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(stream);
        target.printStackTrace(ps);
        ps.close();
        return stream;
    }

    public static ByteArrayOutputStream convertFromException(Throwable target) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(stream);
        target.printStackTrace(ps);
        ps.close();
        return stream;
    }

    public static String cleanNameClass(Class clazz, boolean shortname) {
        if (clazz == null) {
            System.out.println();
        }
        String type = clazz.getName();
        String newtype = "";
        if (clazz.isArray()) {
            int indexChar = type.lastIndexOf("[") + 1;
            switch (type.charAt(indexChar)) {
                case 'B': {
                    newtype = newtype + "byte";
                    break;
                }
                case 'C': {
                    newtype = newtype + "char";
                    break;
                }
                case 'D': {
                    newtype = newtype + "double";
                    break;
                }
                case 'F': {
                    newtype = newtype + "float";
                    break;
                }
                case 'I': {
                    newtype = newtype + "int";
                    break;
                }
                case 'J': {
                    newtype = newtype + "long";
                    break;
                }
                case 'L': {
                    newtype = type.substring(indexChar + 1, type.length() - 1);
                    break;
                }
                case 'S': {
                    newtype = newtype + "short";
                    break;
                }
                case 'Z': {
                    newtype = newtype + "boolean";
                    break;
                }
                case 'V': {
                    newtype = newtype + "void";
                    break;
                }
                default: {
                    newtype = newtype + "Object";
                }
            }
            int i = 0;
            while (i < type.length()) {
                if (type.charAt(i) == '[') {
                    newtype = newtype + "[]";
                }
                ++i;
            }
        } else if (shortname) {
            StringTokenizer ps = new StringTokenizer(type, ".");
            if (ps.countTokens() > 1) {
                while (ps.hasMoreElements()) {
                    newtype = ps.nextToken();
                }
            } else {
                newtype = type;
            }
        } else {
            newtype = type;
        }
        return newtype.replace('$', '.');
    }

    public static void addXMLNSDocumentForNode(String nameElement, String tnsElement, SOAPElement parentBodyElement) throws SOAPException {
        Iterator iterator = parentBodyElement.getChildElements();
        while (iterator.hasNext()) {
            SOAPElement element = (SOAPElement)iterator.next();
            if (!element.getElementName().getLocalName().equals(nameElement)) continue;
            element.addNamespaceDeclaration("", tnsElement);
        }
    }

    public static boolean testNillableInDocument(Object objectToSerialize, ISOAPMessageContext context, Class elementType) {
        return context.isDocumentStyleEncoding() && objectToSerialize == null && XMLValueEncoder.isNullable(elementType);
    }
}

