/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.util;

import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMappingInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.soap.SOAPException;

public class FactoryFinder {
    private static final String ERROR_MSG = "Provider could not found an Implementation of this interface : ";
    private HashMap mm_listInterfaceToImplementation = null;
    private HashMap mm_ImplementationTolistInterface = null;
    private boolean mm_mappingInit = false;

    public FactoryFinder(IPortalWebService portalService) {
        if (portalService.getPortalWebServiceMappingInterface() != null && portalService.getPortalWebServiceMappingInterface().getAllInterfaceMapped().length > 0) {
            this.mm_listInterfaceToImplementation = new HashMap();
            this.mm_ImplementationTolistInterface = new HashMap();
            IPortalWebServiceMappingInterface listMapping = portalService.getPortalWebServiceMappingInterface();
            String[] listInterface = listMapping.getAllInterfaceMapped();
            int i = 0;
            while (i < listInterface.length) {
                String nameClass = listMapping.getImplementation(listInterface[i]);
                this.mm_listInterfaceToImplementation.put(listInterface[i], nameClass);
                this.mm_ImplementationTolistInterface.put(nameClass, listInterface[i]);
                ++i;
            }
            this.mm_mappingInit = true;
        } else {
            this.mm_mappingInit = false;
        }
    }

    public FactoryFinder(Properties fileTable) {
        try {
            if (fileTable != null && ((Hashtable)fileTable).size() > 0 && !((Hashtable)fileTable).isEmpty()) {
                this.mm_listInterfaceToImplementation = new HashMap();
                this.mm_ImplementationTolistInterface = new HashMap();
                Enumeration<?> enumeration = fileTable.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String namePropertie = (String)enumeration.nextElement();
                    String propertie = fileTable.getProperty(namePropertie);
                    this.mm_listInterfaceToImplementation.put(namePropertie, propertie);
                    this.mm_ImplementationTolistInterface.put(propertie, namePropertie);
                }
                this.mm_mappingInit = true;
            } else {
                this.mm_mappingInit = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mm_mappingInit = false;
        }
    }

    private Class loadClass(String s, ClassLoader classloader) throws SOAPException {
        try {
            Class<?> class1 = classloader == null ? Class.forName(s) : classloader.loadClass(s);
            return class1;
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new SOAPException("Provider " + s + " not found", (Throwable)classnotfoundexception);
        }
    }

    private Object newInstance(String s, ClassLoader classloader) throws SOAPException {
        try {
            Class class1 = this.loadClass(s, classloader);
            if (class1 != null) {
                return class1.newInstance();
            }
            return null;
        }
        catch (SOAPException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new SOAPException("Provider " + s + " could not be instantiated: " + exception, (Throwable)exception);
        }
    }

    private Object find(String name, ClassLoader cl) throws SOAPException {
        ClassLoader classloader;
        try {
            classloader = cl == null ? this.getClass().getClassLoader() : cl;
        }
        catch (Exception exception) {
            throw new SOAPException(exception.toString(), (Throwable)exception);
        }
        try {
            return this.newInstance(name, classloader);
        }
        catch (SecurityException securityexception) {
            throw new SOAPException("SecurityException for instantiated the object  : " + securityexception, (Throwable)securityexception);
        }
        catch (SOAPException exception) {
            throw exception;
        }
        catch (Exception exception2) {
            throw new SOAPException(ERROR_MSG + exception2, (Throwable)exception2);
        }
    }

    private Object findImplementationOfInterface(String name_interface, ClassLoader cl) throws SOAPException {
        if (this.mm_mappingInit) {
            try {
                String name_Implementation = (String)this.mm_listInterfaceToImplementation.get(name_interface);
                if (name_Implementation != null) {
                    return this.find(name_Implementation, cl);
                }
                return null;
            }
            catch (SOAPException exception) {
                throw exception;
            }
            catch (Exception exception2) {
                throw new SOAPException(ERROR_MSG + exception2, (Throwable)exception2);
            }
        }
        return null;
    }

    public Object getInstance(String clazz, ClassLoader cl) throws SOAPException {
        try {
            return this.find(clazz, cl);
        }
        catch (SOAPException exception) {
            throw exception;
        }
        catch (Exception exception2) {
            throw new SOAPException(ERROR_MSG + exception2, (Throwable)exception2);
        }
    }

    public Object getInstance(Class clazz, ClassLoader cl) throws SOAPException {
        try {
            if (clazz.isInterface()) {
                return this.findImplementationOfInterface(clazz.getName(), cl);
            }
            return this.find(clazz.getName(), cl);
        }
        catch (SOAPException exception) {
            throw exception;
        }
        catch (Exception exception2) {
            throw new SOAPException(ERROR_MSG + exception2, (Throwable)exception2);
        }
    }
}

