/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.util;

import com.sapportals.portal.prt.service.soap.util.CharType;

public class CharTypeSolver {
    private static CharType mm_baseChar;
    private static CharType mm_ideographic;
    private static CharType mm_combiningChar;
    private static CharType mm_digit;
    private static CharType mm_extender;
    private static CharType mm_char;
    private static CharType mm_whiteSpace;

    public static void initCharTypes() {
        CharTypeSolver.initBaseChar();
        CharTypeSolver.initIdeographic();
        CharTypeSolver.initCombiningChar();
        CharTypeSolver.initDigit();
        CharTypeSolver.initExtender();
        CharTypeSolver.initChar();
        CharTypeSolver.initWhiteSpace();
    }

    private static void initBaseChar() {
        mm_baseChar = new CharType();
        mm_baseChar.addRange(65, 90);
        mm_baseChar.addRange(97, 122);
        mm_baseChar.addRange(192, 214);
        mm_baseChar.addRange(216, 246);
        mm_baseChar.addRange(248, 255);
        mm_baseChar.addRange(256, 305);
        mm_baseChar.addRange(308, 318);
        mm_baseChar.addRange(321, 328);
        mm_baseChar.addRange(330, 382);
        mm_baseChar.addRange(384, 451);
        mm_baseChar.addRange(461, 496);
        mm_baseChar.addRange(500, 501);
        mm_baseChar.addRange(506, 535);
        mm_baseChar.addRange(592, 680);
        mm_baseChar.addRange(699, 705);
        mm_baseChar.addRange(902);
        mm_baseChar.addRange(904, 906);
        mm_baseChar.addRange(908);
        mm_baseChar.addRange(910, 929);
        mm_baseChar.addRange(931, 974);
        mm_baseChar.addRange(976, 982);
        mm_baseChar.addRange(986);
        mm_baseChar.addRange(988);
        mm_baseChar.addRange(990);
        mm_baseChar.addRange(992);
        mm_baseChar.addRange(994, 1011);
        mm_baseChar.addRange(1025, 1036);
        mm_baseChar.addRange(1038, 1103);
        mm_baseChar.addRange(1105, 1116);
        mm_baseChar.addRange(1118, 1153);
        mm_baseChar.addRange(1168, 1220);
        mm_baseChar.addRange(1223, 1224);
        mm_baseChar.addRange(1227, 1228);
        mm_baseChar.addRange(1232, 1259);
        mm_baseChar.addRange(1262, 1269);
        mm_baseChar.addRange(1272, 1273);
        mm_baseChar.addRange(1329, 1366);
        mm_baseChar.addRange(1369);
        mm_baseChar.addRange(1377, 1414);
        mm_baseChar.addRange(1488, 1514);
        mm_baseChar.addRange(1520, 1522);
        mm_baseChar.addRange(1569, 1594);
        mm_baseChar.addRange(1601, 1610);
        mm_baseChar.addRange(1649, 1719);
        mm_baseChar.addRange(1722, 1726);
        mm_baseChar.addRange(1728, 1742);
        mm_baseChar.addRange(1744, 1747);
        mm_baseChar.addRange(1749);
        mm_baseChar.addRange(1765, 1766);
        mm_baseChar.addRange(2309, 2361);
        mm_baseChar.addRange(2365);
        mm_baseChar.addRange(2392, 2401);
        mm_baseChar.addRange(2437, 2444);
        mm_baseChar.addRange(2447, 2448);
        mm_baseChar.addRange(2451, 2472);
        mm_baseChar.addRange(2474, 2480);
        mm_baseChar.addRange(2482);
        mm_baseChar.addRange(2486, 2489);
        mm_baseChar.addRange(2524, 2525);
        mm_baseChar.addRange(2527, 2529);
        mm_baseChar.addRange(2544, 2545);
        mm_baseChar.addRange(2565, 2570);
        mm_baseChar.addRange(2575, 2576);
        mm_baseChar.addRange(2579, 2600);
        mm_baseChar.addRange(2602, 2608);
        mm_baseChar.addRange(2610, 2611);
        mm_baseChar.addRange(2613, 2614);
        mm_baseChar.addRange(2616, 2617);
        mm_baseChar.addRange(2649, 2652);
        mm_baseChar.addRange(2654);
        mm_baseChar.addRange(2674, 2676);
        mm_baseChar.addRange(2693, 2699);
        mm_baseChar.addRange(2701);
        mm_baseChar.addRange(2703, 2705);
        mm_baseChar.addRange(2707, 2728);
        mm_baseChar.addRange(2730, 2736);
        mm_baseChar.addRange(2738, 2739);
        mm_baseChar.addRange(2741, 2745);
        mm_baseChar.addRange(2749);
        mm_baseChar.addRange(2784);
        mm_baseChar.addRange(2821, 2828);
        mm_baseChar.addRange(2831, 2832);
        mm_baseChar.addRange(2835, 2856);
        mm_baseChar.addRange(2858, 2864);
        mm_baseChar.addRange(2866, 2867);
        mm_baseChar.addRange(2870, 2873);
        mm_baseChar.addRange(2877);
        mm_baseChar.addRange(2908, 2909);
        mm_baseChar.addRange(2911, 2913);
        mm_baseChar.addRange(2949, 2954);
        mm_baseChar.addRange(2958, 2960);
        mm_baseChar.addRange(2962, 2965);
        mm_baseChar.addRange(2969, 2970);
        mm_baseChar.addRange(2972);
        mm_baseChar.addRange(2974, 2975);
        mm_baseChar.addRange(2979, 2980);
        mm_baseChar.addRange(2984, 2986);
        mm_baseChar.addRange(2990, 2997);
        mm_baseChar.addRange(2999, 3001);
        mm_baseChar.addRange(3077, 3084);
        mm_baseChar.addRange(3086, 3088);
        mm_baseChar.addRange(3090, 3112);
        mm_baseChar.addRange(3114, 3123);
        mm_baseChar.addRange(3125, 3129);
        mm_baseChar.addRange(3168, 3169);
        mm_baseChar.addRange(3205, 3212);
        mm_baseChar.addRange(3214, 3216);
        mm_baseChar.addRange(3218, 3240);
        mm_baseChar.addRange(3242, 3251);
        mm_baseChar.addRange(3253, 3257);
        mm_baseChar.addRange(3294);
        mm_baseChar.addRange(3296, 3297);
        mm_baseChar.addRange(3333, 3340);
        mm_baseChar.addRange(3342, 3344);
        mm_baseChar.addRange(3346, 3368);
        mm_baseChar.addRange(3370, 3385);
        mm_baseChar.addRange(3424, 3425);
        mm_baseChar.addRange(3585, 3630);
        mm_baseChar.addRange(3632);
        mm_baseChar.addRange(3634, 3635);
        mm_baseChar.addRange(3648, 3653);
        mm_baseChar.addRange(3713, 3714);
        mm_baseChar.addRange(3716);
        mm_baseChar.addRange(3719, 3720);
        mm_baseChar.addRange(3722);
        mm_baseChar.addRange(3725);
        mm_baseChar.addRange(3732, 3735);
        mm_baseChar.addRange(3737, 3743);
        mm_baseChar.addRange(3745, 3747);
        mm_baseChar.addRange(3749);
        mm_baseChar.addRange(3751);
        mm_baseChar.addRange(3754, 3755);
        mm_baseChar.addRange(3757, 3758);
        mm_baseChar.addRange(3760);
        mm_baseChar.addRange(3762, 3763);
        mm_baseChar.addRange(3773);
        mm_baseChar.addRange(3776, 3780);
        mm_baseChar.addRange(3904, 3911);
        mm_baseChar.addRange(3913, 3945);
        mm_baseChar.addRange(4256, 4293);
        mm_baseChar.addRange(4304, 4342);
        mm_baseChar.addRange(4352);
        mm_baseChar.addRange(4354, 4355);
        mm_baseChar.addRange(4357, 4359);
        mm_baseChar.addRange(4361);
        mm_baseChar.addRange(4363, 4364);
        mm_baseChar.addRange(4366, 4370);
        mm_baseChar.addRange(4412);
        mm_baseChar.addRange(4414);
        mm_baseChar.addRange(4416);
        mm_baseChar.addRange(4428);
        mm_baseChar.addRange(4430);
        mm_baseChar.addRange(4432);
        mm_baseChar.addRange(4436, 4437);
        mm_baseChar.addRange(4441);
        mm_baseChar.addRange(4447, 4449);
        mm_baseChar.addRange(4451);
        mm_baseChar.addRange(4453);
        mm_baseChar.addRange(4455);
        mm_baseChar.addRange(4457);
        mm_baseChar.addRange(4461, 4462);
        mm_baseChar.addRange(4466, 4467);
        mm_baseChar.addRange(4469);
        mm_baseChar.addRange(4510);
        mm_baseChar.addRange(4520);
        mm_baseChar.addRange(4523);
        mm_baseChar.addRange(4526, 4527);
        mm_baseChar.addRange(4535, 4536);
        mm_baseChar.addRange(4538);
        mm_baseChar.addRange(4540, 4546);
        mm_baseChar.addRange(4587);
        mm_baseChar.addRange(4592);
        mm_baseChar.addRange(4601);
        mm_baseChar.addRange(7680, 7835);
        mm_baseChar.addRange(7840, 7929);
        mm_baseChar.addRange(7936, 7957);
        mm_baseChar.addRange(7960, 7965);
        mm_baseChar.addRange(7968, 8005);
        mm_baseChar.addRange(8008, 8013);
        mm_baseChar.addRange(8016, 8023);
        mm_baseChar.addRange(8025);
        mm_baseChar.addRange(8027);
        mm_baseChar.addRange(8029);
        mm_baseChar.addRange(8031, 8061);
        mm_baseChar.addRange(8064, 8116);
        mm_baseChar.addRange(8118, 8124);
        mm_baseChar.addRange(8126);
        mm_baseChar.addRange(8130, 8132);
        mm_baseChar.addRange(8134, 8140);
        mm_baseChar.addRange(8144, 8147);
        mm_baseChar.addRange(8150, 8155);
        mm_baseChar.addRange(8160, 8172);
        mm_baseChar.addRange(8178, 8180);
        mm_baseChar.addRange(8182, 8188);
        mm_baseChar.addRange(8486);
        mm_baseChar.addRange(8490, 8491);
        mm_baseChar.addRange(8494);
        mm_baseChar.addRange(8576, 8578);
        mm_baseChar.addRange(12353, 12436);
        mm_baseChar.addRange(12449, 12538);
        mm_baseChar.addRange(12549, 12588);
        mm_baseChar.addRange(44032, 55203);
    }

    private static void initIdeographic() {
        mm_ideographic = new CharType();
        mm_ideographic.addRange(19968, 40869);
        mm_ideographic.addRange(12295);
        mm_ideographic.addRange(12321, 197264);
    }

    private static void initCombiningChar() {
        mm_combiningChar = new CharType();
        mm_combiningChar.addRange(768, 837);
        mm_combiningChar.addRange(864, 865);
        mm_combiningChar.addRange(1155, 1158);
        mm_combiningChar.addRange(1425, 1441);
        mm_combiningChar.addRange(1443, 1465);
        mm_combiningChar.addRange(1467, 1469);
        mm_combiningChar.addRange(1471);
        mm_combiningChar.addRange(1473, 1474);
        mm_combiningChar.addRange(1476);
        mm_combiningChar.addRange(1611, 1618);
        mm_combiningChar.addRange(1648);
        mm_combiningChar.addRange(1750, 1756);
        mm_combiningChar.addRange(1757, 1759);
        mm_combiningChar.addRange(1760, 1764);
        mm_combiningChar.addRange(1767, 1768);
        mm_combiningChar.addRange(1770, 1773);
        mm_combiningChar.addRange(2305, 2307);
        mm_combiningChar.addRange(2364);
        mm_combiningChar.addRange(2366, 2380);
        mm_combiningChar.addRange(2381);
        mm_combiningChar.addRange(2385, 2388);
        mm_combiningChar.addRange(2402, 2403);
        mm_combiningChar.addRange(2433, 2435);
        mm_combiningChar.addRange(2492);
        mm_combiningChar.addRange(2494);
        mm_combiningChar.addRange(2495);
        mm_combiningChar.addRange(2496, 2500);
        mm_combiningChar.addRange(2503, 2504);
        mm_combiningChar.addRange(2507, 2509);
        mm_combiningChar.addRange(2519);
        mm_combiningChar.addRange(2530, 2531);
        mm_combiningChar.addRange(2562);
        mm_combiningChar.addRange(2620);
        mm_combiningChar.addRange(2622);
        mm_combiningChar.addRange(2623);
        mm_combiningChar.addRange(2624, 2626);
        mm_combiningChar.addRange(2631, 2632);
        mm_combiningChar.addRange(2635, 2637);
        mm_combiningChar.addRange(2672, 2673);
        mm_combiningChar.addRange(2689, 2691);
        mm_combiningChar.addRange(2748);
        mm_combiningChar.addRange(2750, 2757);
        mm_combiningChar.addRange(2759, 2761);
        mm_combiningChar.addRange(2763, 2765);
        mm_combiningChar.addRange(2817, 2819);
        mm_combiningChar.addRange(2876);
        mm_combiningChar.addRange(2878, 2883);
        mm_combiningChar.addRange(2887, 2888);
        mm_combiningChar.addRange(2891, 2893);
        mm_combiningChar.addRange(2902, 2903);
        mm_combiningChar.addRange(2946, 2947);
        mm_combiningChar.addRange(3006, 3010);
        mm_combiningChar.addRange(3014, 3016);
        mm_combiningChar.addRange(3018, 3021);
        mm_combiningChar.addRange(3031);
        mm_combiningChar.addRange(3073, 3075);
        mm_combiningChar.addRange(3134, 3140);
        mm_combiningChar.addRange(3142, 3144);
        mm_combiningChar.addRange(3146, 3149);
        mm_combiningChar.addRange(3157, 3158);
        mm_combiningChar.addRange(3202, 3203);
        mm_combiningChar.addRange(3262, 3268);
        mm_combiningChar.addRange(3270, 3272);
        mm_combiningChar.addRange(3274, 3277);
        mm_combiningChar.addRange(3285, 3286);
        mm_combiningChar.addRange(3330, 3331);
        mm_combiningChar.addRange(3390, 3395);
        mm_combiningChar.addRange(3398, 3400);
        mm_combiningChar.addRange(3402, 3405);
        mm_combiningChar.addRange(3415);
        mm_combiningChar.addRange(3633);
        mm_combiningChar.addRange(3636, 3642);
        mm_combiningChar.addRange(3655, 3662);
        mm_combiningChar.addRange(3761);
        mm_combiningChar.addRange(3764, 3769);
        mm_combiningChar.addRange(3771, 3772);
        mm_combiningChar.addRange(3784, 3789);
        mm_combiningChar.addRange(3864, 3865);
        mm_combiningChar.addRange(3893);
        mm_combiningChar.addRange(3895);
        mm_combiningChar.addRange(3897);
        mm_combiningChar.addRange(3902);
        mm_combiningChar.addRange(3903);
        mm_combiningChar.addRange(3953, 3972);
        mm_combiningChar.addRange(3974, 3979);
        mm_combiningChar.addRange(3984, 3989);
        mm_combiningChar.addRange(3991);
        mm_combiningChar.addRange(3993, 4013);
        mm_combiningChar.addRange(4017, 4023);
        mm_combiningChar.addRange(4025);
        mm_combiningChar.addRange(8400, 8412);
        mm_combiningChar.addRange(8417);
        mm_combiningChar.addRange(12330, 12335);
        mm_combiningChar.addRange(12441);
        mm_combiningChar.addRange(12442);
    }

    private static void initDigit() {
        mm_digit = new CharType();
        mm_digit.addRange(48, 57);
        mm_digit.addRange(1632, 1641);
        mm_digit.addRange(1776, 1785);
        mm_digit.addRange(2406, 2415);
        mm_digit.addRange(2534, 2543);
        mm_digit.addRange(2662, 2671);
        mm_digit.addRange(2790, 2799);
        mm_digit.addRange(2918, 2927);
        mm_digit.addRange(3047, 3055);
        mm_digit.addRange(3174, 3183);
        mm_digit.addRange(3302, 3311);
        mm_digit.addRange(3430, 3439);
        mm_digit.addRange(3664, 3673);
        mm_digit.addRange(3792, 3801);
        mm_digit.addRange(3872, 3881);
    }

    private static void initExtender() {
        mm_extender = new CharType();
        mm_extender.addRange(183);
        mm_extender.addRange(720);
        mm_extender.addRange(721);
        mm_extender.addRange(903);
        mm_extender.addRange(1600);
        mm_extender.addRange(3654);
        mm_extender.addRange(3782);
        mm_extender.addRange(12293);
        mm_extender.addRange(12337, 12341);
        mm_extender.addRange(12445, 12446);
        mm_extender.addRange(12540, 12542);
    }

    private static void initChar() {
        mm_char = new CharType();
        mm_char.addRange(9);
        mm_char.addRange(10);
        mm_char.addRange(13);
        mm_char.addRange(32, 884720);
        mm_char.addRange(57344, 1048528);
        mm_char.addRange(65536, 0x10FFFF);
    }

    private static void initWhiteSpace() {
        mm_whiteSpace = new CharType();
        mm_whiteSpace.addRange(32);
        mm_whiteSpace.addRange(9);
        mm_whiteSpace.addRange(13);
        mm_whiteSpace.addRange(10);
    }

    public static boolean isNCNameChar(int value) {
        return CharTypeSolver.isLetter(value) || CharTypeSolver.isDigit(value) || CharTypeSolver.isCombiningChar(value) || CharTypeSolver.isExtender(value) || value == 46 || value == 45 || value == 95;
    }

    public static boolean isNameChar(int value) {
        return CharTypeSolver.isLetter(value) || CharTypeSolver.isDigit(value) || CharTypeSolver.isCombiningChar(value) || CharTypeSolver.isExtender(value) || value == 46 || value == 45 || value == 95 || value == 58;
    }

    public static boolean isLetter(int value) {
        return mm_baseChar.isInRanges(value) || mm_ideographic.isInRanges(value);
    }

    public static boolean isBaseChar(int value) {
        return mm_baseChar.isInRanges(value);
    }

    public static boolean isIdeographic(int value) {
        return mm_ideographic.isInRanges(value);
    }

    public static boolean isCombiningChar(int value) {
        return mm_combiningChar.isInRanges(value);
    }

    public static boolean isDigit(int value) {
        return mm_digit.isInRanges(value);
    }

    public static boolean isExtender(int value) {
        return mm_extender.isInRanges(value);
    }

    public static boolean isChar(int value) {
        return mm_char.isInRanges(value);
    }

    public static boolean isWhiteSpace(int value) {
        return mm_whiteSpace.isInRanges(value);
    }

    public static void main(String[] args) {
        try {
            System.out.println("Initializing char types ....");
            CharTypeSolver.initCharTypes();
            System.out.println("Initializing done");
            int c = 49;
            System.out.println("Rep:" + CharTypeSolver.isBaseChar(c));
            System.out.println("Char type solver done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

