/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import java.math.BigInteger;

public class UnsignedLong {
    public static BigInteger MAX_VALUE = new BigInteger("2").pow(64).add(new BigInteger("-1"));
    public static BigInteger MIN_VALUE = new BigInteger("0");
    private String mm_content = null;
    private BigInteger mm_value = null;

    public UnsignedLong(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Lexical Representation Error: String to be analyzed cannot be empty");
        }
        this.mm_content = s;
        try {
            this.mm_value = new BigInteger(s);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Lexical Representation Error: bad representation of UnsignedLong ");
        }
        if (this.mm_value.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Lexical Representation Error: Unsigned long value of maxInclusive is 2^64-1");
        }
        if (this.mm_value.compareTo(MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Lexical Representation Error: Unsigned Long value of +minInclusive+ is 0 ");
        }
    }

    public String toString() {
        return this.mm_value.toString();
    }

    public String getContent() {
        return this.mm_content;
    }

    public BigInteger getValue() {
        return this.mm_value;
    }

    public void setContent(String string) {
        this.mm_content = string;
    }

    public void setValue(BigInteger integer) {
        this.mm_value = integer;
    }

    public static void main(String[] args) {
        try {
            UnsignedLong ul = new UnsignedLong("1");
            System.out.println(ul.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

