/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SOAPDate {
    private static int MIN_LENGTH = 10;
    private Date mm_value = null;
    private String mm_content = null;

    public SOAPDate(String exp) {
        if (exp == null) {
            throw new IllegalArgumentException("Data Error: empty Date data type to deserialize");
        }
        this.mm_content = exp;
        this.mm_value = this.constructDateObject(exp);
    }

    private Date constructDateObject(String d) throws IllegalArgumentException {
        Date javaDate = null;
        String date = null;
        String timeZone = null;
        int signOffset = 0;
        if (d.length() < MIN_LENGTH) {
            throw new IllegalArgumentException("Lexical Representation Error: Bad Format, must be CCYY-MM-DD");
        }
        try {
            int timeZoneIndex = d.indexOf(43);
            if (timeZoneIndex != -1) {
                timeZone = d.substring(timeZoneIndex + 1);
                signOffset = 1;
            } else {
                timeZoneIndex = d.lastIndexOf(45);
                if (timeZoneIndex != -1 && timeZoneIndex >= MIN_LENGTH) {
                    timeZone = d.substring(timeZoneIndex + 1);
                    signOffset = -1;
                } else {
                    timeZoneIndex = d.indexOf(90);
                    if (timeZoneIndex != -1) {
                        timeZone = null;
                        signOffset = 0;
                    }
                }
            }
            date = d.substring(0, MIN_LENGTH);
            GregorianCalendar calendarValue = this.constructDate(date);
            if (timeZone != null) {
                int offset = Integer.parseInt(timeZone.substring(0, timeZone.indexOf(":")));
                SimpleTimeZone pdt = new SimpleTimeZone(signOffset * offset * 60 * 60 * 1000, "ZZZ");
                ((Calendar)calendarValue).setTimeZone(pdt);
                TimeZone.getAvailableIDs();
            }
            javaDate = calendarValue.getTime();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Lexical Representation Error: Bad Format, must be CCYY-MM-DD");
        }
        return javaDate;
    }

    private GregorianCalendar constructDate(String date) {
        try {
            StringTokenizer ps = new StringTokenizer(date, "-");
            int year = Integer.parseInt(ps.nextToken());
            int month = Integer.parseInt(ps.nextToken()) - 1;
            int day = Integer.parseInt(ps.nextToken());
            GregorianCalendar calendar = new GregorianCalendar(year, month, day);
            return calendar;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRepresentation() {
        SimpleDateFormat formatdate = new SimpleDateFormat("yyyy-MM-dd");
        return formatdate.format(this.mm_value);
    }

    public static void main(String[] args) {
        SOAPDate d = new SOAPDate("2003-08-13");
        System.out.println("Date : " + d.getRepresentation());
    }
}

