/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

public class NonPositiveInteger {
    private String mm_content = null;
    private int mm_value;
    private boolean mm_hasMinusSign = true;

    public NonPositiveInteger(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Lexical Representation Error: String to be analyzed cannot be empty");
        }
        this.mm_content = s;
        if (s.charAt(0) != '-') {
            this.mm_hasMinusSign = false;
            int i = 0;
            while (i < s.length() && s.charAt(i) == '0') {
                ++i;
            }
            if (i != s.length()) {
                throw new IllegalArgumentException("Lexical Representation Error: sign is optionnal only if followed by a sequence of all zero, NonPositiveInteger is integer with maxinclusive value of zero");
            }
        }
        try {
            this.mm_value = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Lexical Representation Error: cannot convert representation into integer with radix 10");
        }
        if (this.mm_value > 0) {
            throw new IllegalArgumentException("Lexical Representation Error: the value of maxInclusive must be 0");
        }
    }

    public String toString() {
        return Integer.toString(this.mm_value);
    }

    public String getContent() {
        return this.mm_content;
    }

    public int getValue() {
        return this.mm_value;
    }

    public void setContent(String string) {
        this.mm_content = string;
    }

    public void setValue(int i) {
        this.mm_value = i;
    }

    public static void main(String[] args) {
        try {
            NonPositiveInteger npi = new NonPositiveInteger("15611");
            System.out.println(npi.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

