/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import java.io.ByteArrayOutputStream;

public class Hex {
    private byte[] mm_number;
    private String WRONG_NUMBER_OF_BYTES = "Wrong number of bytes in the array";
    private String WRONG_CHARACTER_IN_STRING = "Wrong character in the string";

    public Hex() {
        this.mm_number = null;
    }

    public Hex(String stringNumber) {
        this.mm_number = this.decode(stringNumber);
    }

    public Hex(byte[] arrayNumber) {
        this.mm_number = arrayNumber;
    }

    public byte[] getBytes() {
        return this.mm_number;
    }

    public String toString() {
        return Hex.encode(this.mm_number);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        String string1 = object.toString();
        String string2 = this.toString();
        return string1.equals(string2);
    }

    private byte[] decode(String stringNumber) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int i = 0;
        while (i < stringNumber.length()) {
            char char1 = stringNumber.charAt(i);
            if (i + 1 >= stringNumber.length()) {
                throw new IllegalArgumentException(this.WRONG_NUMBER_OF_BYTES);
            }
            char char2 = stringNumber.charAt(i + 1);
            int myByte = 0;
            if (char1 >= '0' && char1 <= '9') {
                myByte = (byte)(myByte + (char1 - 48) * 16);
            } else if (char1 >= 'a' && char1 <= 'f') {
                myByte = (byte)(myByte + (char1 - 97 + 10) * 16);
            } else if (char1 >= 'A' && char1 <= 'F') {
                myByte = (byte)(myByte + (char1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException(this.WRONG_CHARACTER_IN_STRING);
            }
            if (char2 >= '0' && char2 <= '9') {
                myByte = (byte)(myByte + (char2 - 48));
            } else if (char2 >= 'a' && char2 <= 'f') {
                myByte = (byte)(myByte + (char2 - 97 + 10));
            } else if (char2 >= 'A' && char2 <= 'F') {
                myByte = (byte)(myByte + (char2 - 65 + 10));
            } else {
                throw new IllegalArgumentException(this.WRONG_CHARACTER_IN_STRING);
            }
            byteArrayOutputStream.write(myByte);
            i += 2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String encode(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            stringBuffer.append(Hex.convertDigit(bytes[i] >> 4));
            stringBuffer.append(Hex.convertDigit(bytes[i] & 0xF));
            ++i;
        }
        return stringBuffer.toString();
    }

    private static char convertDigit(int value) {
        if ((value &= 0xF) >= 10) {
            return (char)(value - 10 + 97);
        }
        return (char)(value + 48);
    }
}

