/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import com.sapportals.portal.prt.service.soap.util.DateUtilFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class GYearMonth {
    private String mm_content = null;
    private String mm_year = null;
    private String mm_month = null;
    private String mm_timeZone = null;

    public GYearMonth(String exp) {
        this.mm_content = exp;
        if (exp.length() != 7 && exp.length() != 8 && exp.length() != 13) {
            throw new IllegalArgumentException("Lexical Representation Error: year-month field must have 7,8 or 13 digits CCYY-MM[Z|[+|-hh:mm]]");
        }
        String temp = exp.substring(0, 7);
        if (exp.charAt(4) != '-') {
            throw new IllegalArgumentException("Lexical Representation Error: representation for date is CCYY-MM (bad index of '-' sign) ");
        }
        StringTokenizer stk = new StringTokenizer(temp, "-");
        try {
            this.mm_year = stk.nextToken();
            DateUtilFormat.isDateDigit(this.mm_year, "CCYY");
            this.mm_month = stk.nextToken();
            DateUtilFormat.isDateDigit(this.mm_month, "MM");
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException("Lexical Representation Error: representation for date is CCYY-MM");
        }
        if (exp.length() == 8 || exp.length() == 13) {
            this.mm_timeZone = exp.substring(7);
            DateUtilFormat.isCorrectTimeZone(this.mm_timeZone);
        }
    }

    public String getRepresentation() {
        String res = "";
        if (this.mm_year != null) {
            res = res + this.mm_year;
        }
        if (this.mm_month != null) {
            res = res + "-" + this.mm_month;
        }
        if (this.mm_timeZone != null) {
            res = res + this.mm_timeZone;
        }
        return res;
    }

    public String getMm_month() {
        return this.mm_month;
    }

    public String getMm_timeZone() {
        return this.mm_timeZone;
    }

    public String getMm_year() {
        return this.mm_year;
    }

    public void setMm_month(String string) {
        this.mm_month = string;
    }

    public void setMm_timeZone(String string) {
        this.mm_timeZone = string;
    }

    public void setMm_year(String string) {
        this.mm_year = string;
    }

    public static void main(String[] args) {
        try {
            GYearMonth md1 = new GYearMonth("1999-10");
            System.out.println("md1 :" + md1.getRepresentation());
            GYearMonth md2 = new GYearMonth("2100-08Z");
            System.out.println("md2 :" + md2.getRepresentation());
            GYearMonth md3 = new GYearMonth("2100-08+01:12");
            System.out.println("md3 :" + md3.getRepresentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

