/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;

public class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 63;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final byte PAD = 61;
    private static byte[] base64Alphabet = new byte[255];
    private static byte[] lookUpBase64Alphabet = new byte[63];
    static final int[] base64;
    private byte[] mm_valueBytes = null;
    private byte[] mm_valueBytesEncoded = null;

    public Base64(byte[] value) {
        byte[] t1 = value;
        this.mm_valueBytes = value;
        this.mm_valueBytesEncoded = BASE64Encoder.encode((byte[])value);
    }

    public Base64() {
    }

    public byte[] getValue() {
        return this.mm_valueBytes;
    }

    public byte[] getValueEncoded() {
        return this.mm_valueBytesEncoded;
    }

    public void setValueEncoded(byte[] val) {
        block2: {
            this.mm_valueBytesEncoded = val;
            try {
                this.mm_valueBytes = BASE64Decoder.decode((byte[])val);
            }
            catch (Exception ex) {
                ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                if (logger == null || !logger.isActive()) break block2;
                logger.warning((Object)this, (Throwable)ex, "SetValueEncoded Method failed");
            }
        }
    }

    public void setValue(byte[] val) {
        this.mm_valueBytes = val;
        this.mm_valueBytesEncoded = BASE64Encoder.encode((byte[])this.mm_valueBytes);
    }

    public String toString() {
        return new String(this.mm_valueBytesEncoded);
    }

    static boolean isBase64(byte octect) {
        return octect == 61 || base64Alphabet[octect] != -1;
    }

    static boolean isArrayByteBase64(byte[] arrayOctect) {
        int length = arrayOctect.length;
        if (length == 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!Base64.isBase64(arrayOctect[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] encode() {
        if (this.mm_valueBytesEncoded == null) {
            if (this.mm_valueBytes == null) {
                throw new IllegalArgumentException("No value setting is this object, please set a value before to call this method.");
            }
            this.mm_valueBytesEncoded = BASE64Encoder.encode((byte[])this.mm_valueBytes);
        }
        return this.mm_valueBytesEncoded;
    }

    public byte[] decode() {
        if (this.mm_valueBytes == null) {
            if (this.mm_valueBytesEncoded == null) {
                throw new IllegalArgumentException("No base64 encoded value setting is this object, please set a value before to call this method.");
            }
            this.mm_valueBytes = BASE64Decoder.decode((byte[])this.mm_valueBytesEncoded);
        }
        return this.mm_valueBytes;
    }

    public static String base64Decode(String orig) {
        return new String(BASE64Decoder.decode((byte[])orig.getBytes()));
    }

    static {
        int i = 0;
        while (i < 255) {
            Base64.base64Alphabet[i] = -1;
            ++i;
        }
        int i2 = 90;
        while (i2 >= 65) {
            Base64.base64Alphabet[i2] = (byte)(i2 - 65);
            --i2;
        }
        int i3 = 122;
        while (i3 >= 97) {
            Base64.base64Alphabet[i3] = (byte)(i3 - 97 + 26);
            --i3;
        }
        int i4 = 57;
        while (i4 >= 48) {
            Base64.base64Alphabet[i4] = (byte)(i4 - 48 + 52);
            --i4;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int i5 = 0;
        while (i5 <= 25) {
            Base64.lookUpBase64Alphabet[i5] = (byte)(65 + i5);
            ++i5;
        }
        int i6 = 26;
        int j = 0;
        while (i6 <= 51) {
            Base64.lookUpBase64Alphabet[i6] = (byte)(97 + j);
            ++i6;
            ++j;
        }
        int i7 = 52;
        int j2 = 0;
        while (i7 <= 61) {
            Base64.lookUpBase64Alphabet[i7] = (byte)(48 + j2);
            ++i7;
            ++j2;
        }
        base64 = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64, 64, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64, 64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    }
}

