/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.exception;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.logger.Level;
import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.PRTSOAPElementFactory;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.exception.IPRTFault;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.exception.SoapFaultHandler;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.XMLValueEncoder;
import com.sapportals.portal.prt.service.soap.util.XMLValueExtractor;
import com.sapportals.portal.prt.service.soap.wsdl.ITypes;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PRTFault
extends SOAPServiceException
implements IPRTFault {
    private static final String COMPLEX_TYPE_TAG = "complexType";
    private static final String TITLE_FAULT_ERROR = "SOAP Fault Error";
    public static final String ELEMENT_ERROR = "error";
    private static final String ELEMENT_TYPE = "type";
    public static final String PORTALSOAPFAULT = "PortalSOAPFault";
    private static final String ELEMENT_STACKTRACE = "stackTrace";
    private static ISOAPMessageContext mm_soapMsgContextServerSide = null;
    private static SOAPEnvelope mm_soapEnvelopeMsgContextServerSide = null;
    private static ISOAPMessageContext mm_soapMsgContextClientSide = null;
    protected String mm_faultActor = null;
    protected QName mm_faultCode = null;
    protected Vector mm_faultDetailsVector;
    protected Detail mm_faultDetails;
    protected String mm_faultString = null;
    protected Throwable mm_exception = null;
    protected String mm_typeJavaClassException = null;
    protected Level mm_levelError = Level.WARNING;

    public static void initializePRTFaultContextServerSide(ISOAPMessageContext context, SOAPEnvelope soapEnvelopeMsgContext) {
        mm_soapMsgContextServerSide = context;
        mm_soapEnvelopeMsgContextServerSide = soapEnvelopeMsgContext;
    }

    public static void releasePRTFaultContextServerSide() {
        mm_soapMsgContextServerSide = null;
        mm_soapEnvelopeMsgContextServerSide = null;
    }

    public static void initializePRTFaultContextClientSide(ISOAPMessageContext context) {
        mm_soapMsgContextClientSide = context;
    }

    public static void releasePRTFaultContextClientSide() {
        mm_soapMsgContextClientSide = null;
    }

    public PRTFault() {
        super(TITLE_FAULT_ERROR);
    }

    public PRTFault(QName code, String str, String actor, Object obj, Throwable ex) {
        super(str);
        this.mm_faultCode = code;
        this.mm_faultString = str;
        this.mm_faultActor = actor;
        this.mm_exception = ex;
        this.initFromException(this.mm_exception);
        this.mm_msgFault = this.constructFaultMessageFromException();
    }

    public PRTFault(SOAPMessage faultmsg) {
        super(TITLE_FAULT_ERROR);
        this.initExceptionFromSOAPMessage(faultmsg);
        this.mm_exception = null;
        this.mm_msgFault = faultmsg;
    }

    private void initExceptionFromSOAPMessage(SOAPMessage faultmsg) {
        SOAPFault fault = null;
        try {
            fault = faultmsg.getSOAPPart().getEnvelope().getBody().getFault();
        }
        catch (SOAPException ex) {
            fault = null;
        }
        if (fault != null) {
            Iterator iter;
            this.mm_faultCode = new QName(fault.getEncodingStyle(), fault.getFaultCode());
            this.mm_faultString = fault.getFaultString();
            this.mm_faultActor = fault.getFaultActor();
            this.mm_faultDetailsVector = new Vector();
            this.mm_faultDetails = fault.getDetail();
            if (this.mm_faultDetails != null && (iter = this.mm_faultDetails.getChildElements()) != null) {
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof SOAPElement)) continue;
                    SOAPElement item = (SOAPElement)obj;
                    if (item.getElementName().getLocalName().equals(ELEMENT_ERROR)) {
                        Iterator error_childs = item.getChildElements();
                        while (error_childs.hasNext()) {
                            SOAPElement element = (SOAPElement)error_childs.next();
                            if (!element.getElementName().getLocalName().equals(ELEMENT_TYPE)) continue;
                            this.mm_typeJavaClassException = element.getValue();
                            break;
                        }
                    }
                    this.mm_faultDetailsVector.add(item);
                }
            }
        }
    }

    public void initializeFromPRTFault(PRTFault rootexception) {
        this.mm_faultActor = rootexception.getFaultActor();
        this.mm_faultString = rootexception.getFaultString();
        this.mm_faultCode = rootexception.getFaultCode();
        this.mm_levelError = rootexception.getLevelError();
        this.mm_faultDetails = rootexception.getFaultDetails();
        this.mm_faultDetailsVector = rootexception.getFaultDetailsVector();
    }

    public Object throwException() {
        ISpecializedRegistry registry;
        if (mm_soapMsgContextClientSide != null && (registry = SOAPRegistry.getInstance().getSpecializedRegistry(mm_soapMsgContextClientSide.getServiceDescriptor().getServiceName())) != null) {
            SOAPDeserializer deserializer;
            if (this.mm_faultDetails != null) {
                mm_soapMsgContextClientSide.addNamespaceElementInContext((SOAPElement)this.mm_faultDetails);
            }
            int i = 0;
            while (i < this.mm_faultDetailsVector.size()) {
                SOAPParameter exception;
                SOAPElement element = (SOAPElement)this.mm_faultDetailsVector.get(i);
                mm_soapMsgContextClientSide.addNamespaceElementInContext(element);
                QName nameQ = XMLValueExtractor.getQNameForElement(element, mm_soapMsgContextClientSide);
                if (nameQ != null && (deserializer = registry.getDeserializer(nameQ, "http://schemas.xmlsoap.org/soap/encoding/")) != null && (exception = deserializer.unmarshall("http://schemas.xmlsoap.org/soap/encoding/", new QName(this.mm_typeJavaClassException), element, mm_soapMsgContextClientSide)) != null) {
                    PRTFault.releasePRTFaultContextClientSide();
                    this.mm_typeJavaClassException = exception.getType().getName();
                    return exception.getValue();
                }
                ++i;
            }
            if (this.mm_typeJavaClassException == null) {
                Iterator listQname = registry.getListQName().values().iterator();
                QName type = null;
                while (listQname.hasNext()) {
                    QName element = (QName)listQname.next();
                    if (this.mm_typeJavaClassException == null || this.mm_typeJavaClassException.indexOf(element.getLocalPart()) == -1) continue;
                    type = element;
                    break;
                }
                if (type == null) {
                    type = new QName(this.mm_typeJavaClassException == null ? "Unknown" : this.mm_typeJavaClassException);
                }
                if ((deserializer = registry.getDeserializer(type, "http://schemas.xmlsoap.org/soap/encoding/")) != null) {
                    SOAPElement rootElement = null;
                    int i2 = 0;
                    while (i2 < this.mm_faultDetailsVector.size()) {
                        SOAPElement element = (SOAPElement)this.mm_faultDetailsVector.get(i2);
                        if (element.getElementName().getLocalName().equals(ELEMENT_ERROR)) {
                            rootElement = element;
                            break;
                        }
                        ++i2;
                    }
                    if (rootElement != null) {
                        mm_soapMsgContextClientSide.setFaultObjectInstance(this);
                        SOAPParameter exception = deserializer.unmarshall("http://schemas.xmlsoap.org/soap/encoding/", new QName(this.mm_typeJavaClassException), rootElement, mm_soapMsgContextClientSide);
                        if (exception != null) {
                            PRTFault.releasePRTFaultContextClientSide();
                            return exception.getValue();
                        }
                    }
                }
            }
        }
        PRTFault.releasePRTFaultContextClientSide();
        return this;
    }

    public PRTFault(QName code, String str, String actor, Object obj, ByteArrayOutputStream streamException) {
        super(str);
        this.mm_faultCode = code;
        this.mm_faultString = str;
        this.mm_faultActor = actor;
        this.initFromByteArrayOutputStream("Error from Custom Serializer", streamException);
        this.mm_msgFault = this.constructFaultMessageFromException();
    }

    public PRTFault(Object obj, Exception ex) {
        this(ISOAPParamConstants.Q_ELEM_SOAP_FAULT_SERVER, ex.toString(), obj != null ? obj.getClass().getName() : null, obj, ex);
    }

    public PRTFault(Object obj, Throwable ex) {
        this(ISOAPParamConstants.Q_ELEM_SOAP_FAULT_SERVER, ex.toString(), obj != null ? obj.getClass().getName() : null, obj, ex);
    }

    public PRTFault(Exception ex) {
        this((Object)null, ex);
    }

    public PRTFault(Throwable ex) {
        this((Object)null, ex);
    }

    public static PRTFault makePrtFault(Object obj, Throwable e) {
        if (e instanceof PRTFault) {
            return (PRTFault)((Object)e);
        }
        return new PRTFaultInternalError(obj, e);
    }

    public void printStackTrace() {
        if (this.mm_exception != null) {
            this.mm_exception.printStackTrace();
        } else {
            this.printStackTrace(System.err);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.mm_exception != null) {
            this.mm_exception.printStackTrace(s);
        } else {
            s.println((this.mm_typeJavaClassException == null ? "" : this.mm_typeJavaClassException + " - ") + "SOAP Fault Exception [Actor " + this.mm_faultActor + "] : " + this.mm_faultString);
            Enumeration enumeration = this.mm_faultDetailsVector.elements();
            while (enumeration.hasMoreElements()) {
                Element item = (Element)enumeration.nextElement();
                if (item == null || item.getChildNodes().getLength() <= 0) continue;
                NodeList childs = item.getChildNodes();
                int i = 0;
                while (i < childs.getLength()) {
                    s.println(childs.item(i).toString());
                    ++i;
                }
            }
            s.flush();
        }
    }

    public void printStackTrace(PrintStream s) {
        if (this.mm_exception != null) {
            this.mm_exception.printStackTrace(s);
        } else {
            this.printStackTrace(new PrintWriter(s));
        }
    }

    public String getFaultActor() {
        return this.mm_faultActor;
    }

    public QName getFaultCode() {
        if (this.mm_faultCode == null) {
            this.mm_faultCode = ISOAPParamConstants.Q_ELEM_SOAP_FAULT_SERVER;
        }
        return this.mm_faultCode;
    }

    public Detail getFaultDetails() {
        return this.mm_faultDetails;
    }

    public String getFaultString() {
        return this.mm_faultString;
    }

    public Level getLevelError() {
        return this.mm_levelError;
    }

    public String toString() {
        if (this.mm_exception != null) {
            return this.mm_exception.toString();
        }
        return "SOAP Fault Error (" + (this.mm_typeJavaClassException == null ? "n.a" : this.mm_typeJavaClassException) + ") : " + this.mm_faultString;
    }

    private SOAPElement StringToElement(String namespace, String name, String value) {
        try {
            SOAPElement element;
            String prefix = "";
            if (mm_soapMsgContextClientSide != null) {
                prefix = mm_soapMsgContextClientSide.getPrefixForNamespace(namespace);
            }
            if (mm_soapMsgContextServerSide != null) {
                prefix = mm_soapMsgContextServerSide.getPrefixForNamespace(namespace);
            }
            if ((element = PRTSOAPElementFactory.getInstance().createSOAPElement(name, prefix, namespace)) == null) {
                return null;
            }
            element.addTextNode(value);
            return element;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initFromException(Exception target) {
        this.initFromByteArrayOutputStream(target.toString(), XMLValueEncoder.convertFromException(target));
    }

    private void initFromByteArrayOutputStream(String msgError, ByteArrayOutputStream stream) {
        SOAPElement el;
        if (this.mm_faultString == null) {
            this.mm_faultString = msgError;
        }
        if (this.mm_faultDetailsVector == null) {
            this.mm_faultDetailsVector = new Vector();
        }
        if ((el = this.StringToElement("http://prt.java.soap/schemas", ELEMENT_ERROR, stream.toString())) != null) {
            this.mm_faultDetailsVector.add(el);
        }
    }

    private void initFromException(Throwable target) {
        this.initFromByteArrayOutputStream(target.toString(), XMLValueEncoder.convertFromException(target));
    }

    private SOAPMessage constructFaultMessageFromException() {
        try {
            SOAPMessage msg = SoapFaultHandler.getInstance().constructSOAPMessage();
            SOAPPart spart = msg.getSOAPPart();
            SOAPEnvelope senv = spart.getEnvelope();
            senv.addNamespaceDeclaration("fault", "http://www.w3.org/2001/12/soap-faults");
            SOAPBody sbody = senv.getBody();
            SOAPFault sfault = sbody.addFault();
            sfault.setFaultCode("SOAP-ENV:" + this.mm_faultCode.getLocalPart());
            if (this.mm_faultString != null) {
                sfault.setFaultString(this.mm_faultString);
            }
            InetAddress localhost = InetAddress.getLocalHost();
            String address = "[" + localhost.getHostName() + "] ";
            if (this.mm_faultActor != null) {
                sfault.setFaultActor(address + this.mm_faultActor);
            } else {
                sfault.setFaultActor(address);
            }
            this.mm_faultDetails = sfault.addDetail();
            int i = 0;
            while (i < this.mm_faultDetailsVector.size()) {
                SOAPSerializer serializer;
                ISpecializedRegistry registry;
                Element el = (Element)this.mm_faultDetailsVector.get(i);
                Name name = senv.createName(el.getLocalName(), el.getPrefix(), el.getNamespaceURI());
                DetailEntry dentry = this.mm_faultDetails.addDetailEntry(name);
                if (mm_soapMsgContextServerSide != null) {
                    registry = SOAPRegistry.getInstance().getSpecializedRegistry(mm_soapMsgContextServerSide.getServiceDescriptor().getServiceName());
                    if (registry != null) {
                        QName qname_type = registry.getElementType(this.mm_exception.getClass(), "http://schemas.xmlsoap.org/soap/encoding/");
                        if (qname_type != null) {
                            Name type = mm_soapEnvelopeMsgContextServerSide.createName(ELEMENT_TYPE, "xsi", mm_soapMsgContextServerSide.getNamespaceFromPrefix("xsi"));
                            dentry.addAttribute(type, XMLValueEncoder.constructValueforType(qname_type.getNamespaceURI(), qname_type.getLocalPart(), mm_soapMsgContextServerSide));
                            if (this.mm_faultDetails != null) {
                                this.mm_faultDetails.addNamespaceDeclaration(mm_soapMsgContextServerSide.getPrefixForNamespace(qname_type.getNamespaceURI()), qname_type.getNamespaceURI());
                            }
                        } else {
                            String ns_xsi = mm_soapMsgContextServerSide.getNamespaceFromPrefix("xsi");
                            if (ns_xsi == null) {
                                ns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
                            }
                            dentry.addNamespaceDeclaration("xsi", ns_xsi);
                            Name type = mm_soapEnvelopeMsgContextServerSide.createName(ELEMENT_TYPE, "xsi", ns_xsi);
                            mm_soapMsgContextServerSide.addNamespaceDeclarationInElement((SOAPElement)dentry);
                            dentry.addAttribute(type, XMLValueEncoder.constructValueforType("http://prt.java.soap/schemas", PORTALSOAPFAULT, mm_soapMsgContextServerSide));
                            if (this.mm_faultDetails != null) {
                                this.mm_faultDetails.addNamespaceDeclaration(mm_soapMsgContextServerSide.getPrefixForNamespace("http://prt.java.soap/schemas"), "http://prt.java.soap/schemas");
                            }
                        }
                    }
                } else {
                    SOAPElement typeElement = dentry.addChildElement(ELEMENT_TYPE);
                    if (this.mm_exception != null) {
                        typeElement.addTextNode(this.mm_exception.getClass().getName());
                    } else {
                        typeElement.addTextNode(this.getClass().getName());
                    }
                }
                if (mm_soapMsgContextServerSide != null && (registry = SOAPRegistry.getInstance().getSpecializedRegistry(mm_soapMsgContextServerSide.getServiceDescriptor().getServiceName())) != null && (serializer = registry.getSerializer(this.mm_exception.getClass(), "http://schemas.xmlsoap.org/soap/encoding/")) != null) {
                    serializer.marshall("http://schemas.xmlsoap.org/soap/encoding/", this.mm_exception.getClass(), mm_soapEnvelopeMsgContextServerSide, (SOAPElement)dentry, this.mm_exception, ELEMENT_ERROR, mm_soapMsgContextServerSide);
                }
                if (SoapFaultHandler.getInstance().isDebugMode()) {
                    String stacktrace = el.getFirstChild().getNodeValue();
                    stacktrace = stacktrace.replace('<', '(');
                    stacktrace = stacktrace.replace('>', ')');
                    SOAPElement stacktraceElement = dentry.addChildElement(ELEMENT_STACKTRACE);
                    stacktraceElement.addTextNode(stacktrace);
                }
                ++i;
            }
            msg.saveChanges();
            return msg;
        }
        catch (Exception ex) {
            ILogger logger = SoapFaultHandler.getInstance().getLogger();
            if (logger != null) {
                logger.log((Throwable)ex, ex.toString(), Level.WARNING);
            }
            return null;
        }
    }

    public static boolean writeSchema(ITypes type) throws Exception {
        Element complexType = type.createElementNS("", COMPLEX_TYPE_TAG);
        complexType.setAttribute("name", PORTALSOAPFAULT);
        Element sequence = type.createElementNS("", "sequence");
        complexType.appendChild(sequence);
        Element elementStackTrace = type.createElementNS("", "element");
        elementStackTrace.setAttribute("name", ELEMENT_STACKTRACE);
        elementStackTrace.setAttribute("minOccurs", "0");
        elementStackTrace.setAttribute("maxOccurs", "1");
        elementStackTrace.setAttribute(ELEMENT_TYPE, "xsd:string");
        sequence.appendChild(elementStackTrace);
        type.writeSchemaElement(new QName("http://prt.java.soap/schemas", PORTALSOAPFAULT), complexType);
        return true;
    }

    public Throwable getCauseException() {
        return this.mm_exception;
    }

    public String getMessage() {
        if (this.mm_exception != null) {
            return this.mm_exception.toString();
        }
        return "SOAP Fault Error (" + (this.mm_typeJavaClassException == null ? "n.a" : this.mm_typeJavaClassException) + ") : " + this.mm_faultString;
    }

    public String getTypeJavaClassException() {
        if (this.mm_exception != null) {
            return this.mm_exception.getClass().getName();
        }
        return this.mm_typeJavaClassException;
    }

    public Vector getFaultDetailsVector() {
        return this.mm_faultDetailsVector;
    }

    public void setFaultActor(String string) {
        this.mm_faultActor = string;
    }

    public void setFaultCode(QName name) {
        this.mm_faultCode = name;
    }

    public void setFaultDetails(Detail detail) {
        this.mm_faultDetails = detail;
    }

    public void setFaultDetailsVector(Vector vector) {
        this.mm_faultDetailsVector = vector;
    }

    public void setFaultString(String string) {
        this.mm_faultString = string;
    }

    public void setLevelError(Level level) {
        this.mm_levelError = level;
    }

    public abstract void updateFaultMessage();
}

