/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sl.util.cvers.impl;

import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sl.util.cvers.api.CVersAccessException;
import com.sap.sl.util.cvers.api.CVersManagerIF;
import com.sap.sl.util.cvers.impl.CVersDao;
import com.sap.sl.util.cvers.impl.CVersDao0;
import com.sap.sl.util.cvers.impl.CVersDao2;
import com.sap.sl.util.cvers.impl.CVersDaoIF;
import com.sap.sl.util.cvers.impl.DBConnector;
import com.sap.sl.util.cvers.impl.TableDescription;
import com.sap.sl.util.cvers.impl.TableDescriptionFactory;
import com.sap.sl.util.logging.api.SlUtilLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import javax.sql.DataSource;

public class CVersManager
implements CVersManagerIF {
    private static final SlUtilLogger log = SlUtilLogger.getLogger((class$com$sap$sl$util$cvers$impl$CVersManager == null ? (class$com$sap$sl$util$cvers$impl$CVersManager = CVersManager.class$("com.sap.sl.util.cvers.impl.CVersManager")) : class$com$sap$sl$util$cvers$impl$CVersManager).getName());
    private static int CVERS_DB_SCHEMA = 0;
    CVersDaoIF cVersDao = null;
    DataSource currentDataSource = null;
    static /* synthetic */ Class class$com$sap$sl$util$cvers$impl$CVersManager;

    private TableDescription loadTable(DataSource dataSource, String tablename) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            TableDescriptionFactory fac = TableDescriptionFactory.getInstance();
            TableDescription desc = fac.getTableDescription(connection, tablename);
            connection.close();
            log.debug("Table " + tablename + " has " + desc.getFieldCount() + " fields");
            int i = 0;
            while (i < desc.getFieldCount()) {
                log.debug("Table " + tablename + " has field " + desc.getFieldDescription(i));
                ++i;
            }
            return desc;
        }
        catch (SQLException e) {
            log.debug("Can not load table description for table " + tablename, e);
            return null;
        }
    }

    private void loadDBStructure(DataSource dataSource) {
        TableDescription desc = this.loadTable(dataSource, "BC_COMPVERS");
        if (desc == null) {
            desc = this.loadTable(dataSource, "BC_CVERS");
            if (desc == null) {
                log.error("No SLUTIL DB schema found, neither BC_COMPVERS nor BC_CVERS");
                return;
            }
            log.error("SLUTIL DB schema BC_CVERS found but without field SERVICELEVEL");
            return;
        }
        if (desc.getFieldIndex("SERVERNAME") >= 0) {
            CVERS_DB_SCHEMA = 3;
            return;
        }
        if (desc.getFieldIndex("COMPID") >= 0) {
            CVERS_DB_SCHEMA = 2;
            return;
        }
        log.error("SLUTIL DB schema BC_COMPVERS found, but without field COMPID");
    }

    private void openDBSource(DataSource dataSource) {
        int oldschema = CVERS_DB_SCHEMA;
        this.loadDBStructure(dataSource);
        this.currentDataSource = dataSource;
        if (oldschema != CVERS_DB_SCHEMA) {
            log.info("changing CVERS DB schema from " + oldschema + " to " + CVERS_DB_SCHEMA);
        } else {
            log.info("SLUTIL DB schema is " + CVERS_DB_SCHEMA);
        }
        if (CVERS_DB_SCHEMA == 3) {
            this.cVersDao = new CVersDao(dataSource);
            return;
        }
        if (CVERS_DB_SCHEMA == 2) {
            this.cVersDao = new CVersDao2(dataSource);
            return;
        }
        this.cVersDao = new CVersDao0(dataSource);
        log.error("Can not identify SLUTIL DB schema");
    }

    public CVersManager() throws CVersAccessException {
        DBConnector dbConnector = new DBConnector();
        this.openDBSource(dbConnector.getDataSource());
    }

    public CVersManager(DataSource _dataSource) throws CVersAccessException {
        this.openDBSource(_dataSource);
    }

    public ComponentElementIF[] readCVers() throws CVersAccessException {
        Collection cVers = this.cVersDao.findAll();
        Iterator it = cVers.iterator();
        ComponentElementIF[] compElems = null;
        if (cVers != null) {
            compElems = new ComponentElementIF[cVers.size()];
            int i = 0;
            while (it.hasNext()) {
                compElems[i] = (ComponentElementIF)it.next();
                ++i;
            }
        }
        return compElems;
    }

    public ComponentElementIF[] readCVers(String componentType) throws CVersAccessException {
        Collection cVers = this.cVersDao.findByCompType(componentType);
        Iterator it = cVers.iterator();
        ComponentElementIF[] compElems = null;
        if (cVers != null) {
            compElems = new ComponentElementIF[cVers.size()];
            int i = 0;
            while (it.hasNext()) {
                compElems[i] = (ComponentElementIF)it.next();
                ++i;
            }
        }
        return compElems;
    }

    public ComponentElementIF[] readCVers(String componentType, String subsystem) throws CVersAccessException {
        Collection cVers = this.cVersDao.findByTypeAndSubsys(componentType, subsystem);
        Iterator it = cVers.iterator();
        ComponentElementIF[] compElems = null;
        if (cVers != null) {
            compElems = new ComponentElementIF[cVers.size()];
            int i = 0;
            while (it.hasNext()) {
                compElems[i] = (ComponentElementIF)it.next();
                ++i;
            }
        }
        return compElems;
    }

    public ComponentElementIF readCVers(String vendor, String name, String componentType, String subsystem) throws CVersAccessException {
        return this.cVersDao.findByRealKey(vendor, name, componentType, subsystem);
    }

    private void checkForDBUpdate(ComponentElementIF[] cVersElements) {
        if (cVersElements == null) {
            return;
        }
        boolean newDBSchema = false;
        int i = 0;
        while (i < cVersElements.length) {
            String name = cVersElements[i].getName();
            if (name.equals("tc/SL/UTIL_JDD")) {
                newDBSchema = true;
                break;
            }
            if (name.equals("tc/sl/utiljddschema")) {
                newDBSchema = true;
                break;
            }
            ++i;
        }
        if (newDBSchema) {
            log.info("new CVERS DB schema detected, checking DB structure");
            this.openDBSource(this.currentDataSource);
        }
    }

    public void writeCVers(ComponentElementIF[] cVersElements) throws CVersAccessException {
        this.checkForDBUpdate(cVersElements);
        this.cVersDao.writeCVers(cVersElements);
    }

    public void removeCVers(ComponentElementIF[] cVersElements) throws CVersAccessException {
        this.cVersDao.removeCVers(cVersElements);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

