/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sl.util.cvers.impl;

import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sl.util.components.api.ComponentFactoryIF;
import com.sap.sl.util.cvers.api.CVersAccessException;
import com.sap.sl.util.cvers.api.CVersCreateException;
import com.sap.sl.util.cvers.api.CVersFinderException;
import com.sap.sl.util.cvers.api.CVersSQLException;
import com.sap.sl.util.cvers.impl.CVersDBObject;
import com.sap.sl.util.cvers.impl.CVersDaoIF;
import com.sap.sl.util.cvers.impl.CVersPK;
import com.sap.sl.util.cvers.impl.CVersTime;
import com.sap.sl.util.cvers.impl.HashKey;
import com.sap.sl.util.logging.api.SlUtilLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.sql.DataSource;

public class CVersDao2
implements CVersDaoIF {
    private static final SlUtilLogger log = SlUtilLogger.getLogger((class$com$sap$sl$util$cvers$impl$CVersDao2 == null ? (class$com$sap$sl$util$cvers$impl$CVersDao2 = CVersDao2.class$("com.sap.sl.util.cvers.impl.CVersDao2")) : class$com$sap$sl$util$cvers$impl$CVersDao2).getName());
    private static final String FINDBYREALKEYSTRING = "SELECT HASHNUMBER, VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPID = ? AND COMPONENTTYPE = ? AND SUBSYSTEM = ?";
    private static final String UPDATESTRING = "UPDATE BC_COMPVERS SET VENDOR = ?, NAME = ?, LOCATION = ?, COUNTER = ?, SCVENDOR = ?, SCNAME = ?, SAPRELEASE = ?, SERVICELEVEL = ?, DELTAVERSION = ?, UPDATEVERSION = ?, APPLYTIME = ?, SCELEMENTTYPEID = ?, SPELEMENTTYPEID = ?, SPNAME = ?, SPVERSION = ? WHERE COMPID = ? AND HASHNUMBER = ? AND COMPONENTTYPE = ? AND SUBSYSTEM = ?";
    private static final String INSERTSTRING = "INSERT INTO BC_COMPVERS (COMPID, HASHNUMBER, COMPONENTTYPE, SUBSYSTEM, VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String FINDBYPKSTRING = "SELECT  VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPID = ? AND HASHNUMBER = ? AND COMPONENTTYPE = ? AND SUBSYSTEM = ?";
    private static final String FINDALLSTRING = "SELECT COMPONENTTYPE, SUBSYSTEM, VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS";
    private static final String FINDBYCOMPTYPESTRING = "SELECT SUBSYSTEM, VENDOR, NAME,  LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPONENTTYPE = ?";
    private static final String FINDBYTYPEANDSUBSYSSTRING = "SELECT VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPONENTTYPE = ? AND SUBSYSTEM = ?";
    private static final String REMOVESTRING = "DELETE FROM BC_COMPVERS WHERE COMPID = ? AND HASHNUMBER = ? AND COMPONENTTYPE = ? AND SUBSYSTEM = ?";
    private DataSource dataSource;
    static /* synthetic */ Class class$com$sap$sl$util$cvers$impl$CVersDao2;

    public CVersDao2(DataSource _dataSource) {
        this.dataSource = _dataSource;
    }

    public void writeCVers(ComponentElementIF[] cVersElements) throws CVersAccessException {
        log.entering("writeCVers");
        Connection connection = null;
        PreparedStatement updateStatement = null;
        PreparedStatement insertStatement = null;
        PreparedStatement findByRealKeyStatement = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                findByRealKeyStatement = connection.prepareStatement(FINDBYREALKEYSTRING);
                updateStatement = connection.prepareStatement(UPDATESTRING);
                insertStatement = connection.prepareStatement(INSERTSTRING);
                int i = 0;
                while (i < cVersElements.length) {
                    ComponentFactoryIF compFactory = ComponentFactoryIF.getInstance();
                    ComponentElementIF compElement = compFactory.createComponentElement(cVersElements[i].getVendor(), cVersElements[i].getName(), cVersElements[i].getComponentType(), cVersElements[i].getSubsystem(), cVersElements[i].getLocation(), cVersElements[i].getCounter(), cVersElements[i].getSCVendor(), cVersElements[i].getSCName(), cVersElements[i].getRelease(), cVersElements[i].getServiceLevel(), cVersElements[i].getDeltaVersion(), cVersElements[i].getUpdateVersion(), CVersTime.getTimeStamp("yyyyMMddHHmmss"), cVersElements[i].getSCElementTypeID(), cVersElements[i].getSPElementTypeID(), cVersElements[i].getSPName(), cVersElements[i].getSPVersion());
                    CVersPK cVersPK = this.findPKByRealKey(findByRealKeyStatement, HashKey.defaultHashFunction(compElement.getVendor(), compElement.getName()), compElement.getVendor(), compElement.getName(), compElement.getComponentType(), compElement.getSubsystem());
                    if (cVersPK == null) {
                        this.create(insertStatement, 0, compElement);
                    } else {
                        this.save(updateStatement, cVersPK.hashnumber, compElement);
                    }
                    ++i;
                }
            }
            catch (SQLException se) {
                log.error("Error writing new entries into COMPVERS: " + se.toString());
                throw new CVersSQLException("Error writing new entries into COMPVERS: " + se.toString());
            }
            Object var11_11 = null;
            this.closeConnection(connection, updateStatement);
            this.closeConnection(connection, insertStatement);
            log.exiting("writeCVers");
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.closeConnection(connection, updateStatement);
            this.closeConnection(connection, insertStatement);
            log.exiting("writeCVers");
            throw throwable;
        }
    }

    public void save(PreparedStatement updateStatement, int hashnumber, ComponentElementIF compElem) throws SQLException {
        this.save(updateStatement, hashnumber, compElem.getVendor(), compElem.getName(), compElem.getComponentType(), compElem.getSubsystem(), compElem.getLocation(), compElem.getCounter(), compElem.getSCVendor(), compElem.getSCName(), compElem.getRelease(), compElem.getServiceLevel(), compElem.getDeltaVersion(), compElem.getUpdateVersion(), compElem.getApplyTime(), compElem.getSCElementTypeID(), compElem.getSPElementTypeID(), compElem.getSPName(), compElem.getSPVersion());
    }

    public void save(PreparedStatement updateStatement, int hashnumber, String vendor, String name, String type, String subsystem, String location, String counter, String scVendor, String scName, String release, String serviceLevel, String deltaVersion, String updateVersion, String applyTime, String scElementTypeID, String spElementTypeID, String spName, String spVersion) throws SQLException {
        log.entering("save");
        int compID = HashKey.defaultHashFunction(vendor, name);
        try {
            updateStatement.clearParameters();
            updateStatement.setString(1, vendor);
            updateStatement.setString(2, name);
            updateStatement.setString(3, location);
            updateStatement.setString(4, counter);
            updateStatement.setString(5, scVendor);
            updateStatement.setString(6, scName);
            updateStatement.setString(7, release);
            updateStatement.setString(8, serviceLevel);
            updateStatement.setString(9, deltaVersion);
            updateStatement.setString(10, updateVersion);
            updateStatement.setString(11, applyTime);
            updateStatement.setString(12, scElementTypeID);
            updateStatement.setString(13, spElementTypeID);
            updateStatement.setString(14, spName);
            updateStatement.setString(15, spVersion);
            updateStatement.setInt(16, compID);
            updateStatement.setInt(17, hashnumber);
            updateStatement.setString(18, type);
            updateStatement.setString(19, subsystem);
            if (updateStatement.executeUpdate() < 1) {
                log.error("Row does not exist");
                throw new NoSuchElementException("Row does not exist");
            }
            log.debug("Ok, COMPVERS update successfull.");
        }
        catch (SQLException se) {
            log.error("Error executing SQL UPDATE CMS_PCOMPVERS... " + se.toString());
            throw se;
        }
        log.exiting("save");
    }

    public CVersPK create(PreparedStatement insertStatement, int hashnumber, ComponentElementIF compElem) throws SQLException, CVersAccessException {
        return this.create(insertStatement, hashnumber, compElem.getVendor(), compElem.getName(), compElem.getComponentType(), compElem.getSubsystem(), compElem.getLocation(), compElem.getCounter(), compElem.getSCVendor(), compElem.getSCName(), compElem.getRelease(), compElem.getServiceLevel(), compElem.getDeltaVersion(), compElem.getUpdateVersion(), compElem.getApplyTime(), compElem.getSCElementTypeID(), compElem.getSPElementTypeID(), compElem.getSPName(), compElem.getSPVersion());
    }

    public CVersPK create(PreparedStatement insertStatement, int _hashnumber, String _vendor, String _name, String _componentType, String _subsystem, String _location, String _counter, String _scVendor, String _scName, String _release, String _patchLevel, String _serviceLevel, String _deltaVersion, String _updateVersion, String _applyTime, String _scElementTypeID, String _spElementTypeID, String _spName, String _spVersion, String servertype, String servername, String changenumber, String projectname) throws SQLException, CVersAccessException {
        String message = "Internal error, DB schema is COMPVERS version 2, but version 3 is called";
        log.error(message);
        throw new CVersAccessException(message);
    }

    public CVersPK create(PreparedStatement insertStatement, int _hashnumber, String _vendor, String _name, String _componentType, String _subsystem, String _location, String _counter, String _scVendor, String _scName, String _release, String _serviceLevel, String _deltaVersion, String _updateVersion, String _applyTime, String _scElementTypeID, String _spElementTypeID, String _spName, String _spVersion) throws SQLException, CVersAccessException {
        log.entering("create");
        int compID = HashKey.defaultHashFunction(_vendor, _name);
        log.debug("start insert");
        try {
            insertStatement.clearParameters();
            insertStatement.setInt(1, compID);
            insertStatement.setInt(2, _hashnumber);
            insertStatement.setString(3, _componentType);
            insertStatement.setString(4, _subsystem);
            insertStatement.setString(5, _vendor);
            insertStatement.setString(6, _name);
            insertStatement.setString(7, _location);
            insertStatement.setString(8, _counter);
            insertStatement.setString(9, _scVendor);
            insertStatement.setString(10, _scName);
            insertStatement.setString(11, _release);
            insertStatement.setString(12, _serviceLevel);
            insertStatement.setString(13, _deltaVersion);
            insertStatement.setString(14, _updateVersion);
            insertStatement.setString(15, _applyTime);
            insertStatement.setString(16, _scElementTypeID);
            insertStatement.setString(17, _spElementTypeID);
            insertStatement.setString(18, _spName);
            insertStatement.setString(19, _spVersion);
            if (insertStatement.executeUpdate() != 1) {
                log.error("Error adding row");
                log.debug(compID + "," + _hashnumber + "," + _componentType + "," + _subsystem + "," + _vendor + "," + _name + "," + _location + "," + _counter + "," + _scVendor + "," + _scName + "," + _release + "," + _serviceLevel + "," + _deltaVersion + "," + _updateVersion + "," + _applyTime + "," + _scElementTypeID + "," + _spElementTypeID + "," + _spName + "," + _spVersion);
                throw new CVersCreateException("Error adding row");
            }
            log.exiting("create");
            return new CVersPK(compID, _hashnumber, _componentType, _subsystem);
        }
        catch (SQLException se) {
            log.error("Error executing SQL INSERT INTO BC_COMPVERS... " + se.toString());
            throw se;
        }
    }

    public ComponentElementIF findByPrimaryKey(CVersPK _cVersPK) throws CVersAccessException {
        log.entering("findByPrimaryKey");
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            try {
                ComponentElementIF compVers;
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement(FINDBYPKSTRING);
                statement.setInt(1, _cVersPK.compID);
                statement.setInt(2, _cVersPK.hashnumber);
                statement.setString(3, _cVersPK.componentType);
                statement.setString(4, _cVersPK.subSystem);
                ResultSet resultSet = statement.executeQuery();
                if (!resultSet.next()) {
                    log.error("COMPVERS - Primary key does not exist");
                    throw new CVersFinderException("COMPVERS - Primary key does not exist");
                }
                ComponentFactoryIF factory = ComponentFactoryIF.getInstance();
                ComponentElementIF componentElementIF = compVers = factory.createComponentElement(resultSet.getString(1), resultSet.getString(2), _cVersPK.componentType, _cVersPK.subSystem, resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13), resultSet.getString(14), resultSet.getString(15));
                Object var9_9 = null;
                this.closeConnection(connection, statement);
                log.exiting("findByPrimaryKey");
                return componentElementIF;
            }
            catch (SQLException se) {
                log.error("Error executing SQL SELECT  LOCATION, COUNTER,... " + se.toString());
                throw new CVersSQLException("Error executing SQL SELECT  VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPID = ? AND HASHNUMBER = ? AND COMPONENTTYPE = ? AND SUBSYSTEM = ?" + _cVersPK.compID + _cVersPK.hashnumber + _cVersPK.componentType + _cVersPK.subSystem + " : " + se.toString());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeConnection(connection, statement);
            log.exiting("findByPrimaryKey");
            throw throwable;
        }
    }

    public Collection findAll() throws CVersAccessException {
        log.entering("findAll");
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement(FINDALLSTRING);
                ResultSet resultSet = statement.executeQuery();
                Vector<ComponentElementIF> res = new Vector<ComponentElementIF>();
                while (resultSet.next()) {
                    ComponentFactoryIF factory = ComponentFactoryIF.getInstance();
                    ComponentElementIF compVers = factory.createComponentElement(resultSet.getString(3), resultSet.getString(4), resultSet.getString(1), resultSet.getString(2), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13), resultSet.getString(14), resultSet.getString(15), resultSet.getString(16), resultSet.getString(17));
                    res.addElement(compVers);
                }
                Vector<ComponentElementIF> vector = res;
                Object var8_8 = null;
                this.closeConnection(connection, statement);
                log.exiting("findAll");
                return vector;
            }
            catch (SQLException se) {
                log.error("Error executing SQL SELECT COMPONENTTYPE, SUBSYSTEM, VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS" + se.toString());
                throw new CVersSQLException("Error executing SQL SELECT COMPONENTTYPE, SUBSYSTEM, VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS" + se.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeConnection(connection, statement);
            log.exiting("findAll");
            throw throwable;
        }
    }

    public CVersDBObject findByRealKey(PreparedStatement findByRealKeyStatement, int compID, String _vendor, String _name, String _componentType, String _subsystem) throws SQLException {
        log.entering("findByRealKey");
        CVersDBObject cVersDBObject = null;
        findByRealKeyStatement.clearParameters();
        findByRealKeyStatement.setInt(1, compID);
        findByRealKeyStatement.setString(2, _componentType);
        findByRealKeyStatement.setString(3, _subsystem);
        ResultSet resultSet = findByRealKeyStatement.executeQuery();
        Vector res = new Vector();
        while (resultSet.next()) {
            if (!resultSet.getString(2).equalsIgnoreCase(_vendor) || !resultSet.getString(3).equalsIgnoreCase(_name)) continue;
            cVersDBObject = new CVersDBObject(compID, resultSet.getInt(1), _componentType, _subsystem, resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13), resultSet.getString(14), resultSet.getString(15), resultSet.getString(16));
        }
        log.debug("Found the following real key: " + cVersDBObject);
        log.exiting("findByRealKey");
        return cVersDBObject;
    }

    public CVersPK findPKByRealKey(PreparedStatement findByRealKeyStatement, int compID, String _vendor, String _name, String _componentType, String _subsystem) throws SQLException {
        log.entering("findByRealKey");
        CVersDBObject cVersDBObject = this.findByRealKey(findByRealKeyStatement, compID, _vendor, _name, _componentType, _subsystem);
        if (cVersDBObject == null) {
            return null;
        }
        return new CVersPK(cVersDBObject.getCompID(), cVersDBObject.getHashnumber(), cVersDBObject.getComponentType(), cVersDBObject.getSubsystem());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ComponentElementIF findByRealKey(String _vendor, String _name, String _componentType, String _subsystem) throws CVersAccessException {
        ComponentElementIF componentElementIF;
        log.entering("findByRealKey");
        Connection connection = null;
        PreparedStatement statement = null;
        int compID = HashKey.defaultHashFunction(_vendor, _name);
        try {
            try {
                ComponentElementIF compVers;
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement(FINDBYREALKEYSTRING);
                CVersDBObject cVersDBObject = this.findByRealKey(statement, compID, _vendor, _name, _componentType, _subsystem);
                log.debug("findByRealKey V=" + _vendor + " N=" + _name + " type=" + _componentType + " subsys=" + _subsystem);
                if (cVersDBObject == null) {
                    log.error("findByRealKey V=" + _vendor + " N=" + _name + " type=" + _componentType + " subsys=" + _subsystem + " NOT FOUND");
                    ComponentElementIF componentElementIF2 = null;
                    Object var13_12 = null;
                    this.closeConnection(connection, statement);
                    log.exiting("findByRealKey");
                    return componentElementIF2;
                }
                log.debug("findByRealKey V=" + _vendor + " N=" + _name + " type=" + _componentType + " subsys=" + _subsystem + " found");
                log.debug(cVersDBObject.toString());
                ComponentFactoryIF factory = ComponentFactoryIF.getInstance();
                componentElementIF = compVers = factory.createComponentElement(cVersDBObject.getVendor(), cVersDBObject.getName(), cVersDBObject.getComponentType(), cVersDBObject.getSubsystem(), cVersDBObject.getLocation(), cVersDBObject.getCounter(), cVersDBObject.getSCVendor(), cVersDBObject.getSCName(), cVersDBObject.getRelease(), cVersDBObject.getServiceLevel(), cVersDBObject.getDeltaVersion(), cVersDBObject.getUpdateVersion(), cVersDBObject.getApplyTime(), cVersDBObject.getSCElementTypeID(), cVersDBObject.getSPElementTypeID(), cVersDBObject.getSPName(), cVersDBObject.getSPVersion());
            }
            catch (SQLException se) {
                log.error("Error executing SQL SELECT HASHNUMBER, VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPID = ? AND COMPONENTTYPE = ? AND SUBSYSTEM = ? vendor=" + _vendor + " name=" + _name + " type=" + _componentType + " subsys=" + _subsystem, se);
                throw new CVersSQLException("Error executing SQL SELECT HASHNUMBER, VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPID = ? AND COMPONENTTYPE = ? AND SUBSYSTEM = ? vendor=" + _vendor + " name=" + _name + " type=" + _componentType + " subsys=" + _subsystem + " " + se.toString());
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.closeConnection(connection, statement);
            log.exiting("findByRealKey");
            throw throwable;
        }
        Object var13_13 = null;
        this.closeConnection(connection, statement);
        log.exiting("findByRealKey");
        return componentElementIF;
    }

    public Collection findByCompType(String _componentType) throws CVersAccessException {
        log.entering("findByCompType");
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement(FINDBYCOMPTYPESTRING);
                statement.setString(1, _componentType);
                ResultSet resultSet = statement.executeQuery();
                Vector<ComponentElementIF> res = new Vector<ComponentElementIF>();
                while (resultSet.next()) {
                    ComponentFactoryIF factory = ComponentFactoryIF.getInstance();
                    ComponentElementIF compVers = factory.createComponentElement(resultSet.getString(2), resultSet.getString(3), _componentType, resultSet.getString(1), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13), resultSet.getString(14), resultSet.getString(15), resultSet.getString(16));
                    res.addElement(compVers);
                }
                Vector<ComponentElementIF> vector = res;
                Object var9_9 = null;
                this.closeConnection(connection, statement);
                log.exiting("findByCompType");
                return vector;
            }
            catch (SQLException se) {
                log.error("Error executing SQL SELECT SUBSYSTEM, VENDOR, NAME,  LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPONENTTYPE = ?" + se.toString());
                throw new CVersSQLException("Error executing SQL SELECT SUBSYSTEM, VENDOR, NAME,  LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPONENTTYPE = ?" + se.toString());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeConnection(connection, statement);
            log.exiting("findByCompType");
            throw throwable;
        }
    }

    public Collection findByTypeAndSubsys(String _componentType, String _subsystem) throws CVersAccessException {
        log.entering("findByTypeAndSubsys");
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement(FINDBYTYPEANDSUBSYSSTRING);
                statement.setString(1, _componentType);
                statement.setString(2, _subsystem);
                ResultSet resultSet = statement.executeQuery();
                Vector<ComponentElementIF> res = new Vector<ComponentElementIF>();
                while (resultSet.next()) {
                    ComponentFactoryIF factory = ComponentFactoryIF.getInstance();
                    ComponentElementIF compVers = factory.createComponentElement(resultSet.getString(1), resultSet.getString(2), _componentType, _subsystem, resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13), resultSet.getString(14), resultSet.getString(15));
                    res.addElement(compVers);
                }
                Vector<ComponentElementIF> vector = res;
                Object var10_10 = null;
                this.closeConnection(connection, statement);
                log.exiting("findByTypeAndSubsys");
                return vector;
            }
            catch (SQLException se) {
                log.error("Error executing SQL SELECT VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPONENTTYPE = ? AND SUBSYSTEM = ? type=" + _componentType + " subsys=" + _subsystem, se);
                throw new CVersSQLException("Error executing SQL SELECT VENDOR, NAME, LOCATION, COUNTER, SCVENDOR, SCNAME, SAPRELEASE, SERVICELEVEL, DELTAVERSION, UPDATEVERSION, APPLYTIME, SCELEMENTTYPEID, SPELEMENTTYPEID, SPNAME, SPVERSION FROM BC_COMPVERS WHERE COMPONENTTYPE = ? AND SUBSYSTEM = ? type=" + _componentType + " subsys=" + _subsystem + " " + se.toString());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeConnection(connection, statement);
            log.exiting("findByTypeAndSubsys");
            throw throwable;
        }
    }

    public void removeCVers(ComponentElementIF[] cVersElements) throws CVersAccessException {
        log.entering("removeCVers");
        Connection connection = null;
        PreparedStatement findByRealKeyStatement = null;
        PreparedStatement removeStatement = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                findByRealKeyStatement = connection.prepareStatement(FINDBYREALKEYSTRING);
                removeStatement = connection.prepareStatement(REMOVESTRING);
                int i = 0;
                while (i < cVersElements.length) {
                    try {
                        CVersPK cVersPK = this.findPKByRealKey(findByRealKeyStatement, HashKey.defaultHashFunction(cVersElements[i].getVendor(), cVersElements[i].getName()), cVersElements[i].getVendor(), cVersElements[i].getName(), cVersElements[i].getComponentType(), cVersElements[i].getSubsystem());
                        if (cVersPK != null) {
                            log.debug("object will be removed: " + cVersPK.compID + "," + cVersPK.hashnumber + "," + cVersPK.componentType + "," + cVersPK.subSystem + "," + cVersElements[i].getVendor() + "," + cVersElements[i].getName());
                            this.remove(removeStatement, cVersPK);
                        } else {
                            log.debug("object does not exists in CVERS: " + cVersElements[i].getVendor() + "," + cVersElements[i].getName() + "," + cVersElements[i].getComponentType() + "," + cVersElements[i].getSubsystem());
                        }
                    }
                    catch (SQLException se) {
                        log.error("error during removal of entry: " + cVersElements[i].getVendor() + cVersElements[i].getName() + cVersElements[i].getComponentType() + cVersElements[i].getSubsystem() + se.toString());
                        throw new CVersAccessException("error during removal of entry: " + cVersElements[i].getVendor() + cVersElements[i].getName() + cVersElements[i].getComponentType() + cVersElements[i].getSubsystem() + se.toString());
                    }
                    ++i;
                }
            }
            catch (SQLException se) {
                log.error("Error removing entries from COMPVERS: " + se.toString());
                throw new CVersSQLException("Error removing entries from COMPVERS: " + se.toString());
            }
            Object var9_9 = null;
            this.closeConnection(connection, findByRealKeyStatement);
            this.closeConnection(connection, findByRealKeyStatement);
            log.exiting("removeCVers");
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeConnection(connection, findByRealKeyStatement);
            this.closeConnection(connection, findByRealKeyStatement);
            log.exiting("removeCVers");
            throw throwable;
        }
    }

    public void remove(PreparedStatement statement, CVersPK cVersPK) throws SQLException {
        log.entering("remove");
        statement.clearParameters();
        statement.setInt(1, cVersPK.compID);
        statement.setInt(2, cVersPK.hashnumber);
        statement.setString(3, cVersPK.componentType);
        statement.setString(4, cVersPK.subSystem);
        if (statement.executeUpdate() < 1) {
            log.error("Row can't be deleted since it does not exist: compID: " + cVersPK.compID + ", hashnumber: " + cVersPK.hashnumber + ", componenttype: " + cVersPK.componentType + ", subsystem: " + cVersPK.subSystem);
        }
        log.debug("object removed!");
        log.exiting("remove");
    }

    void closeConnection(Connection _connection, Statement _statement) {
        log.entering("closeConnection");
        try {
            if (_statement != null) {
                _statement.close();
            }
        }
        catch (SQLException se) {
            log.debug(se.toString());
        }
        try {
            if (_connection != null) {
                _connection.close();
            }
        }
        catch (SQLException se) {
            log.debug(se.toString());
        }
        log.exiting("closeConnection");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

