/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.views;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.ui.preferences.WebServicePreferences;
import com.sap.ide.ws.navigator.editors.service.ServiceEditor;
import com.sap.ide.ws.navigator.interfaces.ServiceContainer;
import com.sap.ide.ws.navigator.interfaces.implementation.ServiceContainerImpl;
import com.sap.ide.ws.navigator.properties.NavigatorRootEntry;
import com.sap.ide.ws.navigator.text.WsNavigatorUiTexts;
import com.sap.ide.ws.navigator.tree.INavigatorTreeNode;
import com.sap.ide.ws.navigator.tree.Server;
import com.sap.ide.ws.navigator.tree.ServerExpandListener;
import com.sap.ide.ws.navigator.tree.WsNavigatorRoot;
import com.sap.ide.ws.navigator.views.actions.DoubleclickAction;
import com.sap.ide.ws.navigator.views.actions.RefreshAction;
import com.sap.ide.ws.navigator.views.actions.SearchAction;
import com.sap.ide.ws.navigator.views.actions.ShowWSDLTypesAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class NavigatorView
extends ViewPart
implements SelectionListener,
IPropertySourceProvider {
    private static ServiceContainer sc = NavigatorView.createServiceContainerImpl();
    private TreeViewer viewer;
    private DoubleclickAction doubleClickAction;
    private WsNavigatorRoot wsnr = null;
    private RefreshAction refreshaction = null;
    private ShowWSDLTypesAction wsdlaction = null;
    private SearchAction searchaction = null;
    private boolean wsdlactionchecked = false;
    private static Vector editedobjects = new Vector();
    private static Vector editors = new Vector();
    PropertySheetPage psp = null;
    private static Display d = null;
    static Shell shell = null;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 772);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.viewer.getTree().addTreeListener((TreeListener)new ServerExpandListener());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.viewer.getTree().addSelectionListener((SelectionListener)this);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NavigatorView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.refreshaction);
        manager.add((IAction)this.wsdlaction);
        manager.add((IAction)this.searchaction);
    }

    private void fillContextMenu(IMenuManager manager) {
        TreeItem[] selected = this.viewer.getTree().getSelection();
        ((INavigatorTreeNode)selected[0].getData()).getContextMenu(manager);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshaction);
        manager.add((IAction)this.wsdlaction);
        manager.add((IAction)this.searchaction);
    }

    private void makeActions() {
        this.refreshaction = new RefreshAction(this.viewer.getTree());
        this.wsdlaction = new ShowWSDLTypesAction(this.viewer.getTree());
        this.wsdlaction.setChecked(this.wsdlactionchecked);
        this.wsdlaction.run();
        this.doubleClickAction = new DoubleclickAction(this.viewer.getTree());
        this.searchaction = new SearchAction(this.viewer.getTree());
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NavigatorView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)WsNavigatorUiTexts.getString("Navigator.text"), (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.psp != null) {
            TreeItem[] selected = this.viewer.getTree().getSelection();
            if (selected.length > 0) {
                INavigatorTreeNode ntn = (INavigatorTreeNode)this.viewer.getTree().getSelection()[0].getData();
                NavigatorRootEntry nre = new NavigatorRootEntry(ntn, 0, (Composite)this.psp.getControl());
                this.psp.setRootEntry((IPropertySheetEntry)nre);
            }
            this.psp.refresh();
        }
        if (e.widget == this.viewer.getTree()) {
            INavigatorTreeNode ntn = (INavigatorTreeNode)this.viewer.getTree().getSelection()[0].getData();
            this.refreshaction.setEnabled(ntn instanceof Server || ntn instanceof WsNavigatorRoot);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public Object getAdapter(Class c) {
        if (c.getName().equals("org.eclipse.ui.views.properties.IPropertySheetPage")) {
            this.psp = new PropertySheetPage();
            this.psp.setPropertySourceProvider((IPropertySourceProvider)this);
            TreeItem[] selected = this.viewer.getTree().getSelection();
            if (selected.length > 0) {
                INavigatorTreeNode ntn = (INavigatorTreeNode)this.viewer.getTree().getSelection()[0].getData();
                NavigatorRootEntry nre = new NavigatorRootEntry(ntn, 0, (Composite)this.psp.getControl());
                this.psp.setRootEntry((IPropertySheetEntry)new NavigatorRootEntry(ntn, 0, (Composite)this.psp.getControl()));
            }
            return this.psp;
        }
        return null;
    }

    public IPropertySource getPropertySource(Object object) {
        return null;
    }

    public void saveState(IMemento memento) {
    }

    public void save() {
        IWorkspace worksp = ResourcesPlugin.getWorkspace();
        File workdir = worksp.getRoot().getLocation().toFile();
        File plugindir = new File(workdir, ".metadata" + File.separator + ".plugins" + File.separator + "com.sap.ide.ws.navigator");
        if (!plugindir.exists()) {
            plugindir.mkdirs();
        }
        DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            doc.appendChild(this.wsnr.createDOMNode(doc));
            TransformerFactoryImpl tf = new TransformerFactoryImpl();
            Transformer t = tf.newTransformer();
            File servers = new File(plugindir, "servers.xml");
            t.setOutputProperty("indent", "yes");
            FileOutputStream out = new FileOutputStream(servers);
            t.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
        }
    }

    public void dispose() {
        this.save();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        d = Display.getCurrent();
        shell = site.getShell();
        IWorkspace worksp = ResourcesPlugin.getWorkspace();
        File workdir = worksp.getRoot().getLocation().toFile();
        File plugindir = new File(workdir, ".metadata" + File.separator + ".plugins" + File.separator + "com.sap.ide.ws.navigator");
        File servers = new File(plugindir, "servers.xml");
        this.wsnr = new WsNavigatorRoot();
        Server s = NavigatorView.getDefaultServer(true);
        this.wsnr.addServer(s);
        if (servers.exists()) {
            try {
                DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
                DocumentBuilder db = dbf.newDocumentBuilder();
                FileInputStream input = new FileInputStream(servers);
                Document d = db.parse(input);
                Node e = d.getFirstChild();
                while (e != null) {
                    String showwsdls;
                    if (e.getNodeName().equals("servers")) {
                        Node e1 = e.getFirstChild();
                        while (e1 != null) {
                            if (e1.getNodeName().equals("server")) {
                                String name = null;
                                String wsil = null;
                                Node e2 = e1.getFirstChild();
                                while (e2 != null) {
                                    Node e3;
                                    if (e2.getNodeName().equals("server-name")) {
                                        e3 = e2.getFirstChild();
                                        while (e3 != null) {
                                            if (e3 instanceof Text) {
                                                name = ((Text)e3).getData();
                                            }
                                            e3 = e3.getNextSibling();
                                        }
                                    } else if (e2.getNodeName().equals("wsil-location")) {
                                        e3 = e2.getFirstChild();
                                        while (e3 != null) {
                                            if (e3 instanceof Text) {
                                                wsil = ((Text)e3).getData();
                                            }
                                            e3 = e3.getNextSibling();
                                        }
                                    }
                                    e2 = e2.getNextSibling();
                                }
                                if (name != null && wsil != null) {
                                    s = new Server(name, wsil, Display.getCurrent(), shell, true);
                                    this.wsnr.addServer(s);
                                }
                            }
                            e1 = e1.getNextSibling();
                        }
                    }
                    if ((showwsdls = ((Element)e).getAttribute("show-wsdls")) != null && showwsdls.equals("yes")) {
                        this.wsdlactionchecked = true;
                        this.wsnr.setShowWSDLs(true);
                    }
                    e = e.getNextSibling();
                }
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
            }
        }
    }

    public static ServiceEditor getEditor(TreeItem ti) {
        int i = 0;
        while (i < editedobjects.size()) {
            if (editedobjects.elementAt(i) == ti) {
                return (ServiceEditor)((Object)editors.elementAt(i));
            }
            ++i;
        }
        return null;
    }

    public static void registerEditor(TreeItem ti, ServiceEditor editor) {
        editedobjects.add(ti);
        editors.add(editor);
    }

    public static void removeEditor(ServiceEditor editor) {
        int i = 0;
        while (i < editors.size()) {
            if (editors.elementAt(i) == editor) {
                editors.remove(i);
                editedobjects.remove(i);
            }
            ++i;
        }
    }

    public static Vector getEditors() {
        return editors;
    }

    public static Server getDefaultServer() {
        String serverhost = WebServicePreferences.getAppServerHost();
        Server s = new Server(serverhost, serverhost + "/inspection.wsil", d, shell);
        s.setIsDefaultServer(true);
        return s;
    }

    public static Server getDefaultServer(boolean empty) {
        String serverhost = WebServicePreferences.getAppServerHost();
        Server s = new Server(serverhost, serverhost + "/inspection.wsil", d, shell, empty);
        s.setIsDefaultServer(true);
        return s;
    }

    public static ServiceContainer createServiceContainerImpl() {
        return new ServiceContainerImpl();
    }

    public static ServiceContainer getServiceContainerImpl() {
        return sc;
    }

    public static Shell getShell() {
        return shell;
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof TreeParent) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent invisibleRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(ResourcesPlugin.getWorkspace())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }

        private void initialize() {
            TreeItem i = new TreeItem(NavigatorView.this.viewer.getTree(), 0);
            NavigatorView.this.wsnr.fillTreeNode(i);
            i.setData((Object)NavigatorView.this.wsnr);
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList children = new ArrayList();

        public TreeParent(String name) {
            super(name);
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            ((AbstractCollection)this.children).remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class TreeObject
    implements IAdaptable {
        private String name;
        private TreeParent parent;

        public TreeObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }
}

