/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.tree.actions;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.navigator.NavigatorPlugin;
import com.sap.ide.ws.navigator.text.WsNavigatorUiTexts;
import com.sap.ide.ws.navigator.tree.Server;
import com.sap.ide.ws.navigator.tree.Service;
import com.sap.ide.ws.navigator.tree.WsNavigatorRoot;
import com.sap.ide.ws.navigator.views.NavigatorView;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class AddToRootAction
extends Action {
    TreeItem item = null;

    public AddToRootAction(TreeItem ti) {
        this.setText(WsNavigatorUiTexts.getString("AddToRootAction.text"));
        this.setImageDescriptor(NavigatorPlugin.getDefault().getImageRegistry().getDescriptor("add_server.gif"));
        this.item = ti;
    }

    public void run() {
        Composite c = this.item.getParent().getParent();
        NewServerDialog nsd = new NewServerDialog(c.getShell(), this.item);
        nsd.open();
    }

    class NewServerDialog
    extends Dialog
    implements SelectionListener,
    Runnable,
    IRunnableWithProgress,
    KeyListener {
        private Text servernametext = null;
        private Text wsilnametext = null;
        private Button okbutton;
        private Button cancelbutton;
        private WsNavigatorRoot data = null;
        private Display d = null;
        private Server s = null;
        private String servername = null;
        private String wsilname = null;
        private boolean failed = false;

        public NewServerDialog(Shell parentShell, TreeItem ti) {
            super(parentShell);
            this.data = (WsNavigatorRoot)ti.getData();
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            c.getShell().setText(WsNavigatorUiTexts.getString("AddToRootAction.text"));
            return c;
        }

        public Control createContents(Composite parent) {
            Point p = parent.computeSize(300, 170);
            parent.setSize(p);
            parent.setLayout((Layout)new FillLayout());
            Composite c = (Composite)this.createDialogArea(parent);
            c.setLayout((Layout)new FillLayout());
            IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)c, (int)1);
            mainPane.setMargin(12, 12);
            IGridLayoutPane internalpane = mainPane.addGridLayoutPane(1, mainPane.createGridLayoutData(4, 2, true, false, 2, 1));
            internalpane.addTextLabel(WsNavigatorUiTexts.getString("Server.name"));
            this.servernametext = internalpane.addTextField("", mainPane.createGridLayoutData(4, 2, true, false, 2, 1));
            internalpane.addTextLabel(WsNavigatorUiTexts.getString("NavigatorRootEntry.wsil.location"));
            this.wsilnametext = internalpane.addTextField("http://", mainPane.createGridLayoutData(4, 2, true, false, 2, 1));
            IGridLayoutPane buttoncontainer = mainPane.addGridLayoutPane(1, mainPane.createGridLayoutData(4, 2, false, false, 1, 2));
            IGridLayoutPane pane = buttoncontainer.addGridLayoutPane(1, buttoncontainer.createGridLayoutData(4, 2, true, false, 1, 2));
            pane.addTextLabel("");
            IGridLayoutPane buttonpane = buttoncontainer.addGridLayoutPane(3, buttoncontainer.createGridLayoutData(4, 2, true, false, 1, 2));
            this.okbutton = buttonpane.addPushButton("    " + WsNavigatorUiTexts.getString("Ok") + "      ", mainPane.createGridLayoutData(3, 1, false, false, 1, 2));
            buttonpane.addTextLabel("  ", mainPane.createGridLayoutData(2, 1, false, false, 1, 2));
            this.cancelbutton = buttonpane.addPushButton("   " + WsNavigatorUiTexts.getString("Cancel") + "   ", mainPane.createGridLayoutData(1, 2, false, false, 1, 2));
            this.okbutton.addSelectionListener((SelectionListener)this);
            this.cancelbutton.addSelectionListener((SelectionListener)this);
            this.servernametext.addKeyListener((KeyListener)this);
            this.wsilnametext.addKeyListener((KeyListener)this);
            return mainPane.getComposite();
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.okbutton) {
                if (!this.servernametext.getText().equals("") && !this.wsilnametext.getText().equals("")) {
                    this.d = Display.getCurrent();
                    this.servername = this.servernametext.getText();
                    this.wsilname = this.wsilnametext.getText();
                    ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
                    try {
                        pmd.run(true, true, (IRunnableWithProgress)this);
                    }
                    catch (Exception e1) {
                        WebServiceCorePlugin.logError((Throwable)e1, this.getClass());
                        this.failed = true;
                        MessageDialog.openError((Shell)this.getShell(), (String)WsNavigatorUiTexts.getString("Navigator.error"), (String)WsNavigatorUiTexts.getString("Server.error"));
                    }
                } else {
                    this.failed = true;
                    MessageDialog.openError((Shell)this.getShell(), (String)WsNavigatorUiTexts.getString("Navigator.error"), (String)WsNavigatorUiTexts.getString("AddToRootAction.incorrect.input"));
                }
            } else if (e.widget == this.cancelbutton) {
                this.close();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void run() {
            if (!this.s.hasError()) {
                Vector services = this.s.getServices();
                this.data.addServer(this.s);
                int i = 0;
                while (i < services.size()) {
                    if (this.data.getShowWSDLs()) {
                        ((Service)services.elementAt(i)).addAllWSDLs();
                    } else {
                        ((Service)services.elementAt(i)).removeAllWSDLs();
                    }
                    ++i;
                }
            }
            this.close();
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(WsNavigatorUiTexts.getString("AddToRootAction.adding.server"), 100);
            this.s = new Server(this.servername, this.wsilname, this.d, NavigatorView.getShell());
            monitor.worked(100);
            this.d.asyncExec((Runnable)this);
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\r' && !this.servernametext.getText().equals("") && !this.wsilnametext.getText().equals("")) {
                this.d = Display.getCurrent();
                this.servername = this.servernametext.getText();
                this.wsilname = this.wsilnametext.getText();
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
                try {
                    pmd.run(true, true, (IRunnableWithProgress)this);
                }
                catch (Exception e1) {
                    WebServiceCorePlugin.logError((Throwable)e1, this.getClass());
                    this.failed = true;
                    MessageDialog.openError((Shell)this.getShell(), (String)WsNavigatorUiTexts.getString("Navigator.error"), (String)WsNavigatorUiTexts.getString("Server.error"));
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

