/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.tree;

import com.sap.ide.ws.navigator.NavigatorPlugin;
import com.sap.ide.ws.navigator.editors.service.ServiceEditor;
import com.sap.ide.ws.navigator.text.WsNavigatorUiTexts;
import com.sap.ide.ws.navigator.tree.INavigatorTreeNode;
import com.sap.ide.ws.navigator.tree.Server;
import com.sap.ide.ws.navigator.tree.actions.AddToRootAction;
import com.sap.ide.ws.navigator.tree.actions.RefreshRootAction;
import com.sap.ide.ws.navigator.views.NavigatorView;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsNavigatorRoot
implements INavigatorTreeNode,
IRunnableWithProgress,
Runnable {
    TreeItem containertreeitem = null;
    Vector servers = new Vector();
    private boolean showwsdls = false;
    private IProgressMonitor ipm = null;
    private Display d = null;

    public void fillTreeNode(TreeItem newitem) {
        newitem.setText(WsNavigatorUiTexts.getString("WsNavigatorRoot.servers"));
        this.containertreeitem = newitem;
        newitem.setImage(NavigatorPlugin.getImage("root.gif"));
        this.servers = this.getServers();
        int i = 0;
        while (i < this.servers.size()) {
            TreeItem ti = new TreeItem(this.containertreeitem, 0);
            ((Server)this.servers.elementAt(i)).fillTreeNode(ti);
            ++i;
        }
    }

    public void getContextMenu(IMenuManager mm) {
        RefreshRootAction rra = new RefreshRootAction(this.containertreeitem);
        mm.add((IAction)rra);
        AddToRootAction atra = new AddToRootAction(this.containertreeitem);
        mm.add((IAction)atra);
    }

    public Vector getServers() {
        return this.servers;
    }

    public void addServer(Server s) {
        this.servers.add(s);
        if (this.containertreeitem != null) {
            TreeItem ti = new TreeItem(this.containertreeitem, 0);
            s.fillTreeNode(ti);
        }
    }

    public void removeServer(Server s) {
        this.servers.remove(s);
        Vector services = s.getServices();
        TreeItem[] items = this.containertreeitem.getItems();
        int i = 0;
        while (i < services.size()) {
            ServiceEditor se = NavigatorView.getEditor(s.containertreeitem);
            if (se != null) {
                NavigatorView.removeEditor(se);
            }
            int j = 0;
            while (j < items.length) {
                se = NavigatorView.getEditor(items[j]);
                if (se != null) {
                    se.getEditorSite().getPage().closeEditor((IEditorPart)se, false);
                    NavigatorView.removeEditor(se);
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2].getData() == s) {
                items[i2].dispose();
            }
            ++i2;
        }
    }

    public Node createDOMNode(Document doc) {
        Element e = doc.createElement("servers");
        if (this.showwsdls) {
            e.setAttribute("show-wsdls", "yes");
        } else {
            e.setAttribute("show-wsdls", "no");
        }
        int i = 1;
        while (i < this.servers.size()) {
            e.appendChild(((Server)this.servers.elementAt(i)).createDOMNode(doc));
            ++i;
        }
        return e;
    }

    public void setShowWSDLs(boolean show) {
        this.showwsdls = show;
    }

    public boolean getShowWSDLs() {
        return this.showwsdls;
    }

    public void prepareRefresh() {
        int i = 0;
        while (i < this.servers.size()) {
            ((Server)this.servers.elementAt(i)).prepareRefresh();
            ++i;
        }
    }

    public void refresh() {
        if (this.ipm != null) {
            this.ipm.beginTask(WsNavigatorUiTexts.getString("Refresh.text"), 100);
        }
        int i = 0;
        while (i < this.servers.size()) {
            int startwork = 100 * i / this.servers.size();
            int endwork = 100 * (i + 1) / this.servers.size();
            if (this.ipm != null) {
                this.ipm.setTaskName("Refreshing " + ((Server)this.servers.elementAt(i)).getName());
            }
            if (i == 0) {
                TreeItem item = ((Server)this.servers.elementAt(0)).getParentItem();
                this.updateDefaultServer();
                ((Server)this.servers.elementAt(0)).setParentItem(item);
            }
            ((Server)this.servers.elementAt(i)).setEmpty(false);
            ((Server)this.servers.elementAt(i)).setDisplay(null);
            ((Server)this.servers.elementAt(i)).refresh(startwork, endwork, this.ipm);
            ((Server)this.servers.elementAt(i)).setDisplay(this.d);
            ++i;
        }
        this.d.asyncExec((Runnable)this);
    }

    public void refreshUI() {
        int i = 0;
        while (i < this.servers.size()) {
            ((Server)this.servers.elementAt(i)).refreshUI();
            ++i;
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.ipm = monitor;
        this.refresh();
    }

    public void setDisplay(Display d) {
        this.d = d;
    }

    public void run() {
        this.refreshUI();
    }

    public Server updateDefaultServer() {
        if (this.servers.size() > 0) {
            this.servers.remove(0);
        }
        this.servers.add(0, NavigatorView.getDefaultServer(true));
        Server s = (Server)this.servers.elementAt(0);
        return s;
    }
}

