/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.tree;

import com.sap.ide.ws.navigator.NavigatorPlugin;
import com.sap.ide.ws.navigator.editors.service.ServiceEditor;
import com.sap.ide.ws.navigator.editors.service.ServiceEditorInput;
import com.sap.ide.ws.navigator.interfaces.ServiceObject;
import com.sap.ide.ws.navigator.tree.INavigatorTreeNode;
import com.sap.ide.ws.navigator.tree.Server;
import com.sap.ide.ws.navigator.tree.Service;
import com.sap.ide.ws.navigator.tree.actions.DeployableProxyServiceAction;
import com.sap.ide.ws.navigator.tree.actions.OpenServiceAction;
import com.sap.ide.ws.navigator.tree.actions.StandaloneProxyServiceAction;
import com.sap.ide.ws.navigator.views.NavigatorView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceWSDL
implements INavigatorTreeNode {
    String name = null;
    TreeItem containertreeitem = null;
    ServiceObject[] objects = null;
    boolean refreshfailed = false;

    public ServiceWSDL(String name) {
        this.name = name;
    }

    public void fillTreeNode(TreeItem newitem) {
        this.containertreeitem = newitem;
        newitem.setData((Object)this);
        newitem.setImage(NavigatorPlugin.getImage("wsdl.gif"));
        newitem.setText(this.name);
    }

    public void getContextMenu(IMenuManager mm) {
        OpenServiceAction osa = new OpenServiceAction(this.containertreeitem);
        mm.add((IAction)osa);
        DeployableProxyServiceAction dpsa = new DeployableProxyServiceAction(this.containertreeitem);
        mm.add((IAction)dpsa);
        StandaloneProxyServiceAction spsa = new StandaloneProxyServiceAction(this.containertreeitem);
        mm.add((IAction)spsa);
    }

    public Node createDOMNode(Document doc) {
        return null;
    }

    public String getURL() {
        String serverhost = Server.getDefaultServerURL();
        TreeItem item = this.containertreeitem.getParentItem();
        Service s = (Service)item.getData();
        return NavigatorView.getServiceContainerImpl().getURL(s.so, this.name, serverhost);
    }

    public void prepareRefresh() {
        this.objects = new ServiceObject[1];
        Service s = (Service)this.containertreeitem.getParentItem().getData();
        this.objects[0] = s.so;
    }

    public void refreshUI() {
        ServiceEditor se;
        if (!this.refreshfailed && (se = NavigatorView.getEditor(this.containertreeitem)) != null) {
            se.refresh(new ServiceEditorInput(this.getURL(), this.containertreeitem.getParentItem().getText()));
        }
    }

    public String getWSDL() {
        TreeItem item = this.containertreeitem.getParentItem();
        Service s = (Service)item.getData();
        return s.getWSDL(this.name);
    }
}

