/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.tree;

import com.sap.ide.ws.navigator.NavigatorPlugin;
import com.sap.ide.ws.navigator.editors.service.ServiceEditor;
import com.sap.ide.ws.navigator.editors.service.ServiceEditorInput;
import com.sap.ide.ws.navigator.interfaces.ServiceObject;
import com.sap.ide.ws.navigator.tree.INavigatorTreeNode;
import com.sap.ide.ws.navigator.tree.Server;
import com.sap.ide.ws.navigator.tree.ServiceWSDL;
import com.sap.ide.ws.navigator.tree.actions.DeployableProxyServiceAction;
import com.sap.ide.ws.navigator.tree.actions.OpenServiceAction;
import com.sap.ide.ws.navigator.tree.actions.StandaloneProxyServiceAction;
import com.sap.ide.ws.navigator.views.NavigatorView;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Service
implements INavigatorTreeNode {
    String servicename = null;
    TreeItem containertreeitem = null;
    Vector servicewsdls = new Vector();
    ServiceObject so = null;
    String tooltip = "";
    boolean addwsdlsonrefresh = false;
    boolean refreshfailed = false;
    String wsdl;

    public Service(String name) {
        this.servicename = name;
    }

    public Service(ServiceObject sobj) {
        this.so = sobj;
        this.wsdl = sobj.getWSDL("");
        this.servicename = this.so.getName();
        this.tooltip = this.so.getDescription();
    }

    public void fillTreeNode(TreeItem newitem) {
        this.containertreeitem = newitem;
        newitem.setData((Object)this);
        newitem.setText(this.servicename);
        newitem.setImage(NavigatorPlugin.getImage("WebService.gif"));
        int i = 0;
        while (i < this.servicewsdls.size()) {
            TreeItem ti = new TreeItem(this.containertreeitem, 0);
            ((ServiceWSDL)this.servicewsdls.elementAt(i)).fillTreeNode(ti);
            ++i;
        }
    }

    public void getContextMenu(IMenuManager mm) {
        OpenServiceAction osa = new OpenServiceAction(this.containertreeitem);
        mm.add((IAction)osa);
        DeployableProxyServiceAction dpsa = new DeployableProxyServiceAction(this.containertreeitem);
        mm.add((IAction)dpsa);
        StandaloneProxyServiceAction spsa = new StandaloneProxyServiceAction(this.containertreeitem);
        mm.add((IAction)spsa);
    }

    public Node createDOMNode(Document doc) {
        return null;
    }

    public Vector getServiceWSDLs() {
        return this.servicewsdls;
    }

    public void addAllWSDLs() {
        String[] styles = this.so.getStyles();
        int i = 0;
        while (i < styles.length) {
            this.servicewsdls.add(new ServiceWSDL(styles[i]));
            ++i;
        }
        ServiceEditor se = NavigatorView.getEditor(this.containertreeitem);
        if (this.containertreeitem != null) {
            int i2 = 0;
            while (i2 < this.servicewsdls.size()) {
                TreeItem ti = new TreeItem(this.containertreeitem, 0);
                ((ServiceWSDL)this.servicewsdls.elementAt(i2)).fillTreeNode(ti);
                ++i2;
            }
        }
        this.addwsdlsonrefresh = true;
    }

    public String getURL() {
        String serverhost = Server.getDefaultServerURL();
        return NavigatorView.getServiceContainerImpl().getURL(this.so, "", serverhost);
    }

    public void removeAllWSDLs() {
        this.servicewsdls.clear();
        TreeItem[] wsdls = this.containertreeitem.getItems();
        int i = 0;
        while (i < wsdls.length) {
            ServiceEditor se = NavigatorView.getEditor(wsdls[i]);
            if (se != null) {
                NavigatorView.removeEditor(se);
                se.getEditorSite().getPage().closeEditor((IEditorPart)se, false);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < wsdls.length) {
            wsdls[i2].dispose();
            ++i2;
        }
        this.addwsdlsonrefresh = false;
    }

    public void prepareRefresh() {
        if (this.addwsdlsonrefresh) {
            this.removeAllWSDLs();
            this.addwsdlsonrefresh = true;
        }
    }

    public void refreshUI() {
        if (this.addwsdlsonrefresh && !this.refreshfailed) {
            this.addAllWSDLs();
        }
        this.containertreeitem.setText(this.servicename);
        ServiceEditor se = NavigatorView.getEditor(this.containertreeitem);
        if (se != null) {
            se.refresh(new ServiceEditorInput(this.getURL(), this.containertreeitem.getText()));
        }
    }

    public String getWSDL() {
        return this.wsdl;
    }

    public String getWSDL(String style) {
        return this.so.getWSDL(style);
    }
}

