/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.tree;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.ui.preferences.WebServicePreferences;
import com.sap.ide.ws.navigator.NavigatorPlugin;
import com.sap.ide.ws.navigator.editors.service.ServiceEditor;
import com.sap.ide.ws.navigator.interfaces.ServiceObject;
import com.sap.ide.ws.navigator.interfaces.WSILSecurityException;
import com.sap.ide.ws.navigator.text.WsNavigatorUiTexts;
import com.sap.ide.ws.navigator.tree.INavigatorTreeNode;
import com.sap.ide.ws.navigator.tree.Service;
import com.sap.ide.ws.navigator.tree.WsNavigatorRoot;
import com.sap.ide.ws.navigator.tree.actions.RefreshServerAction;
import com.sap.ide.ws.navigator.tree.actions.RemoveServerAction;
import com.sap.ide.ws.navigator.views.NavigatorView;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Server
implements INavigatorTreeNode,
IRunnableWithProgress,
Runnable {
    TreeItem containertreeitem = null;
    Vector services;
    String servername = null;
    String wsilname = null;
    Display d = null;
    IProgressMonitor ipm = null;
    Display dialogdisplay = null;
    Shell sh = null;
    boolean empty = true;
    boolean error = false;
    boolean isdefaultserver = false;

    public Server(String name, String wsilname, Display d, Shell shell, boolean empty) {
        this.empty = empty;
        if (!empty) {
            this.init(name, wsilname, d, shell);
        } else {
            this.servername = name;
            this.wsilname = wsilname;
            this.dialogdisplay = d;
            this.services = new Vector();
            this.sh = shell;
        }
    }

    public Server(String name, String wsilname, Display d, Shell shell) {
        this.init(name, wsilname, d, shell);
    }

    /*
     * Unable to fully structure code
     */
    public void init(String name, String wsilname, Display d, Shell shell) {
        this.servername = name;
        this.wsilname = wsilname;
        this.dialogdisplay = d;
        this.services = new Vector<E>();
        this.sh = shell;
        this.empty = false;
        sc = NavigatorView.getServiceContainerImpl();
        try {
            block10: {
                accepted = false;
                serviceobjs = new ServiceObject[]{};
                try {
                    serviceobjs = sc.getServices(wsilname);
                    accepted = true;
                    break block10;
                }
                catch (WSILSecurityException wse) {
                    i = 0;
                    ** while (i < 3 && !accepted)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        ad = new AuthorizationDialog(shell, this);
                        this.dialogdisplay.syncExec((Runnable)ad);
                        if (ad.getOKPressed()) {
                            serviceobjs = sc.getServices(wsilname, ad.getUser(), ad.getPassword());
                            accepted = true;
                            continue;
                        }
                        i = 3;
                    }
                    catch (WSILSecurityException wse1) {
                        if (++i == 3) {
                            WebServiceCorePlugin.logError((Throwable)wse1, this.getClass());
                        }
                        MessageDialog.openError((Shell)shell, (String)WsNavigatorUiTexts.getString("Server.authorization"), (String)WsNavigatorUiTexts.getString("Server.incorrect.login"));
                    }
                    continue;
                }
            }
            i = 0;
            while (i < serviceobjs.length) {
                this.services.add(new Service(serviceobjs[i]));
                ++i;
            }
        }
        catch (Exception e) {
            this.error = true;
            d.syncExec((Runnable)new ErrorDialog(shell, e));
        }
    }

    public void fillTreeNode(TreeItem newitem) {
        int i;
        String detail;
        this.containertreeitem = newitem;
        if (!this.error) {
            detail = !this.empty ? "  (" + this.getServices().size() + " " + WsNavigatorUiTexts.getString("Server.web.services") + ")" : "";
        } else {
            detail = " - " + WsNavigatorUiTexts.getString("Navigator.error");
            TreeItem[] items = this.containertreeitem.getItems();
            i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
        }
        if (this.containertreeitem.getParentItem().getItems()[0] == this.containertreeitem) {
            newitem.setText(WsNavigatorUiTexts.getString("Server.local") + detail);
        } else {
            newitem.setText(this.getName() + detail);
        }
        newitem.setData((Object)this);
        newitem.setImage(NavigatorPlugin.getImage("Server.gif"));
        if (!this.empty) {
            Vector services = this.getServices();
            i = 0;
            while (i < services.size()) {
                TreeItem ti = new TreeItem(this.containertreeitem, 0);
                ((Service)services.elementAt(i)).fillTreeNode(ti);
                ++i;
            }
        } else if (!this.error) {
            TreeItem emptyitem = new TreeItem(this.containertreeitem, 0);
            emptyitem.setText("<Empty>");
            emptyitem.setData(new Object());
        }
    }

    public void getContextMenu(IMenuManager mm) {
        RefreshServerAction refsa = new RefreshServerAction(this.containertreeitem);
        mm.add((IAction)refsa);
        if (this != this.containertreeitem.getParentItem().getItems()[0].getData()) {
            RemoveServerAction remsa = new RemoveServerAction(this.containertreeitem);
            mm.add((IAction)remsa);
        }
    }

    public String getName() {
        return this.servername;
    }

    public Vector getServices() {
        return this.services;
    }

    public Node createDOMNode(Document doc) {
        Element e = doc.createElement("server");
        Element e1 = doc.createElement("server-name");
        org.w3c.dom.Text t = doc.createTextNode(this.servername);
        e1.appendChild(t);
        e.appendChild(e1);
        e1 = doc.createElement("wsil-location");
        t = doc.createTextNode(this.wsilname);
        e1.appendChild(t);
        e.appendChild(e1);
        return e;
    }

    public void prepareRefresh() {
        TreeItem[] items = this.containertreeitem.getItems();
        int i = 0;
        while (i < items.length) {
            ServiceEditor se = NavigatorView.getEditor(items[i]);
            if (se != null) {
                NavigatorView.removeEditor(se);
                se.getEditorSite().getPage().closeEditor((IEditorPart)se, false);
            }
            TreeItem[] items1 = items[i].getItems();
            int j = 0;
            while (j < items1.length) {
                se = NavigatorView.getEditor(items1[j]);
                if (se != null) {
                    NavigatorView.removeEditor(se);
                    se.getEditorSite().getPage().closeEditor((IEditorPart)se, false);
                }
                ++j;
            }
            items[i].dispose();
            ++i;
        }
        this.services.clear();
    }

    /*
     * Unable to fully structure code
     */
    public void refresh(int start, int end, IProgressMonitor ipm) {
        block17: {
            sc = NavigatorView.getServiceContainerImpl();
            this.error = false;
            donework = 0;
            try {
                block16: {
                    accepted = false;
                    serviceobjs = new ServiceObject[]{};
                    try {
                        serviceobjs = sc.getServices(this.wsilname);
                        accepted = true;
                        break block16;
                    }
                    catch (WSILSecurityException wse) {
                        i = 0;
                        ** while (i < 3 && !accepted)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ad = new AuthorizationDialog(this.sh, this);
                            this.dialogdisplay.syncExec((Runnable)ad);
                            if (ad.getOKPressed()) {
                                serviceobjs = sc.getServices(this.wsilname, ad.getUser(), ad.getPassword());
                                accepted = true;
                                continue;
                            }
                            i = 3;
                        }
                        catch (WSILSecurityException wse1) {
                            if (++i == 3) {
                                WebServiceCorePlugin.logError((Throwable)wse1, this.getClass());
                            }
                            MessageDialog.openError((Shell)this.sh, (String)WsNavigatorUiTexts.getString("Server.authorization"), (String)WsNavigatorUiTexts.getString("Server.incorrect.login"));
                        }
                        continue;
                    }
                }
                if (serviceobjs.length == 0) {
                    work = end - start;
                    if (ipm != null) {
                        ipm.worked(work);
                        donework += work;
                    }
                } else {
                    work = (end - start) / serviceobjs.length;
                }
                i = 0;
                while (i < serviceobjs.length) {
                    this.services.add(new Service(serviceobjs[i]));
                    if (ipm != null) {
                        ipm.worked(work);
                        donework += work;
                    }
                    ++i;
                }
                if (ipm != null) {
                    ipm.worked(end - start - donework);
                }
            }
            catch (Exception e) {
                this.error = true;
                this.d.syncExec((Runnable)new ErrorDialog(this.sh, e));
                if (ipm == null) break block17;
                ipm.worked(end - start - donework);
            }
        }
        if (this.d != null) {
            this.d.asyncExec((Runnable)this);
            this.d = null;
        }
    }

    public void refreshUI() {
        Tree t = this.containertreeitem.getParent();
        TreeItem root = t.getItems()[0];
        WsNavigatorRoot wsnr = (WsNavigatorRoot)root.getData();
        this.fillTreeNode(this.containertreeitem);
        if (wsnr.getShowWSDLs()) {
            int i = 0;
            while (i < this.services.size()) {
                ((Service)this.services.elementAt(i)).addAllWSDLs();
                ++i;
            }
        }
    }

    public String getWSIL() {
        return this.wsilname;
    }

    public void setDisplay(Display d) {
        this.d = d;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.ipm = monitor;
        this.refresh(0, 100, this.ipm);
    }

    public void run() {
        this.refreshUI();
    }

    public void setParentItem(TreeItem item) {
        this.containertreeitem = item;
    }

    public TreeItem getParentItem() {
        return this.containertreeitem;
    }

    public static String getDefaultServerURL() {
        return WebServicePreferences.getAppServerHost();
    }

    public boolean getEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean b) {
        this.empty = b;
    }

    public TreeItem getTreeItem() {
        return this.containertreeitem;
    }

    public void setIsDefaultServer(boolean defaultserver) {
        this.isdefaultserver = defaultserver;
    }

    public boolean isDefaultServer() {
        return this.isdefaultserver;
    }

    public boolean hasError() {
        return this.error;
    }

    class ErrorDialog
    implements Runnable {
        Shell shell;
        Throwable t;

        public ErrorDialog(Shell shell, Throwable t) {
            this.shell = shell;
            this.t = t;
        }

        public void run() {
            Server.this.error = true;
            if (Server.this.getName().equals("http://:")) {
                MessageDialog.openError((Shell)this.shell, (String)WsNavigatorUiTexts.getString("Navigator.error"), (String)(WsNavigatorUiTexts.getString("Server.missing") + "\n" + this.t.toString()));
            } else {
                String detailtext = " '" + Server.this.getName() + "'\n " + "(" + Server.this.getWSIL() + ")\n";
                MessageDialog.openError((Shell)this.shell, (String)WsNavigatorUiTexts.getString("Navigator.error"), (String)(WsNavigatorUiTexts.getString("Server.error") + detailtext + this.t.toString()));
            }
        }
    }

    class AuthorizationDialog
    extends Dialog
    implements Runnable,
    SelectionListener {
        private Button okbutton;
        private Text usernametext;
        private Text passwdtext;
        private Server server;
        private String user;
        private String pass;
        boolean okpressed = false;

        public AuthorizationDialog(Shell parentShell, Server s) {
            super(parentShell);
            this.server = s;
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            c.getShell().setText(WsNavigatorUiTexts.getString("Server.AuthorizationDialog.title"));
            return c;
        }

        public Control createContents(Composite parent) {
            Point p = parent.computeSize(400, 200);
            parent.setSize(p);
            parent.setLayout((Layout)new FillLayout());
            Composite c = (Composite)this.createDialogArea(parent);
            c.setLayout((Layout)new FillLayout());
            IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)c, (int)2);
            mainPane.setMargin(12, 12);
            IGridLayoutPane internalpane = mainPane.addGridLayoutPane(WsNavigatorUiTexts.getString("Server.AuthorizationDialog.instructions"), 2, mainPane.createGridLayoutData(4, 2, true, false, 2, 1));
            internalpane.addTextLabel(WsNavigatorUiTexts.getString("Server.name"));
            internalpane.addTextField(this.server.getName(), true, mainPane.createGridLayoutData(4, 2, true, false, 1, 1));
            internalpane.addTextLabel(WsNavigatorUiTexts.getString("NavigatorRootEntry.wsil.location"));
            internalpane.addTextField(this.server.getWSIL(), true, mainPane.createGridLayoutData(4, 2, true, false, 1, 1));
            internalpane.addTextLabel(WsNavigatorUiTexts.getString("Server.user"));
            this.usernametext = internalpane.addTextField("", mainPane.createGridLayoutData(4, 2, true, false, 1, 1));
            internalpane.addTextLabel(WsNavigatorUiTexts.getString("Server.password"));
            this.passwdtext = internalpane.addTextField("", mainPane.createGridLayoutData(4, 2, true, false, 1, 1));
            this.passwdtext.setEchoChar('*');
            IGridLayoutPane buttoncontainer = mainPane.addGridLayoutPane(1, mainPane.createGridLayoutData(4, 2, false, false, 1, 2));
            IGridLayoutPane pane = buttoncontainer.addGridLayoutPane(1, buttoncontainer.createGridLayoutData(4, 2, true, false, 1, 2));
            pane.addTextLabel("");
            IGridLayoutPane buttonpane = buttoncontainer.addGridLayoutPane(3, buttoncontainer.createGridLayoutData(4, 2, true, false, 1, 2));
            this.okbutton = buttonpane.addPushButton("      Ok       ", mainPane.createGridLayoutData(3, 1, false, false, 1, 2));
            buttonpane.addTextLabel("  ", mainPane.createGridLayoutData(2, 1, false, false, 1, 2));
            Button cancelbutton = buttonpane.addPushButton("    Cancel    ", mainPane.createGridLayoutData(1, 2, false, false, 1, 2));
            this.okbutton.addSelectionListener((SelectionListener)this);
            cancelbutton.addSelectionListener((SelectionListener)this);
            this.okbutton.traverse(4);
            return mainPane.getComposite();
        }

        public void run() {
            this.open();
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.pass;
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.okbutton) {
                this.user = this.usernametext.getText();
                this.pass = this.passwdtext.getText();
                this.okpressed = true;
            }
            this.close();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public boolean getOKPressed() {
            return this.okpressed;
        }
    }
}

