/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.properties;

import com.sap.ide.ws.navigator.properties.LabelProvider;
import com.sap.ide.ws.navigator.text.WsNavigatorUiTexts;
import com.sap.ide.ws.navigator.tree.INavigatorTreeNode;
import com.sap.ide.ws.navigator.tree.Server;
import com.sap.ide.ws.navigator.tree.Service;
import com.sap.ide.ws.navigator.tree.ServiceWSDL;
import com.sap.ide.ws.navigator.tree.WsNavigatorRoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class NavigatorRootEntry
implements IPropertySheetEntry {
    private Object[] values = new Object[0];
    protected Map sources = new HashMap(0);
    private Object editValue;
    private NavigatorRootEntry parent;
    private IPropertySourceProvider propertySourceProvider;
    private IPropertyDescriptor descriptor;
    private CellEditor editor;
    private String errorText;
    protected NavigatorRootEntry[] childEntries = null;
    private ListenerList listeners = new ListenerList();
    private INavigatorTreeNode node = null;
    private int nodedepth;
    private Composite c = null;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySource;

    public NavigatorRootEntry(INavigatorTreeNode ntn, int depth, Composite c) {
        this.node = ntn;
        this.nodedepth = depth;
        this.c = c;
    }

    public void addPropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.listeners.add((Object)listener);
    }

    public void applyEditorValue() {
    }

    protected List getPropertyDescriptorList() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        if (!(this.node instanceof WsNavigatorRoot)) {
            if (this.node instanceof Server) {
                if (this.nodedepth == 0) {
                    PropertyDescriptor pd = new PropertyDescriptor((Object)this.node, WsNavigatorUiTexts.getString("NavigatorRootEntry.server.information"));
                    descriptors.add(pd);
                } else if (this.nodedepth == 1) {
                    Server s = (Server)this.node;
                    PropertyDescriptor pd = new PropertyDescriptor((Object)this.node, WsNavigatorUiTexts.getString("NavigatorRootEntry.wsil.location"));
                    pd.setLabelProvider((ILabelProvider)new LabelProvider(s.getWSIL()));
                    descriptors.add(pd);
                }
            } else if (this.node instanceof Service) {
                if (this.nodedepth == 0) {
                    PropertyDescriptor pd = new PropertyDescriptor((Object)this.node, WsNavigatorUiTexts.getString("NavigatorRootEntry.webservice.information"));
                    descriptors.add(pd);
                } else if (this.nodedepth == 1) {
                    PropertyDescriptor pd = new PropertyDescriptor((Object)this.node, WsNavigatorUiTexts.getString("NavigatorRootEntry.webservice.type"));
                    pd.setLabelProvider((ILabelProvider)new LabelProvider("<WS type here>"));
                    CellEditor ce = pd.createPropertyEditor(this.c);
                    descriptors.add(pd);
                    pd = new PropertyDescriptor((Object)this.node, WsNavigatorUiTexts.getString("NavigatorRootEntry.wsdl.location"));
                    pd.setLabelProvider((ILabelProvider)new LabelProvider(((Service)this.node).getURL()));
                    descriptors.add(pd);
                }
            } else if (this.node instanceof ServiceWSDL) {
                if (this.nodedepth == 0) {
                    PropertyDescriptor pd = new PropertyDescriptor((Object)this.node, WsNavigatorUiTexts.getString("NavigatorRootEntry.webservice.information"));
                    descriptors.add(pd);
                } else if (this.nodedepth == 1) {
                    PropertyDescriptor pd = new PropertyDescriptor((Object)this.node, WsNavigatorUiTexts.getString("NavigatorRootEntry.wsdl.location"));
                    pd.setLabelProvider((ILabelProvider)new LabelProvider(((ServiceWSDL)this.node).getURL()));
                    descriptors.add(pd);
                }
            }
        }
        return descriptors;
    }

    private void createChildEntries() {
        List descriptors = this.getPropertyDescriptorList();
        this.childEntries = this.createChildEntries(descriptors.size());
        int i = 0;
        while (i < descriptors.size()) {
            IPropertyDescriptor d = (IPropertyDescriptor)descriptors.get(i);
            NavigatorRootEntry entry = this.createChildEntry();
            entry.setDescriptor(d);
            entry.setParent(this);
            entry.setPropertySourceProvider(this.propertySourceProvider);
            entry.refreshValues();
            this.childEntries[i] = entry;
            ++i;
        }
    }

    protected NavigatorRootEntry createChildEntry() {
        return new NavigatorRootEntry(this.node, this.nodedepth + 1, this.c);
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.childEntries != null) {
            int i = 0;
            while (i < this.childEntries.length) {
                this.childEntries[i].dispose();
                ++i;
            }
        }
    }

    public String getCategory() {
        return this.descriptor.getCategory();
    }

    public IPropertySheetEntry[] getChildEntries() {
        if (this.childEntries == null) {
            this.createChildEntries();
        }
        return this.childEntries;
    }

    public String getDescription() {
        return this.descriptor.getDescription();
    }

    private IPropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    public CellEditor getEditor(Composite parent) {
        return null;
    }

    private Object getEditValue() {
        return this.editValue;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String[] getFilters() {
        return this.descriptor.getFilterFlags();
    }

    public Object getHelpContextIds() {
        return this.descriptor.getHelpContextIds();
    }

    public Image getImage() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return null;
        }
        return provider.getImage(this.editValue);
    }

    protected NavigatorRootEntry getParent() {
        return this.parent;
    }

    private IPropertySource getPropertySource(Object object) {
        Object[] s = this.sources.keySet().toArray();
        if (this.sources.containsKey(object)) {
            return (IPropertySource)this.sources.get(object);
        }
        IPropertySource result = null;
        if (this.propertySourceProvider != null) {
            result = this.propertySourceProvider.getPropertySource(object);
        } else if (object instanceof IPropertySource) {
            result = (IPropertySource)object;
        } else if (object instanceof IAdaptable) {
            result = (IPropertySource)((IAdaptable)object).getAdapter(class$org$eclipse$ui$views$properties$IPropertySource == null ? (class$org$eclipse$ui$views$properties$IPropertySource = NavigatorRootEntry.class$("org.eclipse.ui.views.properties.IPropertySource")) : class$org$eclipse$ui$views$properties$IPropertySource);
        }
        this.sources.put(object, result);
        return result;
    }

    public String getValueAsString() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            String editToString = this.editValue.toString();
            if (editToString == null) {
                return "EDIT VALUE TO STRING NULL";
            }
            return editToString;
        }
        String providerText = provider.getText(this.editValue);
        if (providerText == null) {
            return provider.toString();
        }
        return providerText;
    }

    private Object[] getValues() {
        return this.values;
    }

    public boolean hasChildEntries() {
        if (this.childEntries != null && this.childEntries.length > 0) {
            return true;
        }
        return this.getPropertyDescriptorList().size() > 0;
    }

    private void refreshChildEntries() {
        if (this.childEntries == null) {
            return;
        }
        List descriptors = this.getPropertyDescriptorList();
        HashMap<Object, NavigatorRootEntry> entryCache = new HashMap<Object, NavigatorRootEntry>(this.childEntries.length * 2 + 1);
        int i = 0;
        while (i < this.childEntries.length) {
            entryCache.put(this.childEntries[i].getDescriptor().getId(), this.childEntries[i]);
            ++i;
        }
        ArrayList<NavigatorRootEntry> entriesToDispose = new ArrayList<NavigatorRootEntry>(Arrays.asList(this.childEntries));
        this.childEntries = this.createChildEntries(descriptors.size());
        boolean entriesChanged = descriptors.size() != entryCache.size();
        int i2 = 0;
        while (i2 < descriptors.size()) {
            IPropertyDescriptor d = (IPropertyDescriptor)descriptors.get(i2);
            NavigatorRootEntry entry = (NavigatorRootEntry)entryCache.get(d.getId());
            if (entry != null) {
                entry.setDescriptor(d);
                entriesToDispose.remove(entry);
            } else {
                entry = this.createChildEntry();
                entry.setDescriptor(d);
                entry.setParent(this);
                entry.setPropertySourceProvider(this.propertySourceProvider);
                entriesChanged = true;
            }
            entry.refreshValues();
            this.childEntries[i2] = entry;
            ++i2;
        }
        if (entriesChanged) {
            int i3 = 0;
            while (i3 < entriesToDispose.size()) {
                ((IPropertySheetEntry)entriesToDispose.get(i3)).dispose();
                ++i3;
            }
        }
    }

    protected NavigatorRootEntry[] createChildEntries(int size) {
        return new NavigatorRootEntry[size];
    }

    private void refreshFromRoot() {
        if (this.parent == null) {
            this.refreshChildEntries();
        } else {
            this.parent.refreshFromRoot();
        }
    }

    protected void refreshValues() {
        Object[] sources = this.parent.getValues();
        Object[] newValues = new Object[sources.length];
        int i = 0;
        while (i < sources.length) {
            IPropertySource source = this.parent.getPropertySource(sources[i]);
            newValues[i] = source.getPropertyValue(this.descriptor.getId());
            ++i;
        }
        this.setValues(newValues);
    }

    public void removePropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void resetPropertyValue() {
        if (this.parent == null) {
            return;
        }
        boolean change = false;
        Object[] objects = this.parent.getValues();
        int i = 0;
        while (i < objects.length) {
            IPropertySource source = this.getPropertySource(objects[i]);
            if (source.isPropertySet(this.descriptor.getId())) {
                change = true;
            }
            ++i;
        }
        if (change) {
            this.refreshValues();
        }
    }

    protected void setDescriptor(IPropertyDescriptor newDescriptor) {
        if (this.descriptor != newDescriptor && this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        this.descriptor = newDescriptor;
    }

    protected void setParent(NavigatorRootEntry p) {
        this.parent = p;
    }

    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        this.propertySourceProvider = provider;
    }

    private void setValue(Object newValue) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = newValue;
            ++i;
        }
        this.refreshFromRoot();
    }

    public void setValues(Object[] objects) {
        this.values = objects;
        this.sources = new HashMap(this.values.length * 2 + 1);
        if (this.values.length == 0) {
            this.editValue = null;
        } else {
            Object newValue = this.values[0];
            IPropertySource source = this.getPropertySource(newValue);
            if (source != null) {
                newValue = source.getEditableValue();
            }
            this.editValue = newValue;
        }
        this.refreshChildEntries();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

