/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.interfaces.implementation;

import com.sap.engine.services.webservices.jaxrpc.exceptions.TypeMappingException;
import com.sap.engine.services.webservices.wsil.WSILParser;
import com.sap.engine.services.webservices.wsil.descriptors.DescriptionType;
import com.sap.engine.services.webservices.wsil.descriptors.NameType;
import com.sap.engine.services.webservices.wsil.descriptors.ServiceType;
import com.sap.engine.services.webservices.wsil.descriptors.TypeOfAbstract;
import com.sap.engine.services.webservices.wsil.descriptors.sap.SapWS;
import com.sap.engine.services.webservices.wsil.descriptors.wsiluddi.ServiceDescription;
import com.sap.ide.ws.navigator.interfaces.ServiceObject;
import java.io.IOException;
import java.util.Vector;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.TransformerException;

public class ServiceObjectImpl
implements ServiceObject {
    private String name;
    private String description;
    private String wsdl;
    private String[] styles;
    private String homepage;
    private Vector uddiPublications = new Vector();

    public ServiceObjectImpl(ServiceType service, int index) throws TypeMappingException, TransformerException, IOException {
        this.setDescription(service.getAbstract());
        this.setName(service.getName(), index);
        DescriptionType[] wsDescriptions = service.getDescription();
        int i = 0;
        while (i < wsDescriptions.length) {
            SOAPElement soapEl;
            DescriptionType wsDescription = wsDescriptions[i];
            String namespace = wsDescription.getReferencedNamespace();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                this.wsdl = wsDescription.getLocation();
            } else if ("http://www.sap.com/ws/inspection/".equals(namespace)) {
                soapEl = wsDescription.get_any();
                SapWS sapWS = WSILParser.loadSapWS((SOAPElement)soapEl);
                this.styles = sapWS.getStyle();
                this.homepage = sapWS.getHomepage();
            } else if ("urn:uddi-org:api_v2".equals(namespace)) {
                soapEl = wsDescription.get_any();
                ServiceDescription uddiDesc = WSILParser.loadUDDI((SOAPElement)soapEl);
                this.uddiPublications.addElement(uddiDesc);
            }
            ++i;
        }
    }

    private void setName(NameType[] names, int index) {
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                NameType name = names[i];
                String lang = name.getLang();
                if (lang == null || "en".equalsIgnoreCase(lang)) {
                    this.name = name.getSimpleContent();
                }
                ++i;
            }
            if (this.name == null && names.length > 0) {
                this.name = names[0].getSimpleContent();
            }
        }
        if (this.name == null) {
            this.name = this.description != null ? this.description : "Service" + index;
        }
    }

    private void setDescription(TypeOfAbstract[] descriptions) {
        if (descriptions != null) {
            int i = 0;
            while (i < descriptions.length) {
                TypeOfAbstract description = descriptions[i];
                String lang = description.getLang();
                if (lang == null || "en".equalsIgnoreCase(lang)) {
                    this.description = description.getSimpleContent();
                }
                ++i;
            }
            if (this.description == null && descriptions.length > 0) {
                this.description = descriptions[0].getSimpleContent();
            }
        }
        if (this.description == null) {
            this.description = "";
        }
    }

    public String[] getStyles() {
        if (this.styles == null) {
            this.styles = new String[0];
        }
        return this.styles;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWSDL(String style) {
        if (style == null || style.length() == 0) {
            return this.wsdl;
        }
        if (this.wsdl.indexOf("?") != -1) {
            return this.wsdl + "&style=" + style;
        }
        return this.wsdl + "?style=" + style;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public Vector getUDDIPublications() {
        return this.uddiPublications;
    }
}

