/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator.interfaces.implementation;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.services.webservices.jaxrpc.exceptions.InvalidResponseCodeException;
import com.sap.engine.services.webservices.tools.ExceptionManager;
import com.sap.engine.services.webservices.tools.WSDLDownloadResolver;
import com.sap.engine.services.webservices.wsil.WSILParser;
import com.sap.engine.services.webservices.wsil.descriptors.Inspection;
import com.sap.engine.services.webservices.wsil.descriptors.ServiceType;
import com.sap.engine.services.webservices.wsil.descriptors.wsiluddi.ServiceDescription;
import com.sap.ide.ws.navigator.interfaces.ServiceContainer;
import com.sap.ide.ws.navigator.interfaces.ServiceObject;
import com.sap.ide.ws.navigator.interfaces.WSILException;
import com.sap.ide.ws.navigator.interfaces.WSILSecurityException;
import com.sap.ide.ws.navigator.interfaces.implementation.ServiceObjectImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Vector;
import org.xml.sax.InputSource;

public class ServiceContainerImpl
implements ServiceContainer {
    public ServiceObject[] getServices(String wsil) throws IOException, WSILException, WSILSecurityException {
        return this.getServices(wsil, null, null);
    }

    public String getURL(ServiceObject so, String style, String url) {
        ServiceObjectImpl service = (ServiceObjectImpl)so;
        StringBuffer buffer = new StringBuffer();
        buffer.append(url);
        if (!url.endsWith("/")) {
            buffer.append('/');
        }
        buffer.append("wsnavigator/jsps/index.jsp?ide=");
        String wsdl = service.getWSDL(style);
        buffer.append("&wsdl=" + URLEncoder.encode(wsdl));
        buffer.append("&name=" + URLEncoder.encode(service.getName()));
        buffer.append("&description=");
        Vector uddiPublications = service.getUDDIPublications();
        int i = 0;
        while (i < uddiPublications.size()) {
            ServiceDescription serviceDesc = (ServiceDescription)uddiPublications.elementAt(i);
            StringBuffer uddiInfo = new StringBuffer(serviceDesc.getServiceKey());
            if (serviceDesc.getLocation() != null) {
                uddiInfo.append('|');
                uddiInfo.append(serviceDesc.getLocation());
            }
            buffer.append("&uddi=" + URLEncoder.encode(uddiInfo.toString()));
            ++i;
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceObject[] getServices(String wsil, String user, String passwd) throws IOException, WSILException, WSILSecurityException {
        Object[] objectArray;
        URL url = new URL(wsil);
        WSDLDownloadResolver resolver = new WSDLDownloadResolver();
        if (user != null && passwd != null) {
            resolver.setUsername(user);
            resolver.setPassword(passwd);
        }
        String proxyHost = System.getProperty("http.proxyHost", System.getProperty("proxyHost"));
        String proxyPort = System.getProperty("http.proxyPort", System.getProperty("proxyPort"));
        String excludeList = System.getProperty("http.nonProxyHosts", System.getProperty("nonProxyHosts"));
        if (proxyHost != null && proxyPort != null && proxyHost.trim().length() > 0 && proxyPort.trim().length() > 0) {
            HTTPProxy proxy = new HTTPProxy();
            proxy.setProxyHost(proxyHost);
            int proxyPortInt = Integer.parseInt(proxyPort);
            proxy.setProxyPort(proxyPortInt);
            proxy.setExcludeList(excludeList);
            String host = null;
            if (wsil.startsWith("http://") || wsil.startsWith("https://")) {
                int index = wsil.startsWith("http://") ? 7 : 8;
                int end = wsil.indexOf("/", index);
                String hostPort = end == -1 ? wsil.substring(index) : wsil.substring(index, end);
                host = hostPort.indexOf(":") != -1 ? hostPort.substring(0, hostPort.indexOf(":")) : hostPort;
            }
            if (host != null && proxy.useProxyForAddress(host)) {
                resolver.setProxyHost(proxyHost);
                resolver.setProxyPort(proxyPortInt);
            }
        }
        InputStream in = null;
        try {
            try {
                InputSource source = resolver.resolveEntity(null, wsil);
                in = source.getByteStream();
                Inspection inspection = WSILParser.loadInspection((InputStream)in);
                Inspection.Sequence1[] serviceGroup = inspection.getSequenceGroup1();
                Vector<ServiceObjectImpl> servicesVector = new Vector<ServiceObjectImpl>();
                int index = 0;
                int i = 0;
                while (true) {
                    if (i >= serviceGroup.length) {
                        Object[] serviceObjects = new ServiceObject[servicesVector.size()];
                        servicesVector.copyInto(serviceObjects);
                        objectArray = serviceObjects;
                        Object var19_24 = null;
                        if (in == null) return objectArray;
                        break;
                    }
                    Inspection.Sequence1.Choice1 choice = serviceGroup[i].getChoiceGroup1();
                    ServiceType service = choice.getService();
                    if (service != null) {
                        servicesVector.addElement(new ServiceObjectImpl(service, ++index));
                    }
                    ++i;
                }
            }
            catch (Throwable thr) {
                Throwable cause = ExceptionManager.getOriginalError((Throwable)thr);
                if (!(cause instanceof InvalidResponseCodeException)) throw new WSILException(thr);
                InvalidResponseCodeException invalidResponse = (InvalidResponseCodeException)cause;
                if (invalidResponse.getResponseCode() != 401) throw new WSILException(thr);
                throw new WSILSecurityException(thr);
            }
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return objectArray;
    }
}

