/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.navigator;

import com.tssap.util.ui.image.SapImageRegistry;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NavigatorPlugin
extends AbstractUIPlugin {
    public static final String REFRESH_ICON = "refresh_nav.gif";
    public static final String WSDL_ICON = "wsdl.gif";
    public static final String WS_ICON = "WebService.gif";
    public static final String ROOT_ICON = "root.gif";
    public static final String ADD_SERVER_ICON = "add_server.gif";
    public static final String REMOVE_SERVER_ICON = "remove_server.gif";
    public static final String STANDALONE_PROXY_ICON = "StandaloneProxy.gif";
    public static final String DEPLOYABLE_PROXY_ICON = "DeployableProxy.gif";
    public static final String SERVER_ICON = "Server.gif";
    public static final String SEARCH_ICON = "search.gif";
    private static final String WS_ICON_FOLDER_PATH = "resources/icons/";
    private static NavigatorPlugin plugin;
    private ResourceBundle resourceBundle;
    private SapImageRegistry imageRegistry;

    public NavigatorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.sap.ide.ws.navigator.NavigatorPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static NavigatorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = NavigatorPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private ImageDescriptor getImageResource(String resourceName) {
        try {
            URL url = new URL(NavigatorPlugin.getDefault().getDescriptor().getInstallURL(), resourceName);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return ImageDescriptor.getMissingImageDescriptor();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = (SapImageRegistry)this.createImageRegistry();
            this.initializeImageRegistry();
        }
        return this.imageRegistry;
    }

    protected void initializeImageRegistry() {
        try {
            this.imageRegistry.put(REFRESH_ICON, this.getImageResource("resources/icons/refresh_nav.gif"));
            this.imageRegistry.put(WSDL_ICON, this.getImageResource("resources/icons/wsdl.gif"));
            this.imageRegistry.put(WS_ICON, this.getImageResource("resources/icons/WebService.gif"));
            this.imageRegistry.put(ROOT_ICON, this.getImageResource("resources/icons/root.gif"));
            this.imageRegistry.put(ADD_SERVER_ICON, this.getImageResource("resources/icons/add_server.gif"));
            this.imageRegistry.put(REMOVE_SERVER_ICON, this.getImageResource("resources/icons/remove_server.gif"));
            this.imageRegistry.put(STANDALONE_PROXY_ICON, this.getImageResource("resources/icons/StandaloneProxy.gif"));
            this.imageRegistry.put(DEPLOYABLE_PROXY_ICON, this.getImageResource("resources/icons/DeployableProxy.gif"));
            this.imageRegistry.put(SERVER_ICON, this.getImageResource("resources/icons/Server.gif"));
            this.imageRegistry.put(SEARCH_ICON, this.getImageResource("resources/icons/search.gif"));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    protected ImageRegistry createImageRegistry() {
        return new SapImageRegistry();
    }

    public static Image getImage(String imageName) {
        return NavigatorPlugin.getDefault().getImageRegistry().get(imageName);
    }
}

