/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IStructureList;
import com.sap.tc.col.client.generic.api.IValueSet;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestValueSet
extends Test {
    IServiceFacade sf;
    IServiceModule flightsServiceModule;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.flightsServiceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.flightsServiceModule != null, "CL_SCOOL_SFLIGHT ServiceModule could not be created!");
    }

    public void testSimpleValueSet() {
        IKey testKey = TestUtils.getFlightTestKey(this.sf, this.flightsServiceModule);
        IKeyList flightKeyList = this.flightsServiceModule.createKeyList("SCOL_FLIGHTS_KEY");
        flightKeyList.add(testKey);
        IAspect flights = this.flightsServiceModule.getAspect("SCOL_FLIGHTS_DETAIL", flightKeyList);
        this.sf.flush();
        IValueSet valueSet = flights.createValueSet("PRICE");
        IStructure inParams = valueSet.getInputParameterStructure();
        IAspectRow aspectRow = flights.getAspectRow(0);
        aspectRow.setAttributeValue("CITYFROM", (Object)"XXXX");
        this.verify(aspectRow.isDirty(), "AspectRow should be dirty after setter!");
        int i = 0;
        while (i < inParams.size()) {
            inParams.setAttributeValue(i, aspectRow.getAttributeValue(i));
            ++i;
        }
        valueSet.execute();
        IStructureList values = valueSet.getOutValuesList();
        this.verify(values != null && values.size() == 3, "ValueSet is null or size is not 3!");
        this.verify(aspectRow.isDirty(), "AspectRow should be dirty after ValueSet execute!");
        flights.refresh();
        IStructure second = values.getStructure(1);
        this.verify("normal".equals(second.getAttributeAsString("TEXT")), "Attribute TEXT should be 'normal' but is '" + second.getAttributeAsString("TEXT") + "'");
        valueSet.execute();
        IStructure newSecond = values.getStructure(1);
        this.verify(values == valueSet.getOutValuesList(), "Result StructureList is not reference stable after new execute!");
        this.verify(second != newSecond, "Structures are reference stable after new execute!");
        int i2 = 0;
        while (i2 < second.getDescriptor().size()) {
            this.verify(second.getAttributeAsString(i2).equals(newSecond.getAttributeAsString(i2)), "results different: " + second.getAttributeAsString(i2) + " / " + newSecond.getAttributeAsString(i2));
            ++i2;
        }
    }

    public void testHollowValueSet() {
        IKey testKey = TestUtils.getFlightTestKey(this.sf, this.flightsServiceModule);
        IKeyList flightKeyList = this.flightsServiceModule.createKeyList("SCOL_FLIGHTS_KEY");
        flightKeyList.add(testKey);
        IAspect flights = this.flightsServiceModule.getAspect("SCOL_FLIGHTS_DETAIL", flightKeyList);
        IValueSet valueSet = flights.createValueSet("PRICE");
        IStructure inParams = valueSet.getInputParameterStructure();
        IAspectRow aspectRow = flights.getAspectRow(0);
        int i = 0;
        while (i < inParams.size()) {
            inParams.setAttributeValue(i, aspectRow.getAttributeValue(i));
            ++i;
        }
        valueSet.execute();
        valueSet.execute();
        IStructureList values = valueSet.getOutValuesList();
        this.verify(values != null && values.size() == 3, "ValueSet is null or size is not 3!");
        IStructure second = values.getStructure(1);
        this.verify("normal".equals(second.getAttributeAsString("TEXT")), "Attribute TEXT should be 'normal' but is '" + second.getAttributeAsString("TEXT") + "'");
    }

    public void testValueSetCARRID() {
        IKey testKey = TestUtils.getFlightTestKey(this.sf, this.flightsServiceModule);
        IKeyList flightKeyList = this.flightsServiceModule.createKeyList("SCOL_FLIGHTS_KEY");
        flightKeyList.add(testKey);
        IAspect flights = this.flightsServiceModule.getAspect("SCOL_FLIGHTS_DETAIL", flightKeyList);
        IValueSet valueSet = flights.createValueSet("CARRID");
        IStructure inParams = valueSet.getInputParameterStructure();
        inParams.setAttributeValue("CARRID", (Object)"A*");
        valueSet.execute();
        IStructureList values = valueSet.getOutValuesList();
        TestUtils.dump(values);
        this.verify(values != null && values.size() == 5, "ValueSet is null or size is not 5!");
        int i = 0;
        while (i < values.size()) {
            this.verify(values.getStructure(i).getAttributeAsString("FIELDKEY").startsWith("A"), "FieldKey of CARRID should start with 'A'");
            ++i;
        }
    }
}

