/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.cds.ConnectionDataAppServer;
import com.sap.tc.col.cds.ConnectionDataServiceFactory;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IStructureList;
import com.sap.tc.col.client.generic.api.ServiceFacadeFactory;
import com.sap.tc.col.client.generic.core.GCPRuntimeException;
import com.sap.tc.col.client.generic.core.ServiceFacade;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;
import java.sql.Date;
import java.util.Iterator;

class TestUtils {
    private static boolean initLogging = false;
    static final String[] LOGON_B3Q = new String[]{"000", "cooluser", "dwim", "DE", "ls4003", "13"};
    static final String[] LOGON_B3P = new String[]{"000", "cooluser", "dwim", "DE", "pwdf1053", "43"};
    static final String[] LOGON_B3U = new String[]{"000", "cooluser", "dwim", "DE", "pwdf0589", "29"};
    static final String[] LOGON_B20 = new String[]{"000", "cooluser", "dwim", "DE", "ld0020", "21"};
    static final String SM_FLIGHTS = "CL_SCOOL_SFLIGHT";
    static final String SM_REF_IMPL = "COL_REF_IMPLEMENTATION";
    static final String QUERY_REF_1 = "REF_QUERY_1";
    static final String QUERY_FLIGHTS = "FLIGHT_LIST";
    static final String RELATION_SIB = "REF_RELATION_SIB";
    static final String REF_RELATION = "REF_RELATION_1";
    static final String RELATION_BOOKINGS = "BOOKINGS";
    static final String ASPECT_SIBLINGS_KEY = "SCOL_REF_SIB_KEY";
    static final String ASPECT_REF_KEY = "SCOL_REF_KEY";
    static final String ASPECT_REF_DETAIL = "SCOL_REF_DETAIL";
    static final String ASPECT_SIBLINGS_1 = "SCOL_REF_SIB_DETAIL_1";
    static final String ASPECT_SIBLINGS_2 = "SCOL_REF_SIB_DETAIL_2";
    static final String ASPECT_REF_RELATION = "SCOL_REF_RELATION_DETAIL";
    static final String FLIGHT_KEY_NAME = "SCOL_FLIGHTS_KEY";
    private static String[] defaultParameters = new String[]{"test.debug=false", "test.system=B20", "test.useTCP=false"};

    TestUtils() {
    }

    static void dump(Object aspect) {
        System.out.println(aspect);
    }

    static void dumpN(IAspect aspect, int counter) {
        Iterator it = aspect.iterator();
        while (it.hasNext()) {
            if (counter-- <= 0) break;
            IAspectRow row = (IAspectRow)it.next();
            TestUtils.dump(row);
        }
    }

    static void dump(IKeyList keyList) {
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            TestUtils.dump(it.next());
        }
    }

    static void dump(IStructureList structureList) {
        Iterator it = structureList.iterator();
        while (it.hasNext()) {
            TestUtils.dump(it.next());
        }
    }

    static void dumpMessageList(String header, IMessageList messageList) {
        System.out.println(header);
        System.out.println(messageList);
    }

    static void initLogging(IServiceFacade sf, String debug) {
        if (!initLogging) {
            initLogging = true;
            if ("true".equalsIgnoreCase(debug)) {
                sf.initLocalLogging();
            }
        }
    }

    static boolean isInStringArray(String[] stringArray, String testString) {
        int i = 0;
        while (i < stringArray.length) {
            if (stringArray[i].equals(testString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean isErrorMessages(IMessageList messages) {
        int i = 0;
        while (i < messages.size()) {
            IMessage message = messages.getMessage(i);
            if (message.isError() || message.isFailed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static int noOfFailedMessages(IMessageList messages) {
        int noOfFailed = 0;
        int i = 0;
        while (i < messages.size()) {
            IMessage message = messages.getMessage(i);
            if (message.isError() || message.isFailed()) {
                ++noOfFailed;
            }
            ++i;
        }
        return noOfFailed;
    }

    static void resetDBRefServiceModule(IServiceFacade sf) {
        long t1 = System.currentTimeMillis();
        IAspect refAspect = sf.getServiceModule(SM_REF_IMPL).createAspect(ASPECT_REF_DETAIL);
        IAction actionResetDB = refAspect.createAction("COL_REF_DATA_DB_RESET");
        actionResetDB.execute();
        sf.flush();
        long t2 = System.currentTimeMillis();
        System.out.println("reset DB (" + (t2 - t1) + "ms)");
    }

    static IKey getFlightTestKey(IServiceFacade sf, IServiceModule serviceModule) {
        int month;
        IQuery query = serviceModule.createQuery(QUERY_FLIGHTS);
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("CITYFROM", (Object)"F*");
        parms.setAttributeValue("CITYTO", (Object)"*");
        query.execute();
        Date min = new Date(System.currentTimeMillis() + 172800000L);
        String year = null;
        if (min.getMonth() == 11) {
            year = "" + (min.getYear() + 1901);
            month = 1;
        } else {
            year = "" + (min.getYear() + 1900);
            month = min.getMonth() + 2;
        }
        if (query.getResultAspect().size() > 0) {
            IAspect result = query.getResultAspect();
            int i = 0;
            while (i < result.size()) {
                String monthAsString;
                int aktMonth;
                IAspectRow row = result.getAspectRow(i);
                String dateString = row.getAttributeAsString("FLDATE");
                if (dateString.startsWith(year) && (aktMonth = new Integer(monthAsString = dateString.substring(5, 7)).intValue()) >= month) {
                    return row.getKey();
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    static IServiceFacade createServiceFacade(String system) {
        String[] LOGON = TestUtils.getLogon(system);
        ConnectionDataAppServer cds = (ConnectionDataAppServer)ConnectionDataServiceFactory.getConnectionDataService().getConnectionData("JCO", "0");
        cds.setClient(LOGON[0]);
        cds.setUser(LOGON[1]);
        cds.setPassword(LOGON[2]);
        cds.setLanguage(LOGON[3]);
        cds.setAppServer(LOGON[4]);
        cds.setSystemNumber(LOGON[5]);
        cds.setDebug(false);
        cds.setSync(false);
        return ServiceFacadeFactory.createServiceFacade((ConnectionData)cds);
    }

    static void adjustTestAttributes(IJverTestAttributes attributes, String[] additionalParameters) {
        if (additionalParameters != null && additionalParameters.length > 0) {
            String[] allParameters = new String[defaultParameters.length + additionalParameters.length];
            System.arraycopy(defaultParameters, 0, allParameters, 0, defaultParameters.length);
            System.arraycopy(additionalParameters, 0, allParameters, defaultParameters.length, additionalParameters.length);
            attributes.defineParameters(allParameters);
        } else {
            attributes.defineParameters(defaultParameters);
        }
    }

    static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes, null);
    }

    static IServiceFacade prepare(Test test) {
        IServiceFacade sf = TestUtils.createServiceFacade(test.getParameter("test.system"));
        if ("true".equals(test.getParameter("test.useTCP"))) {
            try {
                ((ServiceFacade)sf).defineServiceModuleImpl(SM_REF_IMPL, Class.forName("com.sap.tc.col.client.typed.test.refimpl.Col_Ref_Implementation"));
                ((ServiceFacade)sf).defineServiceModuleImpl(SM_FLIGHTS, Class.forName("com.sap.tc.col.client.typed.test.flight.Cl_Scool_Sflight"));
            }
            catch (ClassNotFoundException e) {
                throw new GCPRuntimeException(e);
            }
        }
        TestUtils.initLogging(sf, test.getParameter("test.debug"));
        return sf;
    }

    static String[] getLogon(String system) {
        if ("B20".equalsIgnoreCase(system)) {
            return LOGON_B20;
        }
        if ("B3U".equalsIgnoreCase(system)) {
            return LOGON_B3U;
        }
        if ("B3P".equalsIgnoreCase(system)) {
            return LOGON_B3P;
        }
        if ("B3Q".equalsIgnoreCase(system)) {
            return LOGON_B3Q;
        }
        throw new IllegalArgumentException("System '" + system + "' is not known");
    }
}

