/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;
import java.sql.Date;

public class TestStandardChanges1
extends Test {
    IServiceFacade sf;
    IServiceModule serviceModule;
    IAspect sourceAspect;
    IAspect aspectToChange;
    private static final String[] KEY_FIELDS = new String[]{"0000000002", "0000000001", "0000000001"};
    private int initialNoOfRows;
    static boolean resetDB = true;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        if (resetDB) {
            TestUtils.resetDBRefServiceModule(this.sf);
            resetDB = false;
        }
        this.serviceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION");
        IKeyList keyList = this.serviceModule.createKeyList("SCOL_REF_KEY");
        keyList.add(this.serviceModule.createKey("SCOL_REF_KEY", KEY_FIELDS));
        this.sourceAspect = this.serviceModule.getAspect("SCOL_REF_KEY", keyList);
        if (this.sourceAspect != null) {
            this.aspectToChange = this.sourceAspect.getRelatedAspect("REF_RELATION_1");
            this.initialNoOfRows = this.aspectToChange.size();
            TestUtils.dump(this.aspectToChange);
        }
        this.sf.getAllMessages().clear();
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.serviceModule != null, "ServiceModule creation failed");
        this.verify(this.sourceAspect != null, "Source Aspect for Relation is null");
        this.verify(this.aspectToChange != null, "Aspect to change is null");
        this.verify(this.initialNoOfRows == 10, "Aspect to change has " + this.initialNoOfRows + " rows expected 10");
    }

    public void testSimpleUpdate() {
        String changedData5 = "1111111111";
        String changedData3 = "99";
        IAspectRow rowToChange = this.aspectToChange.getAspectRow(this.initialNoOfRows - 1);
        String[] changedFields = new String[]{changedData5, changedData3};
        String[] originalFields = new String[2];
        IKey keyOfRowToChange = this.changeAspectRow(rowToChange, changedFields, originalFields);
        this.verify(rowToChange.getAttributeAsString("REL_DATA5").equals(changedData5), "Changed field REL_DATA5 is '" + rowToChange.getAttributeAsString("REL_DATA5") + "' expected: " + changedData5);
        this.verify(rowToChange.getAttributeAsString("REL_DATA3").equals(changedData3), "Changed field REL_DATA3 is '" + rowToChange.getAttributeAsString("REL_DATA3") + "' expected: " + changedData3);
        this.aspectToChange.sendChanges();
        rowToChange = this.aspectToChange.getAspectRow(keyOfRowToChange);
        this.verify(rowToChange.getAttributeAsString("REL_DATA5").equals(changedData5), "Changed field REL_DATA5 is '" + rowToChange.getAttributeAsString("REL_DATA5") + "' expected: " + changedData5);
        this.verify(rowToChange.getAttributeAsString("REL_DATA3").equals(changedData3), "Changed field REL_DATA3 is '" + rowToChange.getAttributeAsString("REL_DATA3") + "' expected: " + changedData3);
        rowToChange = this.aspectToChange.getAspectRow(keyOfRowToChange, LockStrategy.EXCLUSIVE);
        this.verify(rowToChange.getAttributeAsString("REL_DATA5").equals(changedData5), "Changed field REL_DATA5 is '" + rowToChange.getAttributeAsString("REL_DATA5") + "' expected: " + changedData5);
        this.verify(rowToChange.getAttributeAsString("REL_DATA3").equals(changedData3), "Changed field REL_DATA3 is '" + rowToChange.getAttributeAsString("REL_DATA3") + "' expected: " + changedData3);
        keyOfRowToChange = this.changeAspectRow(rowToChange, originalFields, changedFields);
        this.sf.flush();
    }

    public void testSimpleInsert() {
        IAspectRow rowToInsert = this.aspectToChange.createAspectRow();
        IKey keyToInsert = rowToInsert.getKey();
        rowToInsert.setAttributeValue("KEY1", (Object)"0000000002");
        rowToInsert.setAttributeValue("KEY2", (Object)"0000000001");
        rowToInsert.setAttributeValue("KEY3", (Object)"0000000001");
        rowToInsert.setAttributeValue("REL_KEY1", (Object)"0000000011");
        rowToInsert.setAttributeValue("REL_DATA1", (Object)Boolean.TRUE);
        rowToInsert.setAttributeValue("REL_DATA2", (Object)new Date(2003, 2, 2));
        rowToInsert.setAttributeValue("REL_DATA3", (Object)"11");
        rowToInsert.setAttributeValue("REL_DATA4", (Object)new Integer(11));
        rowToInsert.setAttributeValue("REL_DATA5", (Object)"0000000011");
        this.verify(this.aspectToChange.size() == this.initialNoOfRows + 1, "Size of changed Aspect is not correct size:" + this.aspectToChange.size() + " expected:" + (this.initialNoOfRows + 1));
        this.verify(keyToInsert.isLocalKey(), "Key of inserted Row is no local Key:" + keyToInsert);
        this.aspectToChange.sendChanges();
        this.verify(this.aspectToChange.size() == this.initialNoOfRows + 1, "Size of changed Aspect is not correct size:" + this.aspectToChange.size() + " expected:" + (this.initialNoOfRows + 1));
        IMessageList messages = this.aspectToChange.getMessages();
        TestUtils.dumpMessageList("Messages after insert", messages);
        this.verify(!TestUtils.isErrorMessages(messages), "Error messages exist: " + messages);
        this.sf.save();
        this.verify(!keyToInsert.isLocalKey(), "Key of inserted Row after rounddrip is no complete Key:" + keyToInsert);
        IAspectRow insertedRow = this.aspectToChange.getAspectRow(keyToInsert);
        this.verify(rowToInsert == insertedRow, "Inconsistence between Key and inserted Row " + keyToInsert);
        IAspect keyAspect = this.aspectToChange.getKeyAspect();
        this.aspectToChange = keyAspect.getAspect("SCOL_REF_RELATION_DETAIL");
        this.verify(this.aspectToChange.size() == this.initialNoOfRows + 1, "Size of changed Aspect after insert is not correct size:" + this.aspectToChange.size() + " expected:" + (this.initialNoOfRows + 1));
        this.aspectToChange.remove(rowToInsert);
        this.sf.flush();
    }

    public void testFailedInsert() {
        IAspectRow rowToInsert = this.aspectToChange.createAspectRow();
        IKey keyToInsert = rowToInsert.getKey();
        rowToInsert.setAttributeValue("KEY1", (Object)"0000000002");
        rowToInsert.setAttributeValue("KEY2", (Object)"0000000001");
        rowToInsert.setAttributeValue("KEY3", (Object)"0000000001");
        rowToInsert.setAttributeValue("REL_KEY1", (Object)"0000000011");
        rowToInsert.setAttributeValue("REL_DATA1", (Object)Boolean.TRUE);
        rowToInsert.setAttributeValue("REL_DATA2", (Object)new Date(2003, 2, 2));
        rowToInsert.setAttributeValue("REL_DATA3", (Object)"11");
        rowToInsert.setAttributeValue("REL_DATA4", (Object)new Integer(11));
        rowToInsert.setAttributeValue("REL_DATA5", (Object)"0000000011");
        this.sf.flush();
        IMessageList messages = this.aspectToChange.getMessages();
        this.verify(messages.size() == 1, "number of messages should be 1 but is:" + messages.size());
        IMessage message = messages.getMessage(0);
        this.verify(message.isError(), "Message is no ERROR message!");
        this.verify(message.isAspectRowMessage(), "Message doesn't originate to a specific AspectRow");
    }

    private IKey changeAspectRow(IAspectRow rowToChange, String[] changedFields, String[] originalFields) {
        IKey keyOfRowToChange = rowToChange.getKey();
        originalFields[0] = (String)rowToChange.getAttributeValue("REL_DATA5");
        rowToChange.setAttributeValue("REL_DATA5", (Object)changedFields[0]);
        originalFields[1] = (String)rowToChange.getAttributeValue("REL_DATA3");
        rowToChange.setAttributeValue("REL_DATA3", (Object)changedFields[1]);
        return keyOfRowToChange;
    }
}

