/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestServiceFacade
extends Test {
    IServiceFacade sf;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testServiceFacadeSimple() {
        this.verify(this.sf != null, "ServiceFacade creation failed");
        String[] smModules = this.sf.getServiceModuleNames();
        this.verify(smModules.length > 0, "No ServiceModule names found");
        this.verify(TestUtils.isInStringArray(smModules, "CL_SCOOL_SFLIGHT"), "ServiceModule name for Flight sample not found");
        this.verify(TestUtils.isInStringArray(smModules, "COL_REF_IMPLEMENTATION"), "ServiceModule name for Reference Implementation not found");
    }

    public void testGetServiceModuleConfigurationNames() {
        String[] smConfigs = this.sf.getServiceModuleConfigurationNames("CL_SCOOL_SFLIGHT");
        this.verify(smConfigs != null, "Array with ServiceModule configuration names is null!");
    }

    public void testServiceModuleDescriptor() {
        IServiceModuleDescriptor smDescr = this.sf.getServiceModuleDescriptor("CL_SCOOL_SFLIGHT", "");
        this.verify(smDescr != null, "ServiceModuleDescriptor creation failed");
    }

    public void testCloseConnection() {
        this.sf.closeConnection();
        try {
            this.sf.isDirty();
            this.flop("After closeConnection() method should lead to an IllegalStateException");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalStateException, "After closeConnection() method should lead to an IllegalStateException");
        }
    }

    public void testCleanup() {
        IServiceModule serviceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT", "");
        IKeyList keyList = serviceModule.createKeyList("SCOL_FLIGHTS_KEY");
        keyList.add(TestUtils.getFlightTestKey(this.sf, serviceModule));
        IAspect aspect = serviceModule.getAspect("SCOL_FLIGHTS_KEY", keyList);
        this.verify(aspect != null && aspect.size() > 0, "Precondition for test not fulfilled");
        IAspect aspectToChange = aspect.getRelatedAspect("BOOKINGS");
        this.verify(aspectToChange != null && aspectToChange.size() > 0, "Precondition for test not fulfilled");
        String testSmoker = aspectToChange.getAspectRow(0).getAttributeAsString("SMOKER");
        if (testSmoker.equals("")) {
            aspectToChange.getAspectRow(0).setAttributeValue("SMOKER", (Object)"X");
        } else {
            aspectToChange.getAspectRow(0).setAttributeValue("SMOKER", (Object)"");
        }
        this.sf.flush();
        IMessageList messages = this.sf.getAllMessages();
        this.verify(!TestUtils.isErrorMessages(messages), "Aspect Changes are flushed with errors!");
        this.sf.cleanup();
        IAspectRow changedRow = aspectToChange.getAspectRow(0);
        aspectToChange.refresh();
        this.verify(testSmoker.equals(changedRow.getAttributeAsString("SMOKER")), "Attribute is changed, although cleanup was called");
    }

    public void testErrorHandling() {
        IServiceModule serviceModule;
        IServiceModuleDescriptor serviceModuleDesc;
        try {
            serviceModuleDesc = this.sf.getServiceModuleDescriptor("XXX");
            this.verify(false, "Expected Exception IllegalArgumentException wasn't thrown");
        }
        catch (Throwable e) {
            System.out.println("Exception: " + e);
            this.verify(e instanceof RuntimeException, "Caught Exception is not of type IllegalArgumentException but:" + e.getClass().getName());
        }
        try {
            serviceModule = this.sf.getServiceModule("XXX");
            this.verify(false, "Expected Exception IllegalArgumentException wasn't thrown");
        }
        catch (Throwable e) {
            System.out.println("Exception: " + e);
            this.verify(e instanceof RuntimeException, "Caught Exception is not of type IllegalArgumentException but:" + e.getClass().getName());
        }
        try {
            serviceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT", "NEW");
            this.verify(false, "Expected Exception IllegalArgumentException wasn't thrown");
        }
        catch (Throwable e) {
            System.out.println("Exception: " + e);
            this.verify(e instanceof RuntimeException, "Caught Exception is not of type IllegalArgumentException but:" + e.getClass().getName());
        }
        try {
            serviceModuleDesc = this.sf.getServiceModuleDescriptor("CL_SCOOL_SFLIGHT", "XXX");
            this.verify(false, "Expected Exception IllegalArgumentException wasn't thrown");
        }
        catch (Throwable e) {
            System.out.println("Exception: " + e);
            this.verify(e instanceof RuntimeException, "Caught Exception is not of type IllegalArgumentException but:" + e.getClass().getName());
        }
        try {
            serviceModuleDesc = this.sf.getServiceModuleDescriptor("CL_SCOOL_SFLIGHT", "XXX");
            this.verify(false, "Expected Exception IllegalArgumentException wasn't thrown");
        }
        catch (Throwable e) {
            System.out.println("Exception: " + e);
            this.verify(e instanceof RuntimeException, "Caught Exception is not of type IllegalArgumentException but:" + e.getClass().getName());
        }
    }
}

