/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestSelect
extends Test {
    IServiceFacade sf;
    IServiceModule serviceModule;
    IAspect queryResult;
    IAspect keyOfSiblings;
    boolean resetDB = false;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.serviceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION");
        IQuery query = this.serviceModule.createQuery("REF_QUERY_1");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*99");
        query.execute();
        this.queryResult = query.getResultAspect();
        this.keyOfSiblings = this.queryResult.getRelatedAspect("REF_RELATION_SIB");
    }

    public void cleanUp() {
        if (this.resetDB) {
            TestUtils.resetDBRefServiceModule(this.sf);
            this.resetDB = false;
        }
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        attributes.setTestSet(new String[]{"testSelectWithOneKey"});
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.serviceModule != null, "ServiceModule creation failed");
        this.verify(this.queryResult != null && this.queryResult.size() > 2, "Query result size must be greater than 2 to do reasonable tests!");
        this.verify(this.keyOfSiblings != null && this.keyOfSiblings.size() > 2, "Siblings size must be greater than 2 to do reasonable tests!");
    }

    public void testSelectKeyAspectOnAspectWithBooster() {
        IQuery query = this.serviceModule.createQuery("REF_QUERY_1");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*99");
        query.execute();
        this.queryResult = query.getResultAspect();
        this.verify(this.queryResult.getAspect("SCOL_REF_KEY") != null, "KeyAspect should not be null");
    }

    public void testSelectKeyAspectOnAspectWithoutBooster() {
        IQuery query = this.serviceModule.createQuery("REF_QUERY_1");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*99");
        query.execute();
        this.queryResult = query.getResultAspect();
        this.sf.flush();
        this.verify(this.queryResult.getAspect("SCOL_REF_KEY") != null, "KeyAspect should not be null");
    }

    public void testSelectSiblings() {
        this.verify(this.keyOfSiblings.size() == 100, "AspectRow number of firstSibling should be 100 but is:" + this.keyOfSiblings.size());
        IKeyAspectDescriptor keyDescriptor = (IKeyAspectDescriptor)this.keyOfSiblings.getDescriptor();
        IAspectDescriptor[] aspectDescriptors = keyDescriptor.getAspectDescriptors();
        this.verify(aspectDescriptors.length > 0, "No sibling Aspect for Key of siblings exist!");
        IAspect[] siblings = new IAspect[aspectDescriptors.length];
        int i = 0;
        while (i < aspectDescriptors.length) {
            siblings[i] = this.keyOfSiblings.getAspect(aspectDescriptors[i].getName());
            this.verify(siblings[i].size() == this.keyOfSiblings.size(), "Number of Sibling '" + aspectDescriptors[i].getName() + "' AspectRows(" + siblings[i].size() + ") doesn't correspond to Key Aspect AspectRows:" + this.keyOfSiblings.size());
            ++i;
        }
    }

    public void testSelectSiblingRows() {
        this.verify(this.keyOfSiblings.size() == 100, "AspectRow number of firstSibling should be 100 but is:" + this.keyOfSiblings.size());
        IKeyAspectDescriptor keyDescriptor = (IKeyAspectDescriptor)this.keyOfSiblings.getDescriptor();
        IAspectDescriptor[] aspectDescriptors = keyDescriptor.getAspectDescriptors();
        this.verify(aspectDescriptors.length > 0, "No sibling Aspect for Key of siblings exist!");
        IAspectRow[] siblingRows = new IAspectRow[aspectDescriptors.length * this.keyOfSiblings.size()];
        int i = 0;
        while (i < aspectDescriptors.length) {
            int j = 0;
            while (j < this.keyOfSiblings.size()) {
                siblingRows[(i + 1) * j] = this.keyOfSiblings.getAspectRow(j).getAspectRow(aspectDescriptors[i].getName());
                ++j;
            }
            int j2 = 0;
            while (j2 < this.keyOfSiblings.size()) {
                this.verify(siblingRows[(i + 1) * j2].getKey().equals(this.keyOfSiblings.getAspectRow(j2).getKey()), "Selected AspectRow with key: " + siblingRows[(i + 1) * j2].getKey() + " doesn't correspond to key: " + this.keyOfSiblings.getAspectRow(j2).getKey());
                ++j2;
            }
            ++i;
        }
    }

    public void testSelectWithKeyList() {
        IKeyList keyList = this.serviceModule.createKeyList("SCOL_REF_SIB_KEY");
        IKey key1 = this.serviceModule.createKey("SCOL_REF_SIB_KEY", new String[]{"0000000004", "0000000004", "0000000004", "0000000004"});
        keyList.add(key1);
        IKey key2 = this.serviceModule.createKey("SCOL_REF_SIB_KEY", new String[]{"0000000003", "0000000004", "0000000004", "0000000004"});
        keyList.add(key2);
        IAspect sibling1 = this.serviceModule.getAspect("SCOL_REF_SIB_DETAIL_1", keyList);
        this.verify(sibling1.size() == 2, "Selected Sibling should have size 2, but has size: " + sibling1.size());
        this.verify(key1.equals(sibling1.getAspectRow(0).getKey()), "Selected Row with key: " + sibling1.getAspectRow(0).getKey() + " is not the expected one");
        this.verify(key2.equals(sibling1.getAspectRow(1).getKey()), "Selected Row with key: " + sibling1.getAspectRow(1).getKey() + " is not the expected one");
    }

    public void testSelectWithOneKey() {
        IServiceModule smFlights = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
        IKeyList keyList = smFlights.createKeyList("SCOL_FLIGHTS_KEY");
        String[] keyFields = new String[]{"JL", "0408", "2004-06-19"};
        IKey key1 = smFlights.createKey("SCOL_FLIGHTS_KEY", keyFields);
        keyList.add(key1);
        this.verify(key1.getFields().length == keyFields.length, "Array of keyFields doesn't correspond to expected Key fields!");
        int i = 0;
        while (i < keyFields.length) {
            this.verify(key1.getFields()[i].equals(keyFields[i]), "Key Field '" + key1.getFields()[i] + "' doesn't correspond to expected Key field: " + keyFields[i]);
            ++i;
        }
        IAspect flights = smFlights.getAspect("SCOL_FLIGHTS_LIST", keyList);
        this.verify(flights.size() == 1, "Selected Sibling should have size 1, but has size: " + flights.size());
        this.verify(flights.getAspectRow(key1) != null, "Selected Row with key: " + key1 + " is null");
    }

    public void testSelectWithKeyURL() {
        int size = this.queryResult.size();
        this.verify(size > 0, "size of result is 0, but must be > 0 to execute a real test!");
        String[] keyUrls = new String[size];
        int i = 0;
        while (i < size) {
            keyUrls[i] = this.queryResult.getAspectRow(i).getRelativeKeyUrl();
            ++i;
        }
        IAspect newSelect = this.serviceModule.getAspect(this.queryResult.getDescriptor().getName(), keyUrls);
        this.verify(newSelect.size() == size, "selected Aspect size should be " + size + " , but is " + newSelect.size());
        int i2 = 0;
        while (i2 < size) {
            IKey key = newSelect.getAspectRow(i2).getKey();
            this.verify(this.queryResult.getAspectRow(key) != null, "no corresponding rows for Key: " + key);
            ++i2;
        }
        try {
            newSelect = this.serviceModule.getAspect(this.queryResult.getDescriptor().getName(), new String[0]);
            this.verify(false, "expected IllegalArgumentException was not thrown!");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Unexpected Exception:" + e);
        }
        try {
            newSelect = this.serviceModule.getAspect(this.queryResult.getDescriptor().getName(), (String[])null);
            this.verify(false, "expected IllegalArgumentException was not thrown!");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Unexpected Exception:" + e);
        }
        try {
            newSelect = this.serviceModule.getAspect(this.queryResult.getDescriptor().getName(), new String[]{"XXXXX/1KEY/1/1/1"});
            this.verify(false, "expected IllegalArgumentException was not thrown!");
        }
        catch (Throwable e) {
            this.verify(e instanceof IllegalArgumentException, "Unexpected Exception:" + e);
        }
    }

    public void testSelectThisOnAspect() {
        this.verify(this.queryResult.getAspect(this.queryResult.getDescriptor().getName()) == this.queryResult, "references should be equal");
        this.verify(this.keyOfSiblings.getAspect(this.keyOfSiblings.getDescriptor().getName(), LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE) == this.keyOfSiblings, "references should be equal");
        this.verify(this.queryResult.getAspect(this.queryResult.getDescriptor().getName(), LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE) == this.queryResult, "references should be equal");
        int i = 0;
        while (i < this.queryResult.size()) {
            this.verify(this.queryResult.getAspectRow(i).getLockState().isEditable(), "AspectRow: " + this.queryResult.getAspectRow(i).getKey() + " has no SP or E lock!");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.keyOfSiblings.size()) {
            this.verify(this.keyOfSiblings.getAspectRow(i2).getLockState().isEditable(), "AspectRow: " + this.keyOfSiblings.getAspectRow(i2).getKey() + " has no SP or E lock!");
            ++i2;
        }
        this.queryResult.unlock();
        this.keyOfSiblings.unlock();
    }

    public void testSelectThisOnAspectRow() {
        IAspectRow firstRow = this.queryResult.getAspectRow(0);
        this.verify(firstRow.getAspectRow(this.queryResult.getDescriptor().getName()) == firstRow, "references should be equal");
        this.verify(firstRow.getAspectRow(this.queryResult.getDescriptor().getName(), LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE) == firstRow, "references should be equal");
        this.sf.flush();
        int i = 0;
        while (i < this.queryResult.size()) {
            if (i == 0) {
                this.verify(this.queryResult.getAspectRow(i).getLockState().isEditable(), "AspectRow: " + this.queryResult.getAspectRow(i).getKey() + " has no SP or E lock!");
            } else {
                this.verify(!this.queryResult.getAspectRow(i).getLockState().hasLock(), "AspectRow: " + this.queryResult.getAspectRow(i).getKey() + " should have no lock!");
            }
            ++i;
        }
    }

    public void testFailedRefresh() {
        int noOfRows = this.keyOfSiblings.size();
        this.verify(noOfRows > 2, "number of sibling rows should be greater than 2 but is :" + noOfRows);
        IKey key0 = this.keyOfSiblings.getAspectRow(0).getKey();
        IKey keyN = this.keyOfSiblings.getAspectRow(noOfRows - 2).getKey();
        IAspect firstSibling = this.keyOfSiblings.getAspect("SCOL_REF_SIB_DETAIL_2");
        firstSibling.remove(0);
        firstSibling.remove(firstSibling.getAspectRow(keyN));
        this.sf.flush();
        TestUtils.dumpMessageList("Messages after delete:", firstSibling.getMessages());
        this.verify(firstSibling.size() == noOfRows - 2, "Size of Sibling after delete is '" + firstSibling.size() + "' but should be" + (noOfRows - 2));
        this.verify(firstSibling.getAspectRow(keyN) == null, "Sibling with key '" + keyN + "' exists but should be deleted");
        this.verify(this.keyOfSiblings.size() == noOfRows, "Size of Sibling Key Aspect after delete is '" + this.keyOfSiblings.size() + "' but should be" + noOfRows);
        this.sf.save();
        firstSibling = this.serviceModule.getAspect("SCOL_REF_SIB_DETAIL_1", this.keyOfSiblings.getKeyList());
        this.verify(firstSibling.size() == noOfRows - 2, "Size of Sibling after refresh is '" + firstSibling.size() + "' but should be" + (noOfRows - 2));
        this.verify(firstSibling.getAspectRow(keyN) == null, "Sibling with key '" + keyN + "' exists but should be deleted");
        this.verify(firstSibling.getAspectRow(key0) == null, "Sibling with key '" + key0 + "' exists but should be deleted");
        this.resetDB = true;
    }

    public void testSelectLocalAspectRow() {
        IAspectRow newRow = this.keyOfSiblings.createAspectRow();
        newRow.setAttributeValue("KEY1", (Object)"0000000888");
        newRow.setAttributeValue("KEY2", (Object)"0000000888");
        newRow.setAttributeValue("KEY3", (Object)"0000000888");
        IAspectRow siblingRow = newRow.getAspectRow("SCOL_REF_SIB_DETAIL_1");
        this.sf.flush();
        this.verify(siblingRow == null, "select sibling of local created AspectRow should not be possible!");
    }

    public void testSelectAndLock() {
        IAspectRow firstRow = this.queryResult.getAspectRow(0);
        IAspectRow lockedRow = this.queryResult.getAspectRow(0, (LockStrategy)null);
        this.sf.flush();
        this.verify(lockedRow == firstRow, "No Reference stability for first row after shared lock!");
        lockedRow.unlock();
        this.sf.cleanup();
    }
}

