/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIModelClassPropertyInfo;
import com.sap.tc.cmi.util.CMIObservableListEvent;
import com.sap.tc.cmi.util.ICMIObservableListChangeListener;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;
import java.util.Iterator;

public class TestRowMetaData
extends Test {
    IServiceFacade sf;
    IServiceModule serviceModule;
    IQuery flightsQuery;
    IAspect flightsList;
    IAspect flightsDetail;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.serviceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
        this.flightsQuery = this.serviceModule.createQuery("FLIGHT_LIST");
        IStructure parms = this.flightsQuery.getInputParameterStructure();
        parms.setAttributeValue("CITYFROM", (Object)"F*");
        parms.setAttributeValue("CITYTO", (Object)"*");
        this.flightsQuery.execute();
        this.flightsList = this.flightsQuery.getResultAspect();
        this.flightsDetail = this.flightsList.getAspect("SCOL_FLIGHTS_DETAIL");
        this.sf.flush();
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.serviceModule != null, "ServiceModule creation failed");
        this.verify(this.flightsQuery != null, "Query creation failed");
        this.verify(this.flightsList != null, "List Aspect is null");
        this.verify(this.flightsDetail != null, "Detail Aspect is null");
        this.verify(this.flightsList.size() > 0, "List Aspect is empty");
        this.verify(this.flightsDetail.size() > 0, "Detail Aspect is empty");
    }

    public void testFieldMetaData() {
        IAspectDescriptor detailsDescr = this.flightsDetail.getDescriptor();
        int i = 0;
        while (i < this.flightsDetail.size()) {
            IAspectRow row = this.flightsDetail.getAspectRow(i);
            String relativeKeyUrl = row.getRelativeKeyUrl();
            String fieldMetaAttribute = detailsDescr.getFieldAttributeStringValue(relativeKeyUrl, "PRICE", "COL_READ_ONLY");
            System.out.println("COL_READ_ONLY('" + relativeKeyUrl + "', 'PRICE') : '" + fieldMetaAttribute + "'");
            this.verify("X".equals(fieldMetaAttribute), "field attribute for row not as expected");
            ++i;
        }
    }

    public void testRelationMetaData() {
        IAspectDescriptor aspectDescr = this.flightsList.getDescriptor();
        IRelationDescriptor detailsDescr = aspectDescr.getRelationDescriptor("SCOL_FLIGHTS_LIST_DETAIL");
        IAction toggleRelationAction = this.flightsList.createAction("SCOL_TOGGLE_RELATION");
        IKeyList keyList = toggleRelationAction.getInputKeyList();
        int i = 0;
        while (i < this.flightsList.size() && i < 20) {
            keyList.clear();
            keyList.add(this.flightsList.getAspectRow(i).getKey());
            toggleRelationAction.getInputParameterStructure().setAttributeValue("COL_RELATION", (Object)"SCOL_FLIGHTS_LIST_DETAIL");
            toggleRelationAction.getInputParameterStructure().setAttributeValue("COL_DEACTIVATED", (Object)Boolean.TRUE);
            toggleRelationAction.execute();
            i += 2;
        }
        this.sf.flush();
        int i2 = 0;
        while (i2 < this.flightsList.size() && i2 < 20) {
            IAspectRow row = this.flightsList.getAspectRow(i2);
            String relativeKeyUrl = row.getRelativeKeyUrl();
            String relAttribute1 = detailsDescr.getAttributeStringValue(row.getRelativeKeyUrl(), "COL_DEACTIVATED");
            if (i2 % 2 == 0) {
                this.verify("X".equalsIgnoreCase(relAttribute1), "relation attribute 1 not as expected (expected: X but was: " + relAttribute1);
            }
            System.out.println("SCOL_FLIGHTS_LIST_DETAIL.COL_DEACTIVATED('" + relativeKeyUrl + "') : '" + relAttribute1 + "'");
            ++i2;
        }
    }

    public void testActionMetaData() {
        IAspectDescriptor aspectDescr = this.flightsList.getDescriptor();
        IAspectActionDescriptor actionDescr = aspectDescr.getAspectActionDescriptor("SCOL_TOGGLE_RELATION");
        IAction toggleAction = this.flightsList.createAction("SCOL_TOGGLE_ACTION");
        IKeyList keyList = toggleAction.getInputKeyList();
        int i = 0;
        while (i < this.flightsList.size() && i < 20) {
            keyList.clear();
            keyList.add(this.flightsList.getAspectRow(i).getKey());
            toggleAction.getInputParameterStructure().setAttributeValue("COL_ACTION", (Object)"SCOL_TOGGLE_RELATION");
            toggleAction.getInputParameterStructure().setAttributeValue("COL_DEACTIVATED", (Object)Boolean.TRUE);
            toggleAction.execute();
            i += 2;
        }
        this.sf.flush();
        int i2 = 0;
        while (i2 < this.flightsList.size() && i2 < 20) {
            IAspectRow row = this.flightsList.getAspectRow(i2);
            String relativeKeyUrl = row.getRelativeKeyUrl();
            String actionAttribute = actionDescr.getAttributeStringValue(row.getRelativeKeyUrl(), "COL_DEACTIVATED");
            if (i2 % 2 == 0) {
                this.verify("X".equalsIgnoreCase(actionAttribute), "Action attribute not as expected (expected: X but was: " + actionAttribute);
            }
            System.out.println("SCOL_TOGGLE_RELATION.COL_DEACTIVATED('" + relativeKeyUrl + "') : '" + actionAttribute + "'");
            ++i2;
        }
    }

    public void testSequenceOfProperties() {
        IAspectDescriptor aspectDescr = this.flightsList.getDescriptor();
        IStructureDescriptor structure = aspectDescr.getStructure();
        IAspectRow modelClassFlight = this.flightsList.getAspectRow(0);
        ICMIModelClassInfo modelClassFlightInfo = modelClassFlight.associatedModelClassInfo();
        this.verify(modelClassFlightInfo.getName().equals("Aspect." + aspectDescr.getName()), "name of model class info is: " + modelClassFlightInfo.getName());
        Iterator itProperties = modelClassFlightInfo.iteratePropertyInfos();
        int index = 0;
        while (itProperties.hasNext()) {
            ICMIModelClassPropertyInfo propertyInfo = (ICMIModelClassPropertyInfo)itProperties.next();
            this.verify(propertyInfo.getName().equals(structure.getFieldDescriptor(index).getName()), "Name of property '" + index + "' should be '" + structure.getFieldDescriptor(index).getName() + "' but is '" + propertyInfo.getName() + "'");
            ++index;
        }
    }

    public void testRefresh1() {
        this.sf.flush();
        MyAspectListener aspectListener = new MyAspectListener(this.flightsList);
        this.verify(this.flightsList.size() > 0, "Size of flights Aspect must be greater 0 to do reasonable tests!");
        IAspectRow firstFlight = this.flightsList.getAspectRow(0);
        firstFlight.setAttributeValue("AIRPTO", (Object)"FRA");
        this.sf.flush();
        this.verify(firstFlight.getAttributeAsString("AIRPTO").equals("FRA"), "Attribute 'AIRPTO' should be 'FRA' but is '" + firstFlight.getAttributeAsString("AIRPTO") + "'");
    }

    public void testRefresh2() {
        this.flightsList.setInvalidationHint("UPDATE", 3);
        this.sf.flush();
        MyAspectListener aspectListener = new MyAspectListener(this.flightsList);
        this.verify(this.flightsList.size() > 0, "Size of flights Aspect must be greater 0 to do reasonable tests!");
        IAspectRow firstFlight = this.flightsList.getAspectRow(0);
        firstFlight.setAttributeValue("AIRPTO", (Object)"FRA");
        this.sf.flush();
        this.verify(firstFlight.getAttributeAsString("AIRPTO").equals("FRA"), "Attribute 'AIRPTO' should be 'FRA' but is '" + firstFlight.getAttributeAsString("AIRPTO") + "'");
    }

    class MyAspectListener
    implements ICMIObservableListChangeListener {
        private final IAspect aspect;

        MyAspectListener(IAspect aspect) {
            this.aspect = aspect;
            aspect.addChangeListener((ICMIObservableListChangeListener)this);
        }

        public void complexChange(CMIObservableListEvent arg0) {
            this.aspect.size();
        }

        public void elementAdded(CMIObservableListEvent arg0) {
        }

        public void elementChanged(CMIObservableListEvent arg0) {
        }

        public void elementRemoved(CMIObservableListEvent arg0) {
        }
    }
}

