/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIRelationRoleInfo;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IStructureList;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.api.IValueSetDescriptor;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;
import java.lang.reflect.Method;
import java.sql.Date;

public class TestQueryCall
extends Test {
    IServiceFacade sf;
    IServiceModule refServiceModule;
    IServiceModule flightsServiceModule;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.refServiceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION");
        this.flightsServiceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.refServiceModule != null, "COL_REF_IMPLEMENTATION ServiceModule could not be created!");
        this.verify(this.flightsServiceModule != null, "CL_SCOOL_SFLIGHT ServiceModule could not be created!");
    }

    public void testSimpleQuery() {
        IQuery query = this.refServiceModule.createQuery("REF_QUERY_1");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*61*");
        query.execute();
        this.verify(query.getResult().size() == 20, "Invalid number of result records: " + query.getResult().size() + " expected: 20");
        parms.setAttributeValue("DATA3", (Object)"*611*");
        query.execute();
        this.verify(query.getResult().size() == 1, "Invalid number of result records: " + query.getResult().size() + " expected: 1");
    }

    public void testQueryWithInKeys() {
        IQuery query = this.flightsServiceModule.createQuery("FLIGHT_LIST");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("CITYFROM", (Object)"F*");
        parms.setAttributeValue("CITYTO", (Object)"*");
        query.execute();
        IAspect result = query.getResultAspect();
        int resultSize = result.size();
        this.verify(resultSize > 0, "Invalid number of result records: " + result.size() + " expected: > 0");
        IKeyList inKeyList = query.getInputKeyList();
        inKeyList.addAll(result.getKeyList());
        inKeyList.remove(0);
        inKeyList.remove(inKeyList.size() - 1);
        query.execute();
        result = query.getResultAspect();
        this.verify(result.size() == inKeyList.size(), "Invalid number of result records: " + result.size() + " expected:" + inKeyList.size());
        int i = 0;
        while (i < result.size()) {
            IKey resultRowKey = result.getAspectRow(i).getKey();
            this.verify(inKeyList.contains(resultRowKey), "Key of result AspectRow " + resultRowKey + " is not in the inKey list");
            ++i;
        }
    }

    public void testSortingFlights() {
        IQuery query = this.flightsServiceModule.createQuery("FLIGHT_LIST");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("CITYFROM", (Object)"F*");
        parms.setAttributeValue("CITYTO", (Object)"*");
        SortingCriteria sortingCriteria = new SortingCriteria();
        sortingCriteria.addCriterion("FLDATE", true);
        this.verify(sortingCriteria.size() == 1, "size of SortingCriteria should be 1 but is: " + sortingCriteria.size());
        query.setSortingCriteria(sortingCriteria);
        TestUtils.dump(sortingCriteria);
        query.execute();
        IAspect queryResult = query.getResultAspect();
        TestUtils.dump(queryResult);
        this.verify(queryResult.size() > 1, "result size is to small to have a reasonable test, size =" + queryResult.size());
        int i = 0;
        while (i < queryResult.size() - 1) {
            Date flDateNext;
            Date flDate = (Date)queryResult.getAspectRow(i).getAttributeValue("FLDATE");
            this.verify(flDate.compareTo(flDateNext = (Date)queryResult.getAspectRow(i + 1).getAttributeValue("FLDATE")) <= 0, "Flights not sorted ascending: Key of flight " + i + ": " + queryResult.getAspectRow(i).getKey() + ", Key of flight " + (i + 1) + ": " + queryResult.getAspectRow(i + 1).getKey());
            ++i;
        }
    }

    public void testSortingRef() {
        IQuery query = this.refServiceModule.createQuery("REF_QUERY_1");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*61*");
        SortingCriteria sortingCriteria = new SortingCriteria();
        sortingCriteria.addCriterion("DATA3", false);
        sortingCriteria.addCriterion("DATA4");
        this.verify(sortingCriteria.size() == 2, "size of SortingCriteria should be 2 but is: " + sortingCriteria.size());
        this.verify(sortingCriteria.getDirection(1), "Sorting Order should be ascending but is descending!");
        this.verify(!sortingCriteria.getDirection(0), "Sorting Order should be descending but is ascending!");
        this.verify(sortingCriteria.getFieldName(0).equals("DATA3"), "Sorting Field should be DATA3 but is: " + sortingCriteria.getFieldName(0));
        this.verify(sortingCriteria.getFieldName(1).equals("DATA4"), "Sorting Field should be DATA4 but is: " + sortingCriteria.getFieldName(1));
        query.setSortingCriteria(sortingCriteria);
        query.execute();
        TestUtils.dump(query.getResult());
        this.verify(query.getResult().size() == 20, "Invalid number of result records: " + query.getResult().size() + " expected: 20");
    }

    public void testSelectOptionsFlights() {
        IQuery query = this.flightsServiceModule.createQuery("FLIGHT_LIST");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("CITYFROM", (Object)"F*");
        parms.setAttributeValue("CITYTO", (Object)"*");
        query.execute();
        IAspect result = query.getResultAspect();
        this.verify(result.size() > 0, " precondition query result > 0 not fulfilled!");
        int noOfLH = 0;
        int i = 0;
        while (i < result.size()) {
            if (result.getAspectRow(i).getAttributeAsString("CARRID").equalsIgnoreCase("LH")) {
                ++noOfLH;
            }
            ++i;
        }
        IStructure optionCarrId = query.createSelectOption("CARRID");
        optionCarrId.setAttributeValue("OPTION", (Object)"BT");
        optionCarrId.setAttributeValue("LOW", (Object)"LH");
        optionCarrId.setAttributeValue("HIGH", (Object)"LH");
        IStructureList optionsList = query.getSelectOptions();
        this.verify(optionsList.size() == 1, "number of select options should be 1, but is:" + optionsList.size());
        query.execute();
        TestUtils.dump(query.getResult());
        this.verify(query.getResult().size() == noOfLH, "Invalid number of result records: " + query.getResult().size() + " expected: " + noOfLH);
    }

    public void testSelectOptions() {
        IQuery query = this.refServiceModule.createQuery("REF_QUERY_1");
        IStructure parms = query.getInputParameterStructure();
        parms.setAttributeValue("DATA3", (Object)"*61*");
        IStructure optionData4 = query.createSelectOption("DATA4");
        optionData4.setAttributeValue("OPTION", (Object)"NE");
        optionData4.setAttributeValue("LOW", (Object)"100");
        IStructure optionData5 = query.createSelectOption("DATA5", "BT", "20", "2000");
        IStructureList optionsList = query.getSelectOptions();
        this.verify(optionsList.size() == 2, "number of select options should be 2, but is:" + optionsList.size());
        query.execute();
        TestUtils.dump(query.getResult());
        this.verify(query.getResult().size() == 20, "Invalid number of result records: " + query.getResult().size() + " expected: 20");
    }

    public void testCMIMetaData() {
        IQuery query = this.refServiceModule.createQuery("REF_QUERY_1");
        ICMIModelClassInfo queryInfo = query.associatedModelClassInfo();
        IQueryDescriptor queryDescriptor = query.getDescriptor();
        this.verify(queryInfo.getName().equals("Query." + queryDescriptor.getName()), "name of Query ICMIModelClassInfo is '" + queryInfo.getName() + "' but should be '" + "Query." + queryDescriptor.getName() + "'");
        this.verify(this.getQueryDescriptor(queryInfo) == queryDescriptor, "Inconsistent QueryDescriptor in Query ColModelClassInfo");
        this.verify(this.getStructureDescriptor(queryInfo) == null, "StructureDescriptor in Query ColModelClassInfo should be null");
        IStructureDescriptor inParamDescriptor = queryDescriptor.getInputParameters();
        ICMIModelClassInfo inParamsInfo = queryInfo.getRelatedModelClassInfo("inputParameter");
        this.verify(inParamsInfo.getName().equals("Structure." + inParamDescriptor.getName()), "name of Structure ICMIModelClassInfo is '" + inParamsInfo.getName() + "' but should be '" + "Structure." + inParamDescriptor.getName() + "'");
        this.verify(this.getQueryDescriptor(inParamsInfo) == null, "QueryDescriptor in Structure ColModelClassInfo should be null");
        this.verify(this.getStructureDescriptor(inParamsInfo) == inParamDescriptor, "Inconsistent StructureDescriptor in Structure ColModelClassInfo");
        IStructureDescriptor inSelectionsDescriptor = queryDescriptor.getSelections();
        ICMIModelClassInfo inSelectionsInfo = queryInfo.getRelatedModelClassInfo("selectOptions");
        this.verify(inSelectionsInfo.getName().equals("Structure." + inSelectionsDescriptor.getName()), "name of Structure ICMIModelClassInfo is '" + inSelectionsInfo.getName() + "' but should be '" + "Structure." + inSelectionsInfo.getName() + "'");
        this.verify(this.getActionDescriptor(inSelectionsInfo) == null, "AspectActionDescriptor in Structure ColModelClassInfo should be null");
        this.verify(this.getStructureDescriptor(inSelectionsInfo) == inSelectionsDescriptor, "Inconsistent StructureDescriptor in Structure ColModelClassInfo");
        IAspectDescriptor resultDescriptor = queryDescriptor.getResultAspectDescriptor();
        ICMIModelClassInfo resultInfo = queryInfo.getRelatedModelClassInfo("result");
        this.verify(resultInfo.getName().equals("Aspect." + resultDescriptor.getName()), "name of Aspect ICMIModelClassInfo is '" + resultInfo.getName() + "' but should be '" + "Aspect." + resultDescriptor.getName() + "'");
        this.verify(this.getValueSetDescriptor(resultInfo) == null, "ValueSetDescriptor in Aspect ColModelClassInfo should be null");
        this.verify(this.getAspectDescriptor(resultInfo) == resultDescriptor, "Inconsistent AspectDescriptor in AspectRow ColModelClassInfo");
        ICMIRelationRoleInfo roleSelectionsInfo = queryInfo.getTargetRoleInfo("selectOptions");
        this.verify(roleSelectionsInfo != null, "implicit relation for select options not found");
        this.verify(roleSelectionsInfo.getCardinality() == CMICardinality.CARDINALITY_MANY, "incorrect cardinality for relation SELECT_OPTIONS");
    }

    public void testIsInitial() {
        IQuery query = this.refServiceModule.createQuery("REF_QUERY_1");
        IStructure inParams = query.getInputParameterStructure();
        int i = 0;
        while (i < inParams.size()) {
            this.verify(inParams.isAttributeInitial(i), "inParams attribute '" + i + "' is not initial but: " + inParams.getAttributeValue(i));
            ++i;
        }
        this.verify(inParams.isAttributeInitial("DATA3"), "inParams attribute 'DATA3' is not initial but: " + inParams.getAttributeValue("DATA3"));
        this.verify(inParams.isAttributeInitial("DATA4"), "inParams attribute 'DATA4' is not initial but: " + inParams.getAttributeValue("DATA4"));
        this.verify(inParams.isAttributeInitial("DATA5"), "inParams attribute 'DATA5' is not initial but: " + inParams.getAttributeValue("DATA5"));
        inParams.setAttributeValue("DATA3", (Object)"33");
        this.verify(!inParams.isAttributeInitial("DATA3"), "inParams attribute 'DATA3' is initial but should be '33'");
        IAspect testAspect = this.refServiceModule.createAspect("SCOL_REF_DETAIL");
        IAspectRow aspectRow = testAspect.createAspectRow();
        int i2 = 0;
        while (i2 < aspectRow.size()) {
            this.verify(aspectRow.isAttributeInitial(i2), "aspectRow attribute '" + i2 + "' is not initial but: " + aspectRow.getAttributeValue(i2));
            ++i2;
        }
        this.verify(aspectRow.isAttributeInitial("DATA3"), "aspectRow attribute 'DATA3' is not initial but: " + aspectRow.getAttributeValue("DATA3"));
        this.verify(aspectRow.isAttributeInitial("DATA4"), "aspectRow attribute 'DATA4' is not initial but: " + aspectRow.getAttributeValue("DATA4"));
        this.verify(aspectRow.isAttributeInitial("DATA5"), "aspectRow attribute 'DATA5' is not initial but: " + aspectRow.getAttributeValue("DATA5"));
        aspectRow.setAttributeValue("DATA5", (Object)"33");
        this.verify(!aspectRow.isAttributeInitial("DATA5"), "aspectRow attribute 'DATA5' is initial but should be '33'");
    }

    private IAspectActionDescriptor getActionDescriptor(ICMIModelClassInfo object) {
        return (IAspectActionDescriptor)this.getDescriptor(object, "getActionDescriptor");
    }

    private IAspectDescriptor getAspectDescriptor(ICMIModelClassInfo object) {
        return (IAspectDescriptor)this.getDescriptor(object, "getAspectDescriptor");
    }

    private IQueryDescriptor getQueryDescriptor(ICMIModelClassInfo object) {
        return (IQueryDescriptor)this.getDescriptor(object, "getQueryDescriptor");
    }

    private IStructureDescriptor getStructureDescriptor(ICMIModelClassInfo object) {
        return (IStructureDescriptor)this.getDescriptor(object, "getStructureDescriptor");
    }

    private IValueSetDescriptor getValueSetDescriptor(ICMIModelClassInfo object) {
        return (IValueSetDescriptor)this.getDescriptor(object, "getValueSetDescriptor");
    }

    private Object getDescriptor(ICMIModelClassInfo object, String methodName) {
        try {
            Method method = object.getClass().getMethod(methodName, null);
            return method.invoke((Object)object, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

