/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;

public class TestMessages
extends Test {
    IServiceFacade sf;
    IServiceModule serviceModule;
    IAspect sourceAspect;
    IAspect aspectToChange;
    private IKey testKey;
    private int initialNoOfRows;

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.serviceModule = this.sf.getServiceModule("CL_SCOOL_SFLIGHT");
        IKeyList keyList = this.serviceModule.createKeyList("SCOL_FLIGHTS_KEY");
        this.testKey = TestUtils.getFlightTestKey(this.sf, this.serviceModule);
        if (this.testKey != null) {
            keyList.add(TestUtils.getFlightTestKey(this.sf, this.serviceModule));
        }
        this.sourceAspect = this.serviceModule.getAspect("SCOL_FLIGHTS_KEY", keyList);
        if (this.sourceAspect.size() > 0) {
            this.aspectToChange = this.sourceAspect.getRelatedAspect("BOOKINGS");
            this.initialNoOfRows = this.aspectToChange.size();
        }
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.testKey != null, "test Key should not be null");
        this.verify(this.serviceModule != null, "ServiceModule creation failed");
        this.verify(this.sourceAspect != null, "Source Aspect for Relation is null");
        this.verify(this.aspectToChange != null, "Aspect to change is null");
        this.verify(this.initialNoOfRows > 0, "Aspect to change has no AspectRows");
    }

    public void testMessagesOnUpdate() {
        this.verify(this.initialNoOfRows > 2, "Number '" + this.initialNoOfRows + "' of AspectRows to change is to low to do this complex test");
        IKey key0 = this.changeAspectRowWithError(this.aspectToChange.getAspectRow(0));
        IKey keyLast = this.changeAspectRowWithError(this.aspectToChange.getAspectRow(this.initialNoOfRows - 1));
        this.sf.flush();
        this.verify(this.aspectToChange.size() == this.initialNoOfRows, "Size of changed Aspect has changed new size:" + this.aspectToChange.size() + " original:" + this.initialNoOfRows);
        IMessageList messages = this.aspectToChange.getMessages();
        IMessageList allMessages = this.sf.getAllMessages();
        TestUtils.dumpMessageList("Messages for changed Aspect", messages);
        TestUtils.dumpMessageList("All Messages", allMessages);
        int noOfFailedMessages = TestUtils.noOfFailedMessages(messages);
        int totalNoOfMessages = messages.size();
        this.verify(noOfFailedMessages == 2, "Two error messages expected, but there are:" + noOfFailedMessages);
        noOfFailedMessages = TestUtils.noOfFailedMessages(this.sf.getAllMessages());
        this.verify(noOfFailedMessages == 2, "Two error messages expected, but there are :" + noOfFailedMessages);
        this.verify(this.sf.getAndClearSystemMessages().size() == 0, "No common error messages expected");
        messages.removeMessage(messages.getMessage(0));
        this.verify(this.sf.getAllMessages().size() == --totalNoOfMessages, "Number of Messages expected " + totalNoOfMessages + ", but there are:" + this.sf.getAllMessages().size());
        this.verify(messages.size() == totalNoOfMessages, "Number of Messages expected " + totalNoOfMessages + ", but there are:" + messages.size());
        IMessage message = messages.getMessage(0);
        this.verify(message.isError(), "error message expected, but there is:" + message.getType());
        this.sf.getAllMessages().clear();
        this.verify(this.sf.getAllMessages().isEmpty(), "message list should be empty but size is:" + this.sf.getAllMessages().size());
        messages = this.sf.getAndClearSystemMessages();
        this.verify(messages.isEmpty(), "message list should be empty but size is:" + messages.size());
    }

    public void testMessageOnUpdate() {
        this.verify(this.initialNoOfRows > 1, "Number '" + this.initialNoOfRows + "' of AspectRows to change is too low to do this complex test");
        IKey key0 = this.changeAspectRowWithError(this.aspectToChange.getAspectRow(0));
        this.sf.flush();
        this.verify(this.aspectToChange.size() == this.initialNoOfRows, "Size of changed Aspect has changed new size:" + this.aspectToChange.size() + " original:" + this.initialNoOfRows);
        IMessageList messages = this.aspectToChange.getMessages();
        this.verify(messages.size() == 1, "One error message expected but there were '" + messages.size() + "' messages!");
        IMessage message = messages.getMessage(0);
        this.verify(message.isError(), "Error message expected but is: " + message.getType());
        this.verify(message.isAspectRowMessage(), "AspectRow message expected !");
        this.verify(message.getAspectName().equals(this.aspectToChange.getDescriptor().getName()), "Unexpected Aspect Name: " + message.getAspectName());
    }

    private IKey changeAspectRowWithError(IAspectRow rowToChange) {
        IKey keyOfRowToChange = rowToChange.getKey();
        rowToChange.setAttributeValue("CARRID", (Object)"XX");
        return keyOfRowToChange;
    }
}

