/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.test;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.test.TestUtils;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;
import java.sql.Date;

public class TestDataTypes
extends Test {
    IServiceFacade sf;
    IServiceModule serviceModule;
    private static final String[] KEY_FIELDS = new String[]{"0000000003", "0000000001", "0000000009"};

    public void prepare() {
        this.sf = TestUtils.prepare(this);
        this.serviceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION");
    }

    public void cleanUp() {
        this.sf.closeConnection();
    }

    public static void adjustTestAttributes(IJverTestAttributes attributes) {
        TestUtils.adjustTestAttributes(attributes);
    }

    public void testPreconditions() {
        this.verify(this.serviceModule != null, "COL_REF_IMPLEMENTATIONdoesn't exist");
    }

    public void testExistingDataTypes() {
        IKeyList keyList = this.serviceModule.createKeyList("SCOL_REF_KEY");
        keyList.add(this.serviceModule.createKey("SCOL_REF_KEY", KEY_FIELDS));
        IAspect keyAspect = this.serviceModule.getAspect("SCOL_REF_KEY", keyList);
        IAspect scolRef = keyAspect.getAspect("SCOL_REF_DETAIL");
        this.verify(scolRef.size() == 1, "Reference Aspect not correctly selected: size = " + scolRef.size());
        IAspectRow row = scolRef.getAspectRow(0);
        this.verify(row.getAttributeValue("KEY1") instanceof String, "KEY1 is not of data type 'String'");
        this.verify(row.getAttributeValue("DATA1") instanceof Boolean, "DATA1 is not of data type 'Boolean'");
        this.verify(row.getAttributeValue(3) instanceof Boolean, "DATA1 is not of data type 'Boolean'");
        this.verify(row.getAttributeValue("DATA4") instanceof Integer, "DATA4 is not of data type 'Integer'");
        this.verify(row.getAttributeValue("DATA2") instanceof Date, "DATA2 is not of data type 'java.sql.Date'");
        Date testDate = (Date)row.getAttributeValue("DATA2");
        row.setAttributeValue("KEY1", (Object)"TEST");
        row.setAttributeValue("DATA1", (Object)Boolean.TRUE);
        row.setAttributeValue("DATA4", (Object)new Integer(1));
        row.setAttributeValue("DATA2", (Object)testDate);
        this.verify(row.getAttributeValue("KEY1").equals("TEST"), "KEY1 is not set correctly: '" + row.getAttributeValue("KEY1") + "'");
        this.verify((Boolean)row.getAttributeValue("DATA1"), "DATA1 is not set correctly: '" + row.getAttributeValue("DATA1") + "'");
        this.verify((Boolean)row.getAttributeValue(3), "DATA1 is not set correctly: '" + row.getAttributeValue(3) + "'");
        this.verify((Integer)row.getAttributeValue("DATA4") == 1, "DATA4 is not set correctly: '" + row.getAttributeValue("DATA4") + "'");
        Date resultDate = (Date)row.getAttributeValue("DATA2");
        this.verify(resultDate.toString().equals(testDate.toString()), "DATA2 is not set correctly: '" + row.getAttributeValue("DATA2") + "' expected:" + testDate);
    }

    public void testExistingDataTypesOfStructure() {
        IQuery query = this.serviceModule.createQuery("REF_QUERY_1");
        IStructure structure = query.getInputParameterStructure();
        Date testDate = new Date(System.currentTimeMillis());
        structure.setAttributeValue("DATA3", (Object)"TEST");
        structure.setAttributeValue("DATA1", (Object)Boolean.TRUE);
        structure.setAttributeValue("DATA4", (Object)new Integer(1));
        structure.setAttributeValue("DATA2", (Object)testDate);
        this.verify(structure.getAttributeValue("DATA3").equals("TEST"), "DATA3 is not set correctly: '" + structure.getAttributeValue("DATA3") + "'");
        this.verify((Boolean)structure.getAttributeValue("DATA1"), "DATA1 is not set correctly: '" + structure.getAttributeValue("DATA1") + "'");
        this.verify((Boolean)structure.getAttributeValue(0), "DATA1 is not set correctly: '" + structure.getAttributeValue(0) + "'");
        this.verify(structure.getAttributeAsString(0).equals("X"), "DATA1 is not set correctly: '" + structure.getAttributeAsString(0) + "'");
        this.verify(structure.getAttributeAsString("DATA1").equals("X"), "DATA1 is not set correctly: '" + structure.getAttributeAsString("DATA1") + "'");
        this.verify((Integer)structure.getAttributeValue("DATA4") == 1, "DATA4 is not set correctly: '" + structure.getAttributeValue("DATA4") + "'");
        Date resultDate = (Date)structure.getAttributeValue("DATA2");
        this.verify(resultDate.toString().equals(testDate.toString()), "DATA2 is not set correctly: '" + structure.getAttributeValue("DATA2") + "' expected:" + testDate);
    }

    public void testBinary() {
        IServiceModule ref2ServiceModule = this.sf.getServiceModule("COL_REF_IMPLEMENTATION_2");
        IQuery query = ref2ServiceModule.createQuery("ALL_TYPES");
        query.execute();
        IAspect result = query.getResultAspect();
        this.verify(result.size() > 0, "Size of result is 0, so no test posiible!!");
        IAspectRow firstRow = result.getAspectRow(0);
        this.verify(firstRow.getAttributeValue("RAW_16") instanceof byte[], "RAW_16 is not of data type 'byte[]'");
        byte[] binary = (byte[])firstRow.getAttributeValue("RAW_16");
        this.verify(binary.length == 16, "Length of binary should be 16 but is: " + binary.length);
        IKeyList keys = result.getKeyList();
        keys.clear();
        keys.add(firstRow.getKey());
        IAspect onlyFirstRow = ref2ServiceModule.getAspect(result.getDescriptor().getName(), keys);
        IAspectRow newFirstRow = onlyFirstRow.getAspectRow(0);
        this.verify(firstRow.getKey().equals(newFirstRow.getKey()), "New attrbute '" + newFirstRow.getAttributeValue("RAW_16") + "' is not equal to '" + binary + "'");
        byte[] binary1 = (byte[])newFirstRow.getAttributeValue("RAW_16");
        this.verify(binary1.length == 16, "Length of binary should be 16 but is: " + binary1.length);
        int i = 0;
        while (i < 16) {
            this.verify(binary[i] == binary1[i], "Bytes not equal: " + binary[i] + "/" + binary1[i]);
            ++i;
        }
    }
}

