/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IStructureList;
import com.sap.tc.col.client.generic.api.IValueSet;
import com.sap.tc.col.client.generic.core.AbstractModelClass;
import com.sap.tc.col.client.generic.core.ColModelInfo;
import com.sap.tc.col.client.generic.core.GenericClientUtils;
import com.sap.tc.col.client.generic.core.ISrvMgrCaller;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.generic.core.Structure;
import com.sap.tc.col.client.generic.core.StructureList;
import com.sap.tc.col.client.metadata.api.IValueSetDescriptor;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrGetValueSet;
import com.sap.tc.logging.Location;
import java.util.Collection;

public class ValueSet
extends AbstractModelClass
implements IValueSet,
ISrvMgrCaller {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$ValueSet == null ? (class$com$sap$tc$col$client$generic$core$ValueSet = ValueSet.class$("com.sap.tc.col.client.generic.core.ValueSet")) : class$com$sap$tc$col$client$generic$core$ValueSet));
    protected static final String VALUE_SET_FLUSH = "ValueSet.execute";
    private final ServiceModule serviceModule;
    private final IValueSetDescriptor descriptor;
    private final ICMIModelClassInfo modelClassInfo;
    private final Structure inputParameter;
    private StructureList outValues;
    private final ISrvMgrGetValueSet srvMgrValueSet;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$ValueSet;

    protected ValueSet(IValueSetDescriptor descriptor, ServiceModule serviceModule) {
        if (serviceModule == null) {
            throw new IllegalArgumentException("ServiceModule must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("IValueSetDescriptor must not be null");
        }
        this.descriptor = descriptor;
        this.serviceModule = serviceModule;
        this.srvMgrValueSet = serviceModule.getSrvMgrServiceModule().createGetValueSet(descriptor.getAspectDescriptor().getName(), descriptor.getFieldDescriptor().getName());
        this.inputParameter = descriptor.hasInputParameters() ? new Structure(serviceModule, this.srvMgrValueSet.getInParameters()) : null;
        this.modelClassInfo = ((ColModelInfo)serviceModule.associatedModelInfo()).getOrCreateModelClassInfo(descriptor);
    }

    public void execute() {
        if (logger.bePath()) {
            logger.pathT("entering: execute");
        }
        if (this.outValues != null && this.outValues.getState() == 1) {
            return;
        }
        if (this.outValues != null) {
            this.srvMgrValueSet.reset();
            if (this.inputParameter != null) {
                this.srvMgrValueSet.setInParameters(this.inputParameter.getEdoStructure());
            }
        }
        this.serviceModule.registerSrvMgrCallObject((ISrvMgrCall)this.srvMgrValueSet, this);
        if (this.outValues == null) {
            this.outValues = new StructureList(this.descriptor.getResultStructureDescriptor(), this.serviceModule, VALUE_SET_FLUSH);
        }
        this.outValues.setState(1);
        if (this.inputParameter != null) {
            this.inputParameter.makeClean();
        }
    }

    public IValueSetDescriptor getDescriptor() {
        if (logger.bePath()) {
            logger.pathT("entering: getDescriptor");
        }
        return this.descriptor;
    }

    public IStructureList getOutValuesList() {
        if (logger.bePath()) {
            logger.pathT("entering: getOutValuesList");
        }
        return this.outValues;
    }

    public IStructure getInputParameterStructure() {
        if (logger.bePath()) {
            logger.pathT("entering: getInputParameterStructure");
        }
        return this.inputParameter;
    }

    public long countOf() {
        return -1L;
    }

    public boolean isDirty() {
        return this.outValues == null || this.inputParameter != null && this.inputParameter.isDirty();
    }

    public Object getInputParameter() {
        if (logger.bePath()) {
            logger.pathT("entering: getInputParameter");
        }
        return this.inputParameter;
    }

    public Collection getResult() {
        if (logger.bePath()) {
            logger.pathT("entering: getResult");
        }
        return this.outValues;
    }

    public ICMIModelClassInfo associatedInputParameterInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedInputParameterInfo");
        }
        return this.modelClassInfo.getRelatedModelClassInfo("inputParameter");
    }

    public ICMIModelObjectCollectionInfo associatedResultInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedResultInfo");
        }
        return ((ColModelInfo)this.modelClassInfo.getModelInfo()).getOrCreateModelObjectCollectionInfo(this.descriptor.getResultStructureDescriptor());
    }

    public ICMIModelClass getRelatedModelObject(String rolename) {
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedModelObject", "Role: " + rolename);
        }
        if (rolename.equalsIgnoreCase("inputParameter") || rolename.equals("com.sap.tc.cmi:queryInputParameter")) {
            return (ICMIModelClass)this.getInputParameter();
        }
        return super.getRelatedModelObject(rolename);
    }

    public Collection getRelatedModelObjects(String rolename) {
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedModelObjects", "Role: " + rolename);
        }
        if (rolename.equalsIgnoreCase("outValues") || rolename.equals("com.sap.tc.cmi:queryResult")) {
            return this.outValues;
        }
        return super.getRelatedModelObjects(rolename);
    }

    public ICMIModelClassInfo associatedModelClassInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModelClassInfo");
        }
        return this.modelClassInfo;
    }

    public ICMIModel associatedModel() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModel");
        }
        return this.serviceModule;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public void onCallsProcessed(ISrvMgrCall[] calls) {
        if (logger.bePath()) {
            logger.pathT("entering: onCallsProcessed", "ValueSet name: " + this.getName());
        }
        if (calls.length == 0) {
            return;
        }
        if (calls.length > 1 || calls[calls.length - 1] != this.srvMgrValueSet) {
            logger.infoT("onCallsProcessed", "more than one ValueSet call in one rounddrip or other inconsistence with Valueset: " + this.getName());
        }
        if (logger.bePath()) {
            GenericClientUtils.dumpSrvMgrCall((ISrvMgrCall)this.srvMgrValueSet, logger);
        }
        this.outValues.setState(0);
        this.outValues.clear();
        int i = 0;
        while (i < this.srvMgrValueSet.getOutRecords().getRecordCount()) {
            this.outValues.add(new Structure(this.serviceModule, this.srvMgrValueSet.getOutRecords().getRecord(i)));
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/ValueSet.java#1 $");
    }
}

