/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.cmi.util.CMIAbstractObservableList;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IStructureList;
import com.sap.tc.col.client.generic.core.ColModelInfo;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import java.util.ArrayList;
import java.util.List;

public class StructureList
extends CMIAbstractObservableList
implements IStructureList {
    private final List structures = new ArrayList();
    private final String roleOfStructureList;
    private final ServiceModule serviceModule;
    private int state = 0;
    private final IStructureDescriptor descriptor;
    private final ICMIModelObjectCollectionInfo modelObjectCollectionInfo;

    protected StructureList(IStructureDescriptor structureDescriptor, ServiceModule serviceModule, String roleOfStructureList) {
        if (structureDescriptor == null) {
            throw new IllegalArgumentException("StructureDescriptor must not be null!");
        }
        this.descriptor = structureDescriptor;
        this.serviceModule = serviceModule;
        this.roleOfStructureList = roleOfStructureList;
        this.modelObjectCollectionInfo = ((ColModelInfo)serviceModule.associatedModelInfo()).getOrCreateModelObjectCollectionInfo(structureDescriptor);
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    public IStructureDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IStructure getStructure(int index) {
        this.handleAccessStructureList();
        return (IStructure)this.structures.get(index);
    }

    public ICMIModelObjectCollectionInfo associatedModelObjectCollectionInfo() {
        return this.modelObjectCollectionInfo;
    }

    private void handleAccessStructureList() {
        if (this.state == 1) {
            this.serviceModule.flush(this.roleOfStructureList);
        }
    }

    public void addSilently(int index, Object element) {
        this.handleAccessStructureList();
        if (!(element instanceof IStructure)) {
            throw new IllegalArgumentException("element is no Structure instance!");
        }
        if (this.descriptor != ((IStructure)element).getDescriptor()) {
            throw new IllegalArgumentException("Structure " + element + " is no Structure of type " + this.descriptor.getName());
        }
        this.structures.add(index, element);
    }

    public Object get(int index) {
        return this.getStructure(index);
    }

    public Object removeSilently(int index) {
        this.handleAccessStructureList();
        return this.structures.remove(index);
    }

    public Object setSilently(int index, Object element) {
        throw new UnsupportedOperationException("StructureList doesn't support changing rows via its List interface");
    }

    public int size() {
        this.handleAccessStructureList();
        return this.structures.size();
    }
}

