/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.core.AbstractModelClass;
import com.sap.tc.col.client.generic.core.ColModelInfo;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.logging.Location;

public class Structure
extends AbstractModelClass
implements IStructure {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$Structure == null ? (class$com$sap$tc$col$client$generic$core$Structure = Structure.class$("com.sap.tc.col.client.generic.core.Structure")) : class$com$sap$tc$col$client$generic$core$Structure));
    int state = 0;
    private final ServiceModule serviceModule;
    private final ICMIModelClassInfo modelClassInfo;
    private final IEdoStructure edoStructure;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$Structure;

    protected Structure(ServiceModule serviceModule, IEdoStructure edoStructure) {
        if (serviceModule == null) {
            throw new IllegalArgumentException("ServiceModule must not be null");
        }
        if (edoStructure == null) {
            throw new IllegalArgumentException("Structure without valid data (EDO Structure) is not allowed!");
        }
        this.serviceModule = serviceModule;
        this.edoStructure = edoStructure;
        this.modelClassInfo = ((ColModelInfo)serviceModule.associatedModelInfo()).getOrCreateModelClassInfo(this.getDescriptor());
    }

    public ICMIModel associatedModel() {
        return this.serviceModule;
    }

    public ICMIModelClassInfo associatedModelClassInfo() {
        return this.modelClassInfo;
    }

    public String getAttributeAsString(String attributeName) {
        return this.edoStructure.getStringValue(attributeName);
    }

    public Object getAttributeValue(String attributeName) {
        return this.edoStructure.getValue(attributeName);
    }

    public void setAttributeValue(String attributeName, Object attributeValue) {
        if (logger.bePath()) {
            logger.pathT("entering: setAttributeValue", "name: " + attributeName + " Value: " + attributeValue);
        }
        this.edoStructure.setValue(attributeName, attributeValue);
        this.state = 2;
        this.incrementModCount();
    }

    public String getAttributeAsString(int attributeIndex) {
        return this.edoStructure.getStringValue(attributeIndex);
    }

    public Object getAttributeValue(int attributeIndex) {
        return this.edoStructure.getValue(attributeIndex);
    }

    public void setAttributeValue(int attributeIndex, Object attributeValue) {
        if (logger.bePath()) {
            logger.pathT("entering: setAttributeValue", "Index: " + attributeIndex + " Value: " + attributeValue);
        }
        this.edoStructure.setValue(attributeIndex, attributeValue);
        this.state = 2;
        this.incrementModCount();
    }

    public boolean isAttributeInitial(int attributeIndex) {
        return this.edoStructure.isInitial(attributeIndex);
    }

    public boolean isAttributeInitial(String attributeName) {
        return this.edoStructure.isInitial(attributeName);
    }

    public IStructureDescriptor getDescriptor() {
        return this.edoStructure.getDescriptor();
    }

    public int size() {
        return this.getDescriptor().size();
    }

    protected IEdoStructure getEdoStructure() {
        return this.edoStructure;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <Structure>").append(nl);
        int i = 0;
        while (i < this.size()) {
            IFieldDescriptor field = this.getDescriptor().getFieldDescriptor(i);
            String attributeName = field.getName();
            String attributeValue = this.getAttributeAsString(i);
            if (attributeValue != null) {
                buf.append("     " + attributeName).append("=").append(attributeValue).append(nl);
            } else {
                buf.append("     " + attributeName).append("= <null>").append(nl);
            }
            ++i;
        }
        buf.append("  </Structure>").append(nl);
        return buf.toString();
    }

    public boolean isDirty() {
        return this.state == 2;
    }

    public void makeClean() {
        this.state = 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/Structure.java#1 $");
    }
}

