/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.cmi.metadata.ICMIModelInfo;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IValueSet;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.core.Action;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.client.generic.core.AspectCache;
import com.sap.tc.col.client.generic.core.ColModelInfo;
import com.sap.tc.col.client.generic.core.GenericClientUtils;
import com.sap.tc.col.client.generic.core.ICacheRootObject;
import com.sap.tc.col.client.generic.core.ISrvMgrCaller;
import com.sap.tc.col.client.generic.core.Key;
import com.sap.tc.col.client.generic.core.KeyList;
import com.sap.tc.col.client.generic.core.LockState;
import com.sap.tc.col.client.generic.core.Query;
import com.sap.tc.col.client.generic.core.ServiceFacade;
import com.sap.tc.col.client.generic.core.Structure;
import com.sap.tc.col.client.generic.core.ValueSet;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.api.IValueSetDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCopyCorresponding;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelect;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ServiceModule
implements IServiceModule {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$ServiceModule == null ? (class$com$sap$tc$col$client$generic$core$ServiceModule = ServiceModule.class$("com.sap.tc.col.client.generic.core.ServiceModule")) : class$com$sap$tc$col$client$generic$core$ServiceModule));
    private final ServiceFacade serviceFacade;
    boolean refreshOfDirtySubTreesStarted = false;
    private ISrvMgrServiceModule srvMgrServiceModule;
    private ColModelInfo modelInfo;
    private ArrayList cacheRootObjects = new ArrayList();
    private HashMap srvMgrCallObjects = new HashMap();
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$ServiceModule;

    protected ServiceFacade getServiceFacade() {
        return this.serviceFacade;
    }

    protected ServiceModule(IServiceFacade serviceFacade, ISrvMgrServiceModule srvMgrServiceModule) {
        this.serviceFacade = (ServiceFacade)serviceFacade;
        this.srvMgrServiceModule = srvMgrServiceModule;
    }

    public IQuery createQuery(String queryName) {
        IQueryDescriptor queryDescriptor;
        if (logger.bePath()) {
            logger.pathT("entering: createQuery", "Query name: " + queryName);
        }
        if ((queryDescriptor = this.getDescriptor().getQueryDescriptor(queryName)) == null) {
            logger.fatalT("Query with name " + queryName + " doesn't exist!");
            throw new IllegalArgumentException("Query with name " + queryName + " doesn't exist!");
        }
        Query newQuery = (Query)this.createQueryInternal(queryDescriptor);
        AspectCache aspectCache = new AspectCache(newQuery);
        this.cacheRootObjects.add(newQuery);
        newQuery.bindAspectCache(aspectCache);
        return newQuery;
    }

    protected Aspect createAspectInCache(AspectCache cache, String aspectName, ISrvMgrCall srvMgrCall) {
        IAspectDescriptor aspectDescriptor;
        if (logger.bePath()) {
            if (srvMgrCall != null) {
                logger.pathT("entering: createAspectInCache", "Aspect name: " + aspectName + " Call: " + GenericClientUtils.getUnqualifiedClassName(srvMgrCall.getClass().getName()));
            } else {
                logger.pathT("entering: createAspectInCache", "Aspect name: " + aspectName + " Call: null");
            }
        }
        if ((aspectDescriptor = this.getDescriptor().getAspectDescriptor(aspectName)) == null && (aspectDescriptor = this.getDescriptor().getKeyAspectDescriptor(aspectName)) == null) {
            logger.fatalT("Aspect with name " + aspectName + " doesn't exist!");
            throw new IllegalArgumentException("Aspect with name " + aspectName + " doesn't exist!");
        }
        Aspect aspect = (Aspect)this.createAspectInternal(aspectDescriptor, srvMgrCall);
        if (cache != null) {
            cache.add(aspect);
        }
        return aspect;
    }

    public IAspect createAspect(String aspectName) {
        if (logger.bePath()) {
            logger.pathT("entering: createAspect", "Aspect name: " + aspectName);
        }
        Aspect aspect = this.createAspectInCache(null, aspectName, null);
        this.createCacheForAspect(aspect);
        this.registerAspect(aspect);
        return aspect;
    }

    public IServiceModuleDescriptor getDescriptor() {
        if (logger.bePath()) {
            logger.pathT("entering: getDescriptor");
        }
        return this.srvMgrServiceModule.getDescriptor();
    }

    public void sendChanges() {
        if (logger.bePath()) {
            logger.pathT("entering: sendChanges");
        }
        Iterator it = ((AbstractList)this.cacheRootObjects).iterator();
        while (it.hasNext()) {
            AspectCache aspectCache = ((ICacheRootObject)it.next()).getAspectCache();
            Iterator aspectIt = aspectCache.iterator();
            while (aspectIt.hasNext()) {
                Aspect aspect = (Aspect)aspectIt.next();
                aspect.sendChanges();
            }
        }
    }

    void flush(String callingMethod) {
        if (logger.bePath()) {
            logger.pathT("entering: flush");
        }
        this.srvMgrServiceModule.getServiceManager().flush("GCP", callingMethod);
    }

    public void onServiceQueueWillBeFlushed() {
        if (logger.bePath()) {
            logger.pathT("entering: onServiceQueueWillBeFlushed");
        }
        Iterator it = ((AbstractList)this.cacheRootObjects).iterator();
        while (it.hasNext()) {
            ICacheRootObject rootObject = (ICacheRootObject)it.next();
            AspectCache aspectCache = rootObject.getAspectCache();
            Iterator aspectIt = aspectCache.iterator();
            while (aspectIt.hasNext()) {
                Aspect aspect = (Aspect)aspectIt.next();
                aspect.onServiceQueueWillBeFlushed();
            }
        }
        if (logger.beInfo()) {
            this.logCallList();
        }
    }

    public void onServiceQueueFlushed() {
        if (logger.bePath()) {
            logger.pathT("entering: onServiceQueueFlushed");
        }
        Iterator it = this.srvMgrCallObjects.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() != null) {
                List callList = (List)entry.getValue();
                ISrvMgrCall[] calls = callList.toArray(new ISrvMgrCall[callList.size()]);
                ((ISrvMgrCaller)entry.getKey()).onCallsProcessed(calls);
            } else {
                ((ISrvMgrCaller)entry.getKey()).onCallsProcessed(null);
            }
            it.remove();
        }
        if (this.refreshOfDirtySubTreesStarted) {
            return;
        }
        this.refreshOfDirtySubTreesStarted = true;
        it = ((AbstractList)this.cacheRootObjects).iterator();
        while (it.hasNext()) {
            ICacheRootObject rootObject = (ICacheRootObject)((Object)it.next());
            AspectCache cache = rootObject.getAspectCache();
            if (cache.isDirty()) {
                logger.infoT("onServiceQueueFlushed", "Complete Cache is refreshed");
                rootObject.refresh();
                cache.setDirty(false);
                continue;
            }
            if (!cache.isDirtySubTree()) continue;
            Iterator treeIt = cache.iterateDirtySubTrees();
            while (treeIt.hasNext()) {
                IAspect rootOfTree = (IAspect)treeIt.next();
                logger.infoT("onServiceQueueFlushed", "Sub tree of Cache starting with Aspect '" + rootOfTree.getDescriptor().getName() + "' is refershed");
                rootOfTree.refresh();
            }
            cache.resetDirtySubTrees();
        }
        this.refreshOfDirtySubTreesStarted = false;
    }

    protected ISrvMgrServiceModule getSrvMgrServiceModule() {
        return this.srvMgrServiceModule;
    }

    public ICMIModelInfo associatedModelInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModelInfo");
        }
        if (this.modelInfo == null) {
            this.modelInfo = new ColModelInfo(this.getDescriptor());
        }
        return this.modelInfo;
    }

    public ICMIModelClass createModelObject(String modelClassName) {
        throw new UnsupportedOperationException();
    }

    public ICMIModelClass createModelObject(Class modelClassClazz) {
        throw new UnsupportedOperationException();
    }

    public String getModelName() {
        if (logger.bePath()) {
            logger.pathT("entering: getModelName", "Model name: " + this.associatedModelInfo().getName());
        }
        return this.associatedModelInfo().getName();
    }

    void removeCacheRootObject(ICacheRootObject cacheRootObject) {
        ((AbstractCollection)this.cacheRootObjects).remove(cacheRootObject);
    }

    public String getModelInstanceId() {
        return null;
    }

    public IKeyList createKeyList(String keyName) {
        IKeyAspectDescriptor keyDescriptor;
        if (logger.bePath()) {
            logger.pathT("entering: createKeyList", "Key name: " + keyName);
        }
        if ((keyDescriptor = this.getDescriptor().getKeyAspectDescriptor(keyName)) == null) {
            logger.fatalT(" Key with name " + keyName + " doesn't exist");
            throw new IllegalArgumentException(" Key with name " + keyName + " doesn't exist");
        }
        return new KeyList(keyDescriptor);
    }

    public IKey createKey(String keyName, String[] keyFields) {
        IKeyAspectDescriptor keyDescriptor;
        if (logger.bePath()) {
            logger.pathT("entering: createKey", "Key name: " + keyName);
        }
        if ((keyDescriptor = this.getDescriptor().getKeyAspectDescriptor(keyName)) == null) {
            logger.fatalT(" Key with name " + keyName + " doesn't exist");
            throw new IllegalArgumentException(" Key with name " + keyName + " doesn't exist");
        }
        if (keyFields == null) {
            logger.fatalT(" Array with key fields must not be null!");
            throw new IllegalArgumentException(" Array with key fields must not be null!");
        }
        return new Key(keyDescriptor, keyFields);
    }

    public IAspect getAspect(String aspectName, IKeyList keyList) {
        return this.getAspect(null, aspectName, keyList, null);
    }

    public IAspect getAspect(String aspectName, IKeyList keyList, LockStrategy lockStrategy) {
        if (keyList == null || keyList.size() == 0) {
            throw new IllegalArgumentException("parameter 'keyList' is null or of size 0");
        }
        return this.getAspect(null, aspectName, keyList, lockStrategy);
    }

    public IAspect getAspect(String aspectName, String[] urlOfKeys, LockStrategy lockStrategy) {
        if (urlOfKeys == null || urlOfKeys.length == 0) {
            throw new IllegalArgumentException("parameter 'urlOfKeys' is null or of size 0");
        }
        IAspectDescriptor aspectDescriptor = this.getDescriptor().getAspectDescriptor(aspectName);
        if (aspectDescriptor == null) {
            throw new IllegalArgumentException("Aspect with name '" + aspectName + "' is not known in ServiceModule " + this.getDescriptor().getName());
        }
        List keyList = null;
        int i = 0;
        while (i < urlOfKeys.length) {
            String[] urlFields = this.parseUrlKey(aspectDescriptor, urlOfKeys[i]);
            IKey key = this.createKey(aspectDescriptor.getKeyDescriptor().getName(), urlFields);
            if (keyList == null) {
                keyList = this.createKeyList(aspectDescriptor.getKeyDescriptor().getName());
            }
            keyList.add(key);
            ++i;
        }
        return this.getAspect(aspectName, (IKeyList)keyList, lockStrategy);
    }

    private String[] parseUrlKey(IAspectDescriptor aspectDescriptor, String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, "/", false);
        int noOfTokens = tokenizer.countTokens();
        if (noOfTokens < 3) {
            throw new IllegalArgumentException("Key URL '" + string + "' has no valid format!");
        }
        String[] keyFields = new String[noOfTokens - 2];
        String keyName = tokenizer.nextToken();
        if (!keyName.equals(aspectDescriptor.getKeyDescriptor().getName())) {
            throw new IllegalArgumentException("Key with name '" + keyName + "' doesn't correspond to Aspect '" + aspectDescriptor.getName());
        }
        String keyToken = tokenizer.nextToken();
        if (!keyToken.equals("1KEY")) {
            throw new IllegalArgumentException("Key URL '" + string + "' has no valid format!");
        }
        int counter = 0;
        while (tokenizer.hasMoreTokens()) {
            keyFields[counter++] = tokenizer.nextToken();
        }
        return keyFields;
    }

    public IAspect getAspect(String aspectName, String[] urlOfKeys) {
        return this.getAspect(aspectName, urlOfKeys, (LockStrategy)null);
    }

    IAspect getAspect(Aspect sourceAspect, String aspectName, IKeyList keyList, LockStrategy lockStrategy) {
        Aspect targetAspect;
        AspectCache cache;
        if (logger.bePath()) {
            logger.pathT("entering: getAspect", "Aspect name: " + aspectName + " KeyList: " + keyList + " LockStrategy: " + lockStrategy);
        }
        AspectCache aspectCache = cache = sourceAspect == null ? null : sourceAspect.getAspectCache();
        if (keyList.getDescriptor().getName().equals(aspectName)) {
            if (sourceAspect != null && sourceAspect.getState() == 1) {
                targetAspect = (Aspect)this.createKeysAspectInternal(keyList.getDescriptor(), null);
                ISrvMgrCopyCorresponding copyCall = this.srvMgrServiceModule.createCopyCorresponding(sourceAspect.getName(), keyList.getDescriptor().getName());
                copyCall.setInRecords(sourceAspect.getCreateAspectCall().getOutRecords());
                targetAspect.refreshCreateAspectCall((ISrvMgrCall)copyCall);
                this.registerSrvMgrCallObject((ISrvMgrCall)copyCall, targetAspect);
            } else {
                targetAspect = (Aspect)this.createKeysAspectInternal(keyList.getDescriptor(), keyList);
            }
            if (cache != null) {
                cache.add(targetAspect);
            }
        } else {
            ISrvMgrSelect selectCall = this.getSrvMgrServiceModule().createSelect(aspectName);
            if (sourceAspect != null && sourceAspect.getState() == 1) {
                ISrvMgrCopyCorresponding copyCall = this.srvMgrServiceModule.createCopyCorresponding(sourceAspect.getName(), keyList.getDescriptor().getName());
                copyCall.setInRecords(sourceAspect.getCreateAspectCall().getOutRecords());
                this.registerSrvMgrCallObject((ISrvMgrCall)copyCall, null);
                selectCall.setInKeys(copyCall.getOutRecords());
            } else {
                GenericClientUtils.copyFromKeyListToTable(keyList, selectCall.getInKeys());
            }
            if (lockStrategy != null) {
                int lockMode = LockState.getLockModeFromStrategy(this.getDescriptor().getAspectDescriptor(aspectName), lockStrategy);
                selectCall.setLockMode(lockMode);
            }
            targetAspect = this.createAspectInCache(cache, aspectName, (ISrvMgrCall)selectCall);
            targetAspect.setLockingStrategy(lockStrategy);
            this.registerSrvMgrCallObject((ISrvMgrCall)selectCall, targetAspect);
        }
        if (cache == null) {
            this.createCacheForAspect(targetAspect);
            targetAspect.updateSourceKeyList(keyList);
        }
        return targetAspect;
    }

    private void createCacheForAspect(Aspect targetAspect) {
        AspectCache aspectCache = new AspectCache(targetAspect);
        this.cacheRootObjects.add(targetAspect);
        targetAspect.setCacheRootObject(true);
        aspectCache.add(targetAspect);
        targetAspect.bindAspectCache(aspectCache);
    }

    protected void registerSrvMgrCallObject(ISrvMgrCall srvMgrCallObject, ISrvMgrCaller callingObject) {
        srvMgrCallObject.processCall();
        if (callingObject == null) {
            return;
        }
        ArrayList<ISrvMgrCall> srvMgrCallList = (ArrayList<ISrvMgrCall>)this.srvMgrCallObjects.get(callingObject);
        if (srvMgrCallList == null) {
            srvMgrCallList = new ArrayList<ISrvMgrCall>();
            this.srvMgrCallObjects.put(callingObject, srvMgrCallList);
        }
        if (!srvMgrCallList.contains(srvMgrCallObject)) {
            srvMgrCallList.add(srvMgrCallObject);
        }
    }

    protected IAspect createAspectInternal(IAspectDescriptor aspectDescriptor, ISrvMgrCall initialCall) {
        return new Aspect(this, aspectDescriptor, initialCall);
    }

    protected final IAspect createKeysAspectInternal(IKeyAspectDescriptor keyDescriptor, IKeyList keyList) {
        Aspect aspect = (Aspect)this.createAspectInternal((IAspectDescriptor)keyDescriptor, null);
        aspect.initFromKeyList(keyList);
        return aspect;
    }

    protected IQuery createQueryInternal(IQueryDescriptor queryDescriptor) {
        return new Query(queryDescriptor, this);
    }

    protected IValueSet createValueSetInternal(IValueSetDescriptor valueSetDescriptor) {
        return new ValueSet(valueSetDescriptor, this);
    }

    protected IAction createActionInternal(IAspectActionDescriptor actionDescriptor, Aspect owner) {
        return new Action(actionDescriptor, owner);
    }

    protected IStructure createStructureInternal(IStructureDescriptor structureDescriptor, IEdoStructure edoStructure) {
        return new Structure(this, edoStructure);
    }

    public void setDebug(boolean enabled, String guiHost) {
        if (logger.bePath()) {
            logger.pathT("entering: setDebug");
        }
        this.srvMgrServiceModule.getServiceManager().setDebug(enabled, this.srvMgrServiceModule.getDescriptor().getName(), guiHost);
    }

    protected void registerAspect(Aspect aspect) {
    }

    void unregisterAspect(Aspect aspect) {
    }

    void unregisterAspectRowKey(Aspect aspect, Key key) {
    }

    void logCallList() {
        Iterator it = this.srvMgrCallObjects.entrySet().iterator();
        int noOfCalls = 0;
        logger.infoT("onServiceQueueWillBeFlushed", "ServiceModule: " + this.getDescriptor().getName());
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ISrvMgrCaller caller = (ISrvMgrCaller)entry.getKey();
            List callList = (List)entry.getValue();
            String callListString = "";
            Iterator callIt = callList.iterator();
            while (callIt.hasNext()) {
                ISrvMgrCall call = (ISrvMgrCall)callIt.next();
                callListString = callListString + GenericClientUtils.getUnqualifiedClassName(call.getClass().getName()) + ",";
                ++noOfCalls;
            }
            logger.infoT("onServiceQueueWillBeFlushed", "Calling Object: '" + caller.getName() + "' Calls: '" + callListString + "'");
        }
        logger.infoT("onServiceQueueWillBeFlushed", "Number of Calls: " + noOfCalls);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/ServiceModule.java#2 $");
    }
}

