/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IStructureList;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.generic.core.AbstractModelClass;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.client.generic.core.AspectCache;
import com.sap.tc.col.client.generic.core.ColModelInfo;
import com.sap.tc.col.client.generic.core.GenericClientUtils;
import com.sap.tc.col.client.generic.core.ICacheRootObject;
import com.sap.tc.col.client.generic.core.ISrvMgrCaller;
import com.sap.tc.col.client.generic.core.KeyList;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.generic.core.Structure;
import com.sap.tc.col.client.generic.core.StructureList;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrQuery;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;

public class Query
extends AbstractModelClass
implements IQuery,
ICacheRootObject,
ISrvMgrCaller {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$Query == null ? (class$com$sap$tc$col$client$generic$core$Query = Query.class$("com.sap.tc.col.client.generic.core.Query")) : class$com$sap$tc$col$client$generic$core$Query));
    private final ICMIModelClassInfo modelClassInfo;
    private final IQueryDescriptor descriptor;
    private final Structure inputParameter;
    private Aspect result;
    private IKeyList inputKeyList;
    private final ServiceModule serviceModule;
    private AspectCache aspectCache;
    private final ISrvMgrQuery srvMgrQuery;
    private SortingCriteria sortingCriteria;
    private final StructureList selectOptions;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$Query;

    protected Query(IQueryDescriptor descriptor, ServiceModule serviceModule) {
        if (serviceModule == null) {
            throw new IllegalArgumentException("ServiceModule must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("QueryDescriptor must not be null");
        }
        this.descriptor = descriptor;
        this.serviceModule = serviceModule;
        this.srvMgrQuery = serviceModule.getSrvMgrServiceModule().createQuery(this.getDescriptor().getName());
        if (descriptor.hasInputKeys()) {
            this.inputKeyList = (KeyList)serviceModule.createKeyList(descriptor.getInputKeysDescriptor().getName());
        }
        if (descriptor.hasInputParameters()) {
            this.inputParameter = (Structure)serviceModule.createStructureInternal(descriptor.getInputParameters(), this.srvMgrQuery.getInParameters());
            this.selectOptions = new StructureList(descriptor.getSelections(), serviceModule, null);
        } else {
            this.inputParameter = null;
            this.selectOptions = null;
        }
        this.modelClassInfo = ((ColModelInfo)serviceModule.associatedModelInfo()).getOrCreateModelClassInfo(descriptor);
    }

    public ICMIModel associatedModel() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModel", "Model name: " + this.serviceModule.getDescriptor().getName());
        }
        return this.serviceModule;
    }

    public ICMIModelClassInfo associatedModelClassInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModelClassInfo", "Query name: " + this.descriptor.getName());
        }
        return this.modelClassInfo;
    }

    public void execute() {
        if (logger.bePath()) {
            logger.pathT("entering: execute", "Query name: " + this.descriptor.getName());
        }
        if (this.result != null) {
            this.srvMgrQuery.reset();
        }
        if (this.inputParameter != null) {
            this.srvMgrQuery.setInParameters(this.inputParameter.getEdoStructure());
        }
        if (this.selectOptions != null) {
            GenericClientUtils.copyFromStructureListToEdoTable(this.selectOptions, this.srvMgrQuery.getInSelections());
        }
        if (this.inputKeyList != null && !this.inputKeyList.isEmpty()) {
            GenericClientUtils.copyFromKeyListToTable(this.inputKeyList, this.srvMgrQuery.getInKeys());
        }
        if (this.sortingCriteria != null) {
            GenericClientUtils.copyFromSortingCriteriaToCall(this.sortingCriteria, this.srvMgrQuery.getInSortingOptions());
        }
        this.serviceModule.registerSrvMgrCallObject((ISrvMgrCall)this.srvMgrQuery, this);
        if (this.result == null) {
            this.result = this.serviceModule.createAspectInCache(null, this.descriptor.getResultAspectDescriptor().getName(), (ISrvMgrCall)this.srvMgrQuery);
            this.result.setCallingQuery(this);
            this.aspectCache.add(this.result);
        } else {
            this.result.setState(1);
            this.result.refreshSubTree();
            this.result.resetSourceKeyList();
        }
        if (this.inputParameter != null) {
            this.inputParameter.makeClean();
        }
    }

    public IQueryDescriptor getDescriptor() {
        if (logger.bePath()) {
            logger.pathT("entering: getDescriptor", "Query name: " + this.descriptor.getName());
        }
        return this.descriptor;
    }

    public IAspect getResultAspect() {
        if (logger.bePath()) {
            logger.pathT("entering: getResultAspect", "Query name: " + this.descriptor.getName());
        }
        return this.result;
    }

    public Object getInputParameter() {
        if (logger.bePath()) {
            logger.pathT("entering: getInputParameter", "Query name: " + this.descriptor.getName());
        }
        return this.inputParameter;
    }

    public Collection getResult() {
        if (logger.bePath()) {
            logger.pathT("entering: getResult", "Query name: " + this.descriptor.getName());
        }
        return this.result;
    }

    public IStructure getInputParameterStructure() {
        if (logger.bePath()) {
            logger.pathT("entering: getInputParameterStructure", "Query name: " + this.descriptor.getName());
        }
        if (this.inputParameter == null) {
            throw new UnsupportedOperationException("Query '" + this.descriptor.getName() + "'doesn't support input parameter!");
        }
        return this.inputParameter;
    }

    public IKeyList getInputKeyList() {
        if (logger.bePath()) {
            logger.pathT("entering: getInputKeyList", "Query name: " + this.descriptor.getName());
        }
        return this.inputKeyList;
    }

    public void invalidate() {
        if (logger.bePath()) {
            logger.pathT("entering: invalidate", "Query name: " + this.descriptor.getName());
        }
        if (this.result != null) {
            this.result.invalidateInternal();
            this.result = null;
            this.srvMgrQuery.reset();
        }
        this.aspectCache.clear();
    }

    public void refresh() {
        if (logger.bePath()) {
            logger.pathT("entering: refresh", "Query name: " + this.descriptor.getName());
        }
        if (this.result != null) {
            this.result.refresh();
            this.srvMgrQuery.reset();
        }
    }

    public ICMIModelClass getRelatedModelObject(String rolename) {
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedModelObject", "Query name: " + this.descriptor.getName() + " rolename: " + rolename);
        }
        if (rolename.equalsIgnoreCase("inputParameter") || rolename.equals("com.sap.tc.cmi:queryInputParameter")) {
            return (ICMIModelClass)this.getInputParameter();
        }
        return super.getRelatedModelObject(rolename);
    }

    public Collection getRelatedModelObjects(String rolename) {
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedModelObjects", "Query name: " + this.descriptor.getName() + " rolename: " + rolename);
        }
        if (rolename.equalsIgnoreCase("result") || rolename.equals("com.sap.tc.cmi:queryResult")) {
            return this.result;
        }
        if (rolename.equalsIgnoreCase("selectOptions")) {
            if (this.selectOptions != null) {
                return this.selectOptions;
            }
            return new ArrayList();
        }
        return super.getRelatedModelObjects(rolename);
    }

    protected void bindAspectCache(AspectCache aspectCache) {
        this.aspectCache = aspectCache;
    }

    public boolean isCacheRootObject() {
        return true;
    }

    public AspectCache getAspectCache() {
        return this.aspectCache;
    }

    public void onCallsProcessed(ISrvMgrCall[] calls) {
        if (logger.bePath()) {
            logger.pathT("entering: onCallsProcessed", "Query name: " + this.getName());
        }
        if (this.result != null) {
            this.result.onCallsProcessed(calls);
        }
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public ICMIModelClassInfo associatedInputParameterInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedInputParameterInfo", "Query name: " + this.getName());
        }
        return this.modelClassInfo.getRelatedModelClassInfo("inputParameter");
    }

    public ICMIModelObjectCollectionInfo associatedResultInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedResultInfo", "Query name: " + this.getName());
        }
        return ((ColModelInfo)this.modelClassInfo.getModelInfo()).getOrCreateModelObjectCollectionInfo(this.descriptor.getResultAspectDescriptor());
    }

    public long countOf() {
        return -1L;
    }

    public boolean isDirty() {
        return this.result == null || this.inputParameter != null && this.inputParameter.isDirty();
    }

    public void setSortingCriteria(SortingCriteria sorting) {
        if (logger.bePath()) {
            logger.pathT("entering: setSortingCriteria", "Query name: " + this.getName());
        }
        this.sortingCriteria = sorting;
    }

    protected void setResult(Aspect aspect) {
        this.result = aspect;
    }

    public IStructureList getSelectOptions() {
        if (logger.bePath()) {
            logger.pathT("entering: getSelectOptions", "Query name: " + this.getName());
        }
        return this.selectOptions;
    }

    public IStructure createSelectOption(String fieldName) {
        IStructureDescriptor structureDescriptor;
        if (logger.bePath()) {
            logger.pathT("entering: createSelectOption", "Query name: " + this.getName() + " Field name: " + fieldName);
        }
        if ((structureDescriptor = this.descriptor.getInputParameters()) == null || !structureDescriptor.hasField(fieldName)) {
            throw new IllegalArgumentException("Field with name '" + fieldName + "' is no valid input parameter field for Query " + this.descriptor.getName());
        }
        if (!this.inputParameter.getEdoStructure().isInitial(fieldName)) {
            throw new IllegalArgumentException("Field with name '" + fieldName + "' should not be used as input parameter and select options for Query " + this.descriptor.getName());
        }
        IEdoStructure edoStructure = this.serviceModule.getSrvMgrServiceModule().createStructure(this.selectOptions.getDescriptor());
        Structure selectOption = new Structure(this.serviceModule, edoStructure);
        selectOption.setAttributeValue("FIELDNAME", (Object)fieldName);
        this.selectOptions.add(selectOption);
        return selectOption;
    }

    public IStructure createSelectOption(String fieldName, String operator, String from, String to) {
        if (logger.bePath()) {
            logger.pathT("entering: createSelectOption", "Query name: " + this.getName() + " Field name: " + fieldName + " operator: " + operator + " from: " + from + " to: " + to);
        }
        IStructure selectOption = this.createSelectOption(fieldName);
        selectOption.setAttributeValue("OPTION", (Object)operator);
        selectOption.setAttributeValue("LOW", (Object)from);
        if (to != null) {
            selectOption.setAttributeValue("HIGH", (Object)to);
        }
        return selectOption;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/Query.java#2 $");
    }
}

