/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.client.generic.core.AspectRow;
import com.sap.tc.col.client.generic.core.Key;
import com.sap.tc.col.client.generic.core.Message;
import com.sap.tc.col.client.generic.core.ServiceFacade;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider;
import java.util.ArrayList;
import java.util.List;

public class MessageList
implements IMessageList {
    private final List messages = new ArrayList();
    private final ISrvMgrMessageProvider messageProvider;

    protected MessageList(ISrvMgrMessageProvider messageProvider, Aspect aspect) {
        this.messageProvider = messageProvider;
        ISrvMgrMessage[] srvMgrMessages = messageProvider.getAspectMessages(aspect.getDescriptor().getName(), true);
        int i = 0;
        while (i < srvMgrMessages.length) {
            this.messages.add(new Message(srvMgrMessages[i], aspect.getServiceModule()));
            ++i;
        }
    }

    protected MessageList(ISrvMgrMessageProvider messageProvider, AspectRow row) {
        this.messageProvider = messageProvider;
        ISrvMgrMessage[] srvMgrMessages = messageProvider.getAspectRowMessages(row.getRelativeKeyUrl());
        int i = 0;
        while (i < srvMgrMessages.length) {
            this.messages.add(new Message(srvMgrMessages[i], row.getAspect().getServiceModule()));
            ++i;
        }
    }

    protected MessageList(ISrvMgrMessageProvider messageProvider, ServiceFacade sf, boolean all) {
        this.messageProvider = messageProvider;
        ISrvMgrMessage[] srvMgrMessages = null;
        srvMgrMessages = all ? messageProvider.getMessages() : messageProvider.getAndClearSystemMessages();
        int i = 0;
        while (i < srvMgrMessages.length) {
            if (srvMgrMessages[i].getCategory() == 1) {
                this.messages.add(new Message(srvMgrMessages[i], sf.getServiceModuleForAspect(srvMgrMessages[i].getCoolObjectKey().getAspect())));
            } else {
                this.messages.add(new Message(srvMgrMessages[i], null));
            }
            ++i;
        }
    }

    public IMessage getMessage(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return (IMessage)this.messages.get(index);
    }

    public boolean removeMessage(IMessage message) {
        this.messageProvider.removeMessage(((Message)message).getMsg());
        return this.messages.remove(message);
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public int size() {
        return this.messages.size();
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer("<MessageList>").append(nl);
        int i = 0;
        while (i < this.size()) {
            buf.append("  ").append(this.getMessage(i)).append(nl);
            ++i;
        }
        buf.append("</MessageList>");
        return buf.toString();
    }

    public void clear() {
        if (!this.messages.isEmpty()) {
            this.messageProvider.removeMessages(this.toArray(this.messages));
        }
        this.messages.clear();
    }

    private ISrvMgrMessage[] toArray(List messageList) {
        ISrvMgrMessage[] srvMgrMsgArray = new ISrvMgrMessage[messageList.size()];
        int i = 0;
        while (i < messageList.size()) {
            Message message = (Message)messageList.get(i);
            srvMgrMsgArray[i] = message.getMsg();
            ++i;
        }
        return srvMgrMsgArray;
    }

    private IKey createKeyFromMessage(ISrvMgrMessage msg, IKeyAspectDescriptor keyDescriptor) {
        String[] keyFields = msg.getCoolObjectKey().getFieldValues();
        if (keyFields == null || keyFields.length == 0) {
            return null;
        }
        if (keyDescriptor.getStructure().size() != keyFields.length) {
            return null;
        }
        return new Key(keyDescriptor, keyFields);
    }
}

