/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.client.generic.api.ILockState;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.client.generic.core.AspectRow;
import com.sap.tc.col.client.generic.core.LockCache;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import java.util.AbstractList;
import java.util.Iterator;

class LockState
implements ILockState {
    private Boolean resultOfLastSharedLockCall;
    private Boolean resultOfLastSPLockCall;
    private Boolean resultOfLastExclusiveLockCall;
    private LockStrategy lockStrategy;

    LockState() {
    }

    public boolean hasLock() {
        return this.hasExclusiveLock() || this.hasSharedPromotableLock() || this.hasSharedLock();
    }

    public boolean hasLockFailed() {
        return this.hasExclusiveLockFailed() || this.hasSharedPromotableLockFailed() || this.hasSharedLockFailed();
    }

    public boolean hasExclusiveLock() {
        if (this.resultOfLastExclusiveLockCall != null) {
            return this.resultOfLastExclusiveLockCall;
        }
        return false;
    }

    public boolean hasExclusiveLockFailed() {
        if (this.resultOfLastExclusiveLockCall != null) {
            return this.resultOfLastExclusiveLockCall == false;
        }
        return false;
    }

    public boolean hasSharedPromotableLock() {
        if (this.resultOfLastSPLockCall != null) {
            return this.resultOfLastSPLockCall;
        }
        return false;
    }

    public boolean hasSharedPromotableLockFailed() {
        if (this.resultOfLastSPLockCall != null) {
            return this.resultOfLastSPLockCall == false;
        }
        return false;
    }

    public boolean hasSharedLock() {
        if (this.resultOfLastSharedLockCall != null) {
            return this.resultOfLastSharedLockCall;
        }
        return false;
    }

    public boolean hasSharedLockFailed() {
        if (this.resultOfLastSharedLockCall != null) {
            return this.resultOfLastSharedLockCall == false;
        }
        return false;
    }

    public boolean isEditable() {
        return this.hasSharedPromotableLock() || this.hasExclusiveLock() || this.hasSharedLock() && this.lockStrategy == LockStrategy.SHARED_WITH_EXCLUSIVE_LOCK_ON_UPDATE;
    }

    void clearLocks() {
        this.resultOfLastExclusiveLockCall = null;
        this.resultOfLastSPLockCall = null;
        this.resultOfLastSharedLockCall = null;
        this.lockStrategy = null;
    }

    LockStrategy getLockStrategy() {
        return this.lockStrategy;
    }

    void setLockStrategy(LockStrategy lockStrategy) {
        this.lockStrategy = lockStrategy;
    }

    void setLockResult(AspectRow row, int lockMode, LockStrategy strategy, boolean failed) {
        LockCache cache;
        if (this.lockStrategy == null) {
            this.lockStrategy = strategy;
        }
        if (lockMode == 1) {
            this.resultOfLastExclusiveLockCall = new Boolean(!failed);
            if (this.lockStrategy == LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE && failed) {
                this.resultOfLastSPLockCall = null;
                cache = ((ServiceModule)row.getAspect().getServiceModule()).getServiceFacade().getLockCache();
                cache.removeLock(((Aspect)row.getAspect()).getName(), row.getKey());
            }
        } else if (lockMode == 2) {
            this.resultOfLastSharedLockCall = new Boolean(!failed);
        } else if (lockMode == 3) {
            this.resultOfLastSPLockCall = new Boolean(!failed);
        }
        if (!failed) {
            cache = ((ServiceModule)row.getAspect().getServiceModule()).getServiceFacade().getLockCache();
            cache.addLock(((Aspect)row.getAspect()).getName(), row);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getLockModeFromStrategy(IAspectDescriptor aspectDescriptor, LockStrategy lockStrategy) {
        int lockMode = 0;
        if (lockStrategy == LockStrategy.SHARED_PROMOTABLE_WITH_LOCK_PROMOTION_ON_UPDATE) {
            if (LockState.isSupportedLock(aspectDescriptor, 3)) {
                return 3;
            }
            if (!LockState.isSupportedLock(aspectDescriptor, 1)) throw new IllegalStateException("To use lock strategy '" + lockStrategy + "' Aspect '" + aspectDescriptor.getName() + "' must support E or SP locks!");
            return 1;
        }
        if (lockStrategy == LockStrategy.EXCLUSIVE) {
            if (!LockState.isSupportedLock(aspectDescriptor, 1)) throw new IllegalStateException("To use lock strategy '" + lockStrategy + "' Aspect '" + aspectDescriptor.getName() + "' must support Exclusive locks!");
            return 1;
        }
        if (lockStrategy == LockStrategy.SHARED_WITH_EXCLUSIVE_LOCK_ON_UPDATE) {
            if (LockState.isSupportedLock(aspectDescriptor, 2)) {
                return 2;
            }
            if (!LockState.isSupportedLock(aspectDescriptor, 1)) throw new IllegalStateException("To use lock strategy '" + lockStrategy + "' Aspect '" + aspectDescriptor.getName() + "' must support S or E locks!");
            return 1;
        }
        if (lockStrategy != LockStrategy.SHARED_READ_ONLY) return lockMode;
        if (!LockState.isSupportedLock(aspectDescriptor, 2)) throw new IllegalStateException("To use lock strategy '" + lockStrategy + "' Aspect '" + aspectDescriptor.getName() + "' must support Shared locks!");
        return 2;
    }

    static boolean isSupportedLock(IAspectDescriptor aspectDescriptor, int i) {
        try {
            if (i == 1) {
                return aspectDescriptor.getAttributeLockmodeExclusive();
            }
            if (i == 2) {
                return aspectDescriptor.getAttributeLockmodeShared();
            }
            if (i == 3) {
                return aspectDescriptor.getAttributeLockmodeSharedPromotable();
            }
            return false;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    static void checkLockConsistenceOfAspect(Aspect aspect, LockStrategy lockStrategy) {
        Iterator it = ((AbstractList)((Object)aspect)).iterator();
        while (it.hasNext()) {
            AspectRow aspectRow = (AspectRow)it.next();
            LockState lockState = aspectRow.getLockStateInternal();
            if (!lockState.hasLock() || lockState.getLockStrategy() == lockStrategy) continue;
            throw new IllegalStateException("Changing lock strategy from '" + lockState.getLockStrategy() + "' to '" + lockStrategy + "' not allowed in one transaction (Aspect: '" + aspect.getName() + "' AspectRow: " + aspectRow.getKey() + ")");
        }
    }
}

