/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.core.AspectRow;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LockCache {
    private Map aspectLocks = new HashMap();
    private Set aspectRowChanges = new HashSet();

    void registerChangedAspectRow(AspectRow aspectRow) {
        this.aspectRowChanges.add(aspectRow);
    }

    void clearChangedAspectRows() {
        Iterator it = this.aspectRowChanges.iterator();
        while (it.hasNext()) {
            AspectRow row = (AspectRow)it.next();
            row.setFlushedChangesInTransaction(false);
        }
        this.aspectRowChanges.clear();
    }

    void addLock(String aspectName, AspectRow aspectRow) {
        HashSet<AspectRow> aspectRows;
        HashMap<IKey, HashSet<AspectRow>> keyLocks = (HashMap<IKey, HashSet<AspectRow>>)this.aspectLocks.get(aspectName);
        if (keyLocks == null) {
            keyLocks = new HashMap<IKey, HashSet<AspectRow>>();
            this.aspectLocks.put(aspectName, keyLocks);
        }
        if ((aspectRows = (HashSet<AspectRow>)keyLocks.get(aspectRow.getKey())) == null) {
            aspectRows = new HashSet<AspectRow>();
            keyLocks.put(aspectRow.getKey(), aspectRows);
        }
        aspectRows.add(aspectRow);
    }

    void removeLock(String aspectName, IKey key) {
        HashMap keyLocks = (HashMap)this.aspectLocks.get(aspectName);
        if (keyLocks == null) {
            return;
        }
        HashSet aspectRows = (HashSet)keyLocks.get(key);
        if (aspectRows == null) {
            return;
        }
        keyLocks.remove(key);
        Iterator it = aspectRows.iterator();
        while (it.hasNext()) {
            AspectRow aspectRow = (AspectRow)it.next();
            aspectRow.getLockStateInternal().clearLocks();
        }
        aspectRows.clear();
    }

    void removeAllLocks() {
        Iterator it = this.aspectLocks.values().iterator();
        while (it.hasNext()) {
            HashMap keyLocks = (HashMap)it.next();
            Iterator keyIterator = keyLocks.values().iterator();
            while (keyIterator.hasNext()) {
                HashSet aspectRows = (HashSet)keyIterator.next();
                Iterator rowIterator = aspectRows.iterator();
                while (rowIterator.hasNext()) {
                    AspectRow aspectRow = (AspectRow)rowIterator.next();
                    aspectRow.getLockStateInternal().clearLocks();
                }
            }
        }
        this.aspectLocks.clear();
    }
}

