/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.client.generic.core.AspectRow;
import com.sap.tc.col.client.generic.core.Key;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.generic.core.StructureList;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrAction;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrDelete;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrInsert;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrLock;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelect;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelectByRelation;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUnlock;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUpdateRow;
import com.sap.tc.logging.Location;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;

public class GenericClientUtils {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$GenericClientUtils == null ? (class$com$sap$tc$col$client$generic$core$GenericClientUtils = GenericClientUtils.class$("com.sap.tc.col.client.generic.core.GenericClientUtils")) : class$com$sap$tc$col$client$generic$core$GenericClientUtils));
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$GenericClientUtils;

    static void selectAspectFromKeys(Aspect target, IKeyList keyList, int lockMode, ISrvMgrSelect selectCall) {
        target.setState(0);
        if (logger.bePath()) {
            logger.pathT("entering: selectAspectFromKeys", "Aspect name: " + target.getName() + " KeyList: " + keyList);
        }
        ServiceModule serviceModule = (ServiceModule)target.getServiceModule();
        if (selectCall == null) {
            selectCall = serviceModule.getSrvMgrServiceModule().createSelect(target.getName());
        } else {
            selectCall.reset();
        }
        selectCall.setLockMode(lockMode);
        GenericClientUtils.copyFromKeyListToTable(keyList, selectCall.getInKeys());
        target.refreshCreateAspectCall((ISrvMgrCall)selectCall);
        serviceModule.registerSrvMgrCallObject((ISrvMgrCall)selectCall, target);
    }

    protected static void copyFromKeyListToTable(IKeyList inputKeyList, IEdoTable outTable) {
        if (logger.bePath()) {
            logger.pathT("entering: copyFromKeyListToTable", " KeyList: " + inputKeyList);
        }
        IStructureDescriptor descriptor = inputKeyList.getDescriptor().getStructure();
        int i = 0;
        while (i < inputKeyList.size()) {
            Key key = (Key)inputKeyList.getKey(i);
            if (!key.isLocalKey()) {
                outTable.append(1);
                String[] keyFields = key.getKeyFields();
                int j = 0;
                while (j < descriptor.size()) {
                    outTable.setStringValue(i, j, keyFields[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected static void copyKeysAndFieldsToCall(Aspect aspect, Map changedRows, IEdoTable inFields) {
        if (logger.bePath()) {
            logger.pathT("entering: copyKeysAndFieldsToCall", " Aspect name: " + aspect.getName());
        }
        IStructureDescriptor descriptor = aspect.getDescriptor().getStructure();
        Iterator it = changedRows.entrySet().iterator();
        int counter = 0;
        int noOfKey = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            BitSet fields = (BitSet)entry.getValue();
            int i = 0;
            while (i < descriptor.size()) {
                if (fields.get(i)) {
                    inFields.append(1);
                    String fieldName = descriptor.getFieldDescriptor(i).getName();
                    String inKeyAsString = String.valueOf(noOfKey);
                    inFields.setStringValue(counter, "INKEY", inKeyAsString);
                    inFields.setStringValue(counter, "FIELDNAME", fieldName);
                    ++counter;
                }
                ++i;
            }
            ++noOfKey;
        }
    }

    protected static void copyFromKeyToTable(Key key, IEdoTable outTable, int rowIndex) {
        if (logger.bePath()) {
            logger.pathT("entering: copyFromKeyToTable", " Key: " + key + " Index: " + rowIndex);
        }
        IStructureDescriptor descriptor = key.getKeyDescriptor().getStructure();
        outTable.append(1);
        String[] keyFields = key.getKeyFields();
        int j = 0;
        while (j < descriptor.size()) {
            outTable.setStringValue(rowIndex, j, keyFields[j]);
            ++j;
        }
    }

    protected static IKey getKeyFromTable(IEdoTable table, IKeyAspectDescriptor keyDescriptor, int row) {
        if (logger.bePath()) {
            logger.pathT("entering: getKeyFromTable");
        }
        int nKeyFields = keyDescriptor.getStructure().size();
        String[] keyFields = new String[nKeyFields];
        int i = 0;
        while (i < nKeyFields) {
            String fieldName = keyDescriptor.getStructure().getFieldDescriptor(i).getName();
            int fieldIndex = table.getDescriptor().getFieldIndex(fieldName);
            keyFields[i] = table.getStringValue(row, fieldIndex);
            ++i;
        }
        return new Key(keyDescriptor, keyFields);
    }

    static void setOutRecordsToAspect(Aspect aspect, IEdoTable outRecords, ISrvMgrCall call) {
        if (logger.bePath()) {
            logger.pathT("entering: setOutRecordsToAspect", "Aspect name: " + aspect.getName());
        }
        aspect.setState(5);
        IEdoTable lockResults = null;
        int lockMode = 0;
        if (call != null && call instanceof ISrvMgrSelect) {
            lockMode = ((ISrvMgrSelect)call).getLockMode();
            if (lockMode != 0) {
                lockResults = ((ISrvMgrSelect)call).getLockReturnCodes();
            }
        } else if (call != null && call instanceof ISrvMgrSelectByRelation && (lockMode = ((ISrvMgrSelectByRelation)call).getLockMode()) != 0) {
            lockResults = ((ISrvMgrSelectByRelation)call).getLockReturnCodes();
        }
        aspect.setWrappedEdoTable(outRecords);
        int recordSize = outRecords.getRecordCount();
        if (recordSize == 0 && aspect.size() == 1) {
            ((AspectRow)aspect.getAspectRow(0)).setState(4);
        }
        int i = 0;
        while (i < recordSize) {
            AspectRow row;
            if (i == 0 && aspect.size() == 1) {
                row = (AspectRow)aspect.getAspectRow(0);
                row.setState(0);
            } else {
                row = (AspectRow)aspect.createAspectRow(i);
            }
            aspect.updateKeyMap(row, (Key)row.getKey());
            if (lockResults != null) {
                row.getLockStateInternal().setLockResult(row, lockMode, aspect.getLockingStrategy(), GenericClientUtils.isFailedRecord(lockResults, i));
            }
            ++i;
        }
        aspect.setState(0);
    }

    static void mergeOutRecordsWithAspect(Aspect aspect, ISrvMgrCall call) {
        IKey key;
        AspectRow row;
        IEdoTable inKeys;
        if (logger.bePath()) {
            logger.pathT("entering: mergeOutRecordsWithAspect", "Aspect name: " + aspect.getName());
        }
        aspect.setState(5);
        if (call instanceof ISrvMgrSelect && (inKeys = ((ISrvMgrSelect)call).getInKeys()).getRecordCount() == 1 && (row = (AspectRow)aspect.getAspectRow(key = GenericClientUtils.getKeyFromTable(inKeys, aspect.getDescriptor().getKeyDescriptor(), 0))) != null && row.getState() == 1) {
            GenericClientUtils.refreshAspectRowFromOutRecords(aspect, row, (ISrvMgrSelect)call);
            return;
        }
        GenericClientUtils.updateAspectWithOutRecords(aspect, call.getOutRecords(), call);
    }

    static void refreshAspectRowFromOutRecords(Aspect aspect, AspectRow row, ISrvMgrSelect call) {
        IEdoTable outRecords = call.getOutRecords();
        row.setState(0);
        if (outRecords.getRecordCount() == 1) {
            aspect.getWrappedEdoTable().setTable(new int[]{row.getIndex()}, outRecords, 0);
            int lockMode = call.getLockMode();
            if (lockMode != 0) {
                row.getLockStateInternal().setLockResult(row, lockMode, aspect.getLockingStrategy(), GenericClientUtils.isFailedRecord(call.getLockReturnCodes(), 0));
            }
            aspect.fireElementChanged(row, row.getIndex());
        } else {
            aspect.removeAspectRow(row);
        }
        aspect.setState(0);
    }

    static void updateAspectWithOutRecords(Aspect aspect, IEdoTable outRecords, ISrvMgrCall call) {
        if (logger.bePath()) {
            logger.pathT("entering: updateAspectWithOutRecords", "Aspect name: " + aspect.getName());
        }
        aspect.setState(5);
        IEdoTable lockResults = null;
        int lockMode = 0;
        if (call != null && call instanceof ISrvMgrSelect) {
            lockMode = ((ISrvMgrSelect)call).getLockMode();
            if (lockMode != 0) {
                lockResults = ((ISrvMgrSelect)call).getLockReturnCodes();
            }
        } else if (call != null && call instanceof ISrvMgrSelectByRelation && (lockMode = ((ISrvMgrSelectByRelation)call).getLockMode()) != 0) {
            lockResults = ((ISrvMgrSelectByRelation)call).getLockReturnCodes();
        }
        int i = 0;
        while (i < outRecords.getRecordCount()) {
            IKey key = GenericClientUtils.getKeyFromTable(outRecords, aspect.getDescriptor().getKeyDescriptor(), i);
            AspectRow row = (AspectRow)aspect.getAspectRow(key);
            if (row == null) {
                row = (AspectRow)aspect.createAspectRowForKey((Key)key);
                if (aspect.size() - 1 == i) {
                    aspect.fireElementAdded(row, i);
                } else {
                    aspect.moveAspectRow(aspect.size() - 1, i);
                }
            } else if (row.getIndex() != i) {
                aspect.moveAspectRow(row.getIndex(), i);
            } else {
                aspect.fireElementChanged(row, i);
            }
            row.setState(0);
            if (lockResults != null) {
                row.getLockStateInternal().setLockResult(row, lockMode, aspect.getLockingStrategy(), GenericClientUtils.isFailedRecord(lockResults, i));
            }
            ++i;
        }
        int noOfRows = aspect.size();
        int i2 = noOfRows - 1;
        while (i2 >= outRecords.getRecordCount()) {
            aspect.removeAspectRow(aspect.getAspectRow(i2));
            --i2;
        }
        aspect.setWrappedEdoTable(outRecords);
        aspect.setState(0);
    }

    protected static String getUnqualifiedClassName(String classname) {
        int index = classname.lastIndexOf(".");
        return classname.substring(index + 1);
    }

    protected static void copyFromKeyToStructure(Key key, IEdoStructure structure) {
        if (logger.bePath()) {
            logger.pathT("entering: copyFromKeyToStructure", "Key: " + key);
        }
        IStructureDescriptor descriptor = key.getKeyDescriptor().getStructure();
        String[] keyFields = key.getKeyFields();
        int j = 0;
        while (j < descriptor.size()) {
            structure.setStringValue(j, keyFields[j]);
            ++j;
        }
    }

    protected static void copyFromEdoStructureToTable(IEdoStructure structure, IEdoTable table, int index) {
        if (logger.bePath()) {
            logger.pathT("entering: copyFromEdoStructureToTable");
        }
        IStructureDescriptor descriptor = structure.getDescriptor();
        int j = 0;
        while (j < descriptor.size()) {
            table.setValue(index, j, structure.getValue(j));
            ++j;
        }
    }

    static void copyFromSortingCriteriaToCall(SortingCriteria sortingCriteria, IEdoTable sortingTable) {
        int noOfCriteria;
        if (logger.bePath()) {
            logger.pathT("entering: copyFromSortingCriteriaToCall");
        }
        if ((noOfCriteria = sortingCriteria.size()) == 0) {
            return;
        }
        sortingTable.append(noOfCriteria);
        int i = 0;
        while (i < noOfCriteria) {
            String sortingString = sortingCriteria.getFieldName(i);
            sortingString = sortingString + " ASCENDING";
            sortingTable.setStringValue(i, "FIELD", sortingString);
            ++i;
        }
    }

    static void copyFromStructureListToEdoTable(StructureList structureList, IEdoTable table) {
        if (logger.bePath()) {
            logger.pathT("entering: copyFromStructureListToEdoTable");
        }
        IStructureDescriptor descriptor = structureList.getDescriptor();
        int noOfEntries = structureList.size();
        table.append(noOfEntries);
        int i = 0;
        while (i < noOfEntries) {
            IStructure structure = structureList.getStructure(i);
            int j = 0;
            while (j < descriptor.size()) {
                table.setValue(i, j, structure.getAttributeValue(j));
                ++j;
            }
            ++i;
        }
    }

    static boolean isFailedRecord(IEdoTable returnCodes, int i) {
        int j = 0;
        while (j < returnCodes.getRecordCount()) {
            if (returnCodes.getIntValue(j, "INRECORD") == i + 1) {
                return returnCodes.getBooleanValue(j, "FAILED");
            }
            ++j;
        }
        return false;
    }

    static void dumpSrvMgrCall(ISrvMgrCall call, Location logger) {
        logger.pathT("dumpSrvMgrCall", "> Call : " + GenericClientUtils.getUnqualifiedClassName(call.getClass().getName()));
        logger.pathT("dumpSrvMgrCall", "> State: " + GenericClientUtils.getStateOfCall(call));
        if (call.getOutRecords() != null) {
            logger.pathT("dumpSrvMgrCall", "> Number of OutRecords: " + call.getOutRecords().getRecordCount());
        }
        if (call.getReturnCodes() == null || call.getReturnCodes().getRecordCount() == 0) {
            logger.pathT("dumpSrvMgrCall", "> Return Codes: complete call o.k.");
        } else {
            logger.pathT("dumpSrvMgrCall", "> Return Codes: some records with return codes");
            int i = 0;
            while (i < call.getReturnCodes().getRecordCount()) {
                logger.pathT("dumpSrvMgrCall", "              Record: " + call.getReturnCodes().getStringValue(i, 0) + " Failed: " + call.getReturnCodes().getStringValue(i, 1));
                ++i;
            }
        }
        if (call instanceof ISrvMgrUpdateRow) {
            ISrvMgrUpdateRow updateCall = (ISrvMgrUpdateRow)call;
            logger.pathT("dumpSrvMgrCall", "> Number of InRecords: " + updateCall.getInRecords().getRecordCount());
        } else if (call instanceof ISrvMgrDelete) {
            ISrvMgrDelete deleteCall = (ISrvMgrDelete)call;
            logger.pathT("dumpSrvMgrCall", "> Number of InKeys: " + deleteCall.getInKeys().getRecordCount());
        } else if (call instanceof ISrvMgrInsert) {
            ISrvMgrInsert insertCall = (ISrvMgrInsert)call;
            logger.pathT("dumpSrvMgrCall", "> Number of InRecords: " + insertCall.getInRecords().getRecordCount());
            if (insertCall.getAspectDescriptor().getAttributeInsertRelationRequired()) {
                if (insertCall.getRelationInKey() != null) {
                    logger.pathT("dumpSrvMgrCall", "> Relation InKey: " + GenericClientUtils.dumpEdoStructure(insertCall.getRelationInKey()));
                } else {
                    logger.pathT("dumpSrvMgrCall", "> Relation InKey: not set");
                }
                if (insertCall.getRelationOutRecord() != null) {
                    logger.pathT("dumpSrvMgrCall", "> Relation OutRecord: " + GenericClientUtils.dumpEdoStructure(insertCall.getRelationOutRecord()));
                } else {
                    logger.pathT("dumpSrvMgrCall", "> Relation OutRecord: not returned");
                }
            }
        } else if (call instanceof ISrvMgrAction) {
            String crossAspectRelation;
            ISrvMgrAction actionCall = (ISrvMgrAction)call;
            if (actionCall.getInKeys() != null) {
                logger.pathT("dumpSrvMgrCall", "> Number of InKeys: " + actionCall.getInKeys().getRecordCount());
            }
            if ((crossAspectRelation = actionCall.getAspectActionDescriptor().getAttributeRelation()) != null && !crossAspectRelation.equals("") && actionCall.getRelationOutRecord() != null) {
                if (actionCall.getRelationInKey() != null) {
                    logger.pathT("dumpSrvMgrCall", "> Relation InKey: " + GenericClientUtils.dumpEdoStructure(actionCall.getRelationInKey()));
                } else {
                    logger.pathT("dumpSrvMgrCall", "> Relation InKey: not set");
                }
                if (actionCall.getRelationOutRecord() != null) {
                    logger.pathT("dumpSrvMgrCall", "> Relation OutRecord: " + GenericClientUtils.dumpEdoStructure(actionCall.getRelationOutRecord()));
                } else {
                    logger.pathT("dumpSrvMgrCall", "> Relation OutRecord: not returned");
                }
            }
        } else if (call instanceof ISrvMgrSelect) {
            ISrvMgrSelect selectCall = (ISrvMgrSelect)call;
            logger.pathT("dumpSrvMgrCall", "> Number of InKeys: " + selectCall.getInKeys().getRecordCount());
            logger.pathT("dumpSrvMgrCall", "> Lock mode: " + GenericClientUtils.getLockModeOfCall(selectCall.getLockMode()));
            if (selectCall.getLockReturnCodes() == null || selectCall.getLockReturnCodes().getRecordCount() == 0) {
                logger.pathT("dumpSrvMgrCall", "> Lock Return Codes: complete call o.k.");
            } else {
                logger.pathT("dumpSrvMgrCall", "> Lock Return Codes: some records with return codes");
                int i = 0;
                while (i < selectCall.getLockReturnCodes().getRecordCount()) {
                    logger.pathT("dumpSrvMgrCall", "              Record: " + selectCall.getLockReturnCodes().getStringValue(i, 0) + " Failed: " + selectCall.getLockReturnCodes().getStringValue(i, 1));
                    ++i;
                }
            }
        } else if (call instanceof ISrvMgrSelectByRelation) {
            ISrvMgrSelectByRelation selectByRelationCall = (ISrvMgrSelectByRelation)call;
            logger.pathT("dumpSrvMgrCall", "> Number of InRecords: " + selectByRelationCall.getInRecords().getRecordCount());
            logger.pathT("dumpSrvMgrCall", "> Lock mode: " + GenericClientUtils.getLockModeOfCall(selectByRelationCall.getLockMode()));
            if (selectByRelationCall.getLockReturnCodes() == null || selectByRelationCall.getLockReturnCodes().getRecordCount() == 0) {
                logger.pathT("dumpSrvMgrCall", "> Lock Return Codes: complete call o.k.");
            } else {
                logger.pathT("dumpSrvMgrCall", "> Lock Return Codes: some records with return codes");
                int i = 0;
                while (i < selectByRelationCall.getLockReturnCodes().getRecordCount()) {
                    logger.pathT("dumpSrvMgrCall", "              Record: " + selectByRelationCall.getLockReturnCodes().getStringValue(i, 0) + " Failed: " + selectByRelationCall.getLockReturnCodes().getStringValue(i, 1));
                    ++i;
                }
            }
        } else if (call instanceof ISrvMgrLock) {
            ISrvMgrLock lockCall = (ISrvMgrLock)call;
            logger.pathT("dumpSrvMgrCall", "> Number of InKeys: " + lockCall.getInKeys().getRecordCount());
            logger.pathT("dumpSrvMgrCall", "> Lock mode: " + GenericClientUtils.getLockModeOfCall(lockCall.getLockMode()));
        } else if (call instanceof ISrvMgrUnlock) {
            ISrvMgrUnlock unLockCall = (ISrvMgrUnlock)call;
            logger.pathT("dumpSrvMgrCall", "> Number of InKeys: " + unLockCall.getInKeys().getRecordCount());
        }
    }

    private static String dumpEdoStructure(IEdoStructure structure) {
        IStructureDescriptor structDescriptor = structure.getDescriptor();
        StringBuffer structDump = new StringBuffer("[");
        int i = 0;
        while (i < structDescriptor.size()) {
            structDump.append(structure.getValue(i));
            if (i != structDescriptor.size() - 1) {
                structDump.append(",");
            }
            ++i;
        }
        structDump.append("]");
        return structDump.toString();
    }

    private static String getStateOfCall(ISrvMgrCall call) {
        switch (call.getState()) {
            case 0: {
                return "CREATED";
            }
            case 1: {
                return "QUEUED";
            }
            case 2: {
                return "COMPLETED";
            }
            case 3: {
                return "REJECTED";
            }
            case 4: {
                return "FAILED";
            }
        }
        return "UNDEFINED";
    }

    private static String getLockModeOfCall(int lockMode) {
        switch (lockMode) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Exclusive";
            }
            case 2: {
                return "Shared";
            }
            case 3: {
                return "Shared Promotable";
            }
        }
        return "UNDEFINED";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/GenericClientUtils.java#1 $");
    }
}

