/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import java.io.PrintStream;
import java.io.PrintWriter;

public class GCPRuntimeException
extends RuntimeException {
    private Throwable m_cause;

    public GCPRuntimeException(String message) {
        this(message, null);
    }

    public GCPRuntimeException(Throwable cause) {
        this("", cause);
    }

    public GCPRuntimeException(String message, Throwable cause) {
        super(message);
        this.m_cause = cause;
    }

    public Throwable getCause() {
        return this.m_cause;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.m_cause != null) {
            System.err.println("Caused by:");
            this.m_cause.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        if (this.m_cause != null) {
            ps.println("Caused by:");
            this.m_cause.printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (this.m_cause != null) {
            pw.println("Caused by:");
            this.m_cause.printStackTrace(pw);
        }
    }

    public String getMessage() {
        return super.getMessage() + (this.m_cause != null ? " Caused by: " + this.m_cause.getMessage() : "");
    }
}

