/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.core;

import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.ILockState;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.generic.core.AbstractModelClass;
import com.sap.tc.col.client.generic.core.Aspect;
import com.sap.tc.col.client.generic.core.DependantAspectCache;
import com.sap.tc.col.client.generic.core.GenericClientUtils;
import com.sap.tc.col.client.generic.core.ISrvMgrCaller;
import com.sap.tc.col.client.generic.core.Key;
import com.sap.tc.col.client.generic.core.KeyList;
import com.sap.tc.col.client.generic.core.LockCache;
import com.sap.tc.col.client.generic.core.LockState;
import com.sap.tc.col.client.generic.core.MessageList;
import com.sap.tc.col.client.generic.core.ServiceModule;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrLock;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelect;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelectByRelation;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrUnlock;
import com.sap.tc.logging.Location;
import java.util.Collection;

public class AspectRow
extends AbstractModelClass
implements IAspectRow,
ISrvMgrCaller {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$tc$col$client$generic$core$AspectRow == null ? (class$com$sap$tc$col$client$generic$core$AspectRow = AspectRow.class$("com.sap.tc.col.client.generic.core.AspectRow")) : class$com$sap$tc$col$client$generic$core$AspectRow));
    private IStructureDescriptor structureDescriptor;
    private final Aspect aspect;
    private final Key key;
    private int state = 0;
    private final DependantAspectCache dependantAspectCache;
    private int index;
    private boolean flushedChangesInTransaction = false;
    private final LockState lockState = new LockState();
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$core$AspectRow;

    protected AspectRow(Aspect aspect, int index) {
        this(aspect, index, new Key(aspect.getDescriptor().getKeyDescriptor()));
    }

    protected AspectRow(Aspect aspect, int index, Key key) {
        if (logger.bePath()) {
            logger.pathT("entering: AspectRow constructor", "Aspect name: " + aspect.getName() + " index: " + index);
        }
        this.aspect = aspect;
        this.structureDescriptor = aspect.getDescriptor().getStructure();
        this.index = index;
        this.key = key;
        this.dependantAspectCache = new DependantAspectCache(aspect, key);
    }

    public IStructureDescriptor getDescriptor() {
        if (logger.bePath()) {
            logger.pathT("entering: getDescriptor", "Aspect name: " + this.aspect.getName());
        }
        return this.structureDescriptor;
    }

    public int size() {
        return this.structureDescriptor.size();
    }

    public ICMIModel associatedModel() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModel");
        }
        return this.aspect.associatedModel();
    }

    public ICMIModelClassInfo associatedModelClassInfo() {
        if (logger.bePath()) {
            logger.pathT("entering: associatedModelClassInfo");
        }
        return this.aspect.associatedModelObjectCollectionInfo().getElementModelClassInfo();
    }

    public IKey getKey() {
        if (logger.bePath()) {
            logger.pathT("entering: getKey", "Key: " + this.key);
        }
        this.handleAccessAspectRow();
        return this.key;
    }

    public IAspect getRelatedAspect(String relationName, String targetAspectName) {
        return this.getRelatedAspect(relationName, targetAspectName, (LockStrategy)null);
    }

    public IAspect getRelatedAspect(String relationName, String targetAspectName, LockStrategy lockStrategy) {
        IRelationDescriptor relationDescriptor;
        String targetOfRelation;
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedAspect", "Relation name: " + relationName + " targetAspect: " + targetAspectName + " LockStrategy: " + lockStrategy);
        }
        if ((targetOfRelation = (relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName)).getTargetAspectDescriptor().getName()).equals(targetAspectName)) {
            return this.getRelatedAspect(relationName, lockStrategy);
        }
        Aspect targetAspect = (Aspect)this.getRelatedAspect(relationName, (LockStrategy)null);
        return targetAspect.getAspect(targetAspectName, lockStrategy);
    }

    public IAspectRow getRelatedAspectRow(String relationName, String targetAspectName) {
        return this.getRelatedAspectRow(relationName, targetAspectName, null);
    }

    public IAspectRow getRelatedAspectRow(String relationName, String targetAspectName, LockStrategy lockStrategy) {
        IRelationDescriptor relationDescriptor;
        String targetOfRelation;
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedAspectRow", "Relation name: " + relationName + " targetAspect: " + targetAspectName + " LockStrategy: " + lockStrategy);
        }
        if ((targetOfRelation = (relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName)).getTargetAspectDescriptor().getName()).equals(targetAspectName)) {
            return this.getRelatedAspectRow(relationName, lockStrategy);
        }
        AspectRow targetAspectRow = (AspectRow)this.getRelatedAspectRow(relationName, (LockStrategy)null);
        return targetAspectRow.getAspectRow(targetAspectName, lockStrategy);
    }

    public IAspect getRelatedAspect(String relationName) {
        return this.getRelatedAspect(relationName, (LockStrategy)null, null);
    }

    public IAspect getRelatedAspect(String relationName, LockStrategy lockStrategy) {
        return this.getRelatedAspect(relationName, lockStrategy, null);
    }

    public IAspect getRelatedAspect(String relationName, LockStrategy lockStrategy, SortingCriteria sorting) {
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedAspect", "Relation name: " + relationName + " LockStrategy: " + lockStrategy + " Sorting: " + sorting);
        }
        this.handleAccessAspectRow();
        Aspect targetAspect = this.dependantAspectCache.getRelatedAspect(relationName);
        if (targetAspect != null) {
            if (lockStrategy != null) {
                if (targetAspect.getState() != 0 && targetAspect.getState() != 1) {
                    throw new IllegalArgumentException("Locking of aspect '" + targetAspect.getName() + "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
                }
                targetAspect.lockAndRefresh(lockStrategy);
            }
            return targetAspect;
        }
        ServiceModule serviceModule = (ServiceModule)this.aspect.getServiceModule();
        IRelationDescriptor relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName);
        String sourceAspectName = relationDescriptor.getSourceAspectDescriptor().getName();
        if (!sourceAspectName.equals(this.aspect.getName())) {
            Aspect keyAspect = (Aspect)this.aspect.getAspect(sourceAspectName);
            AspectRow keyAspectRow = (AspectRow)keyAspect.getAspectRow(this.key);
            if (keyAspectRow == null) {
                keyAspectRow = (AspectRow)keyAspect.createAspectRowForKey(this.key);
                keyAspectRow.setKeyFields(this.key);
            }
            return keyAspectRow.getRelatedAspect(relationName, lockStrategy);
        }
        Aspect relationTarget = this.aspect.getDependantAspectCache().getRelatedAspect(relationName);
        if (relationTarget != null && sorting == null) {
            targetAspect = serviceModule.createAspectInCache(this.aspect.getAspectCache(), relationTarget.getDescriptor().getName(), null);
            if (relationTarget.size() == 0) {
                return targetAspect;
            }
            int[] indexList = this.aspect.getDependantAspectCache().getIndexTable(relationName).getRelatedIndexes(this.getIndex());
            if (indexList.length == 0) {
                return targetAspect;
            }
            IEdoTable newAspectData = serviceModule.getSrvMgrServiceModule().createTable(targetAspect.getDescriptor().getStructure());
            relationTarget.getWrappedEdoTable().getTable(indexList, newAspectData);
            GenericClientUtils.setOutRecordsToAspect(targetAspect, newAspectData, null);
            targetAspect.setLocalRelationCreationCall(relationName);
            if (lockStrategy != null) {
                targetAspect.lockAndRefresh(lockStrategy);
            }
            this.dependantAspectCache.addRelatedAspect(relationName, targetAspect, null);
            return targetAspect;
        }
        ISrvMgrSelectByRelation selectByRelationCall = serviceModule.getSrvMgrServiceModule().createSelectByRelation(this.aspect.getName(), relationName);
        this.aspect.getWrappedEdoTable().getTable(new int[]{this.getIndex()}, selectByRelationCall.getInRecords());
        if (lockStrategy != null) {
            int lockMode = LockState.getLockModeFromStrategy(relationDescriptor.getTargetAspectDescriptor(), lockStrategy);
            selectByRelationCall.setLockMode(lockMode);
        }
        if (sorting != null) {
            GenericClientUtils.copyFromSortingCriteriaToCall(sorting, selectByRelationCall.getInSortingOptions());
        }
        targetAspect = serviceModule.createAspectInCache(this.aspect.getAspectCache(), relationDescriptor.getTargetAspectDescriptor().getName(), (ISrvMgrCall)selectByRelationCall);
        targetAspect.setLockingStrategy(lockStrategy);
        serviceModule.registerSrvMgrCallObject((ISrvMgrCall)selectByRelationCall, targetAspect);
        this.dependantAspectCache.addRelatedAspect(relationName, targetAspect, selectByRelationCall.getRelations());
        return targetAspect;
    }

    public IAspectRow getRelatedAspectRow(String relationName) {
        return this.getRelatedAspectRow(relationName, (LockStrategy)null);
    }

    public IAspectRow getRelatedAspectRow(String relationName, LockStrategy lockStrategy) {
        IRelationDescriptor relationDescriptor;
        CMICardinality cardinality;
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedAspectRow", "Relation name: " + relationName + " LockStrategy: " + lockStrategy);
        }
        if ((cardinality = (relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName)).getAttributeTargetCardinality()).isMultiple()) {
            throw new IllegalArgumentException(" Cardinality of relation " + relationName + " has to be 1:0..1 but is " + cardinality);
        }
        Aspect targetAspect = (Aspect)this.getRelatedAspect(relationName, lockStrategy);
        if (targetAspect != null && targetAspect.size() > 0) {
            return targetAspect.getAspectRow(0);
        }
        return null;
    }

    public IAspectRow getAspectRow(String aspectName) {
        return this.getAspectRow(aspectName, null);
    }

    public IAspectRow getAspectRow(String aspectName, LockStrategy lockStrategy) {
        AspectRow targetRow;
        if (logger.bePath()) {
            logger.pathT("entering: getAspectRow", "Aspect name: " + aspectName + " LockMode: " + lockStrategy);
        }
        if (this.aspect.getName().equals(aspectName)) {
            if (lockStrategy != null) {
                this.lock(lockStrategy);
            }
            return this;
        }
        this.handleAccessAspectRow();
        Aspect resultAspect = this.dependantAspectCache.getSiblingAspect(aspectName);
        if (resultAspect != null) {
            return resultAspect.getAspectRow(this.getKey(), lockStrategy);
        }
        resultAspect = this.aspect.getSelectedAspect(aspectName);
        if (resultAspect != null) {
            return resultAspect.getAspectRow(this.getKey(), lockStrategy);
        }
        ServiceModule serviceModule = (ServiceModule)this.aspect.getServiceModule();
        if (this.key.isLocalKey()) {
            return null;
        }
        KeyList keyList = new KeyList(this.key.getKeyDescriptor());
        keyList.add(this.key);
        resultAspect = (Aspect)serviceModule.getAspect(this.aspect, aspectName, keyList, lockStrategy);
        if (resultAspect.getState() == 0) {
            targetRow = (AspectRow)resultAspect.getAspectRow(this.key);
        } else {
            resultAspect.setState(5);
            targetRow = (AspectRow)resultAspect.createAspectRow(0);
            resultAspect.setState(1);
            targetRow.setState(1);
        }
        this.dependantAspectCache.addSiblingAspect(aspectName, resultAspect);
        return targetRow;
    }

    public IAspect getAspect() {
        if (logger.bePath()) {
            logger.pathT("entering: getAspect", "Aspect name: " + this.aspect.getName());
        }
        this.handleAccessAspectRow();
        return this.aspect;
    }

    public void setAttributeValue(String attributeName, Object attributeValue) {
        if (logger.bePath()) {
            logger.pathT("entering: setAttributeValue", "Attribute: " + attributeName + " Value: " + attributeValue);
        }
        this.handleAccessAspectRow();
        this.aspect.getWrappedEdoTable().setValue(this.index, attributeName, attributeValue);
        this.handleDirtyState(attributeName);
    }

    public void setAttributeValue(int attributeIndex, Object attributeValue) {
        if (logger.bePath()) {
            logger.pathT("entering: setAttributeValue", "Index: " + attributeIndex + " Value: " + attributeValue);
        }
        this.handleAccessAspectRow();
        this.aspect.getWrappedEdoTable().setValue(this.index, attributeIndex, attributeValue);
        this.handleDirtyState(this.structureDescriptor.getFieldDescriptor(attributeIndex).getName());
    }

    public Object getAttributeValue(String attributeName) {
        this.handleAccessAspectRow();
        return this.aspect.getWrappedEdoTable().getValue(this.index, attributeName);
    }

    public String getAttributeAsString(int attributeIndex) {
        this.handleAccessAspectRow();
        return this.aspect.getWrappedEdoTable().getStringValue(this.index, attributeIndex);
    }

    public Object getAttributeValue(int attributeIndex) {
        this.handleAccessAspectRow();
        return this.aspect.getWrappedEdoTable().getValue(this.index, attributeIndex);
    }

    public String getAttributeAsString(String attributeName) {
        this.handleAccessAspectRow();
        return this.aspect.getWrappedEdoTable().getStringValue(this.index, attributeName);
    }

    public boolean isAttributeInitial(int attributeIndex) {
        this.handleAccessAspectRow();
        return this.aspect.getWrappedEdoTable().isInitial(this.index, attributeIndex);
    }

    public boolean isAttributeInitial(String attributeName) {
        this.handleAccessAspectRow();
        return this.aspect.getWrappedEdoTable().isInitial(this.index, attributeName);
    }

    protected void handleAccessAspectRow() {
        if (this.state == 1 || this.aspect.getState() == 1 || this.aspect.getState() == 3) {
            ((ServiceModule)this.aspect.getServiceModule()).flush("handleAccessAspectRow");
        }
        if (this.aspect.getState() == 6) {
            this.aspect.startRefreshingAspect();
            if (this.aspect.getState() == 1) {
                ((ServiceModule)this.aspect.getServiceModule()).flush("handleAccessAspectRow");
            }
        }
        if (this.state == 4 || this.aspect.getState() == 4) {
            throw new IllegalStateException(" AspectRow with Key: " + this.key + " of Aspect '" + this.aspect.getName() + "' is invalid: Fatal Access Error!!!");
        }
    }

    protected void setState(int state) {
        this.state = state;
    }

    protected int getState() {
        return this.state;
    }

    public String toString() {
        this.handleAccessAspectRow();
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <AspectRow>").append(nl);
        int i = 0;
        while (i < this.size()) {
            IFieldDescriptor field = this.structureDescriptor.getFieldDescriptor(i);
            String attributeValue = this.getAttributeAsString(i);
            buf.append("     ").append(field.getName()).append("=").append(attributeValue == null ? "<null>" : attributeValue).append(nl);
            ++i;
        }
        buf.append("  </AspectRow>").append(nl);
        return buf.toString();
    }

    private void handleDirtyState(String fieldName) {
        if (this.aspect.getState() == 5) {
            return;
        }
        this.promoteLockIfNecessary();
        this.incrementModCount();
        this.setState(2);
        this.aspect.registerUpdate(this.key, fieldName);
    }

    void promoteLockIfNecessary() {
        if (this.key.isLocalKey()) {
            return;
        }
        LockState lockState = this.getLockStateInternal();
        if (lockState.hasExclusiveLock() || !lockState.hasLock()) {
            return;
        }
        if (lockState.hasSharedLock() && lockState.getLockStrategy() == LockStrategy.SHARED_READ_ONLY) {
            throw new IllegalStateException("You cannot change data for AspectRow " + this.getKey() + " , when using lock strategy SHARED_READ_ONLY!");
        }
        if (!LockState.isSupportedLock(this.aspect.getDescriptor(), 1)) {
            throw new IllegalStateException("You cannot change data for AspectRow " + this.getKey() + " , when using lock strategy " + lockState.getLockStrategy() + "but Aspect '" + this.aspect.getDescriptor().getName() + "' doesn't support Exclusive locks!");
        }
        ISrvMgrLock lockCall = ((ServiceModule)this.aspect.getServiceModule()).getSrvMgrServiceModule().createLock(this.aspect.getName());
        GenericClientUtils.copyFromKeyToTable(this.key, lockCall.getInKeys(), 0);
        lockCall.setLockMode(1);
        ((ServiceModule)this.aspect.getServiceModule()).registerSrvMgrCallObject((ISrvMgrCall)lockCall, this.aspect);
        this.setState(1);
        ((ServiceModule)this.aspect.getServiceModule()).flush("promoteLockIfNecessary");
    }

    public ICMIModelClass getRelatedModelObject(String rolename) {
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedModelObject", "rolename: " + rolename);
        }
        return this.getRelatedAspectRow(rolename);
    }

    public Collection getRelatedModelObjects(String rolename) {
        if (logger.bePath()) {
            logger.pathT("entering: getRelatedModelObjects", "rolename: " + rolename);
        }
        return this.getRelatedAspect(rolename);
    }

    DependantAspectCache getDependantAspectCache() {
        return this.dependantAspectCache;
    }

    protected int getIndex() {
        return this.index;
    }

    protected void invalidateInternal() {
        if (this.state == 4) {
            return;
        }
        this.setState(4);
        ((ServiceModule)this.aspect.getServiceModule()).unregisterAspectRowKey(this.aspect, this.key);
        this.dependantAspectCache.invalidate();
    }

    protected void refresh() {
        this.dependantAspectCache.refresh();
    }

    protected void executeRefreshCall(ISrvMgrCall call, Aspect target) {
        if (call == null) {
            String relationName = target.getLocalRelationCreationCall();
            if (relationName != null) {
                Aspect bigRelatedAspect = this.aspect.getDependantAspectCache().getRelatedAspect(relationName);
                if (bigRelatedAspect.getState() == 6) {
                    this.aspect.executeRefreshCall(bigRelatedAspect.getCreateAspectCall(), bigRelatedAspect);
                }
                if (bigRelatedAspect.size() == 0) {
                    target.invalidate();
                    return;
                }
                int[] indexList = this.aspect.getDependantAspectCache().getIndexTable(relationName).getRelatedIndexes(this.getIndex());
                if (indexList.length == 0) {
                    target.invalidate();
                    return;
                }
                IEdoTable newOutRecords = ((ServiceModule)this.aspect.getServiceModule()).getSrvMgrServiceModule().createTable(target.getDescriptor().getStructure());
                bigRelatedAspect.getWrappedEdoTable().getTable(indexList, newOutRecords);
                GenericClientUtils.updateAspectWithOutRecords(target, newOutRecords, null);
            } else {
                this.aspect.executeRefreshCall(call, target);
            }
            return;
        }
        if (call instanceof ISrvMgrSelect) {
            ISrvMgrSelect selectCall = (ISrvMgrSelect)call;
            selectCall.reset();
            KeyList keyList = new KeyList(this.key.getKeyDescriptor());
            keyList.add(this.key);
            GenericClientUtils.copyFromKeyListToTable(keyList, selectCall.getInKeys());
        } else if (call instanceof ISrvMgrSelectByRelation) {
            ISrvMgrSelectByRelation selectByRelationCall = (ISrvMgrSelectByRelation)call;
            selectByRelationCall.reset();
            this.aspect.getWrappedEdoTable().getTable(new int[]{this.getIndex()}, selectByRelationCall.getInRecords());
        }
        if (call != null) {
            ServiceModule serviceModule = (ServiceModule)this.aspect.getServiceModule();
            serviceModule.registerSrvMgrCallObject(call, target);
            target.setState(1);
        }
    }

    protected void setKeyFields(Key key) {
        IStructureDescriptor structureDescriptor = this.aspect.getDescriptor().getKeyDescriptor().getStructure();
        int noOfFields = structureDescriptor.size();
        String[] keyFields = key.getKeyFields();
        int i = 0;
        while (i < noOfFields && i < keyFields.length) {
            String fieldName = structureDescriptor.getFieldDescriptor(i).getName();
            this.aspect.getWrappedEdoTable().setStringValue(this.index, fieldName, keyFields[i]);
            ++i;
        }
    }

    public void promoteLock() {
        if (logger.bePath()) {
            logger.pathT("entering: promoteLock", "Key: " + this.key);
        }
        this.handleAccessAspectRow();
        if (this.getLockStateInternal().hasExclusiveLock()) {
            return;
        }
        if (!this.getLockStateInternal().hasSharedPromotableLock()) {
            throw new IllegalStateException("promotion of lock to exclusive only possible, when AspectRow '" + this.getKey() + "' holds shared promotable lock");
        }
        ISrvMgrLock lockCall = ((ServiceModule)this.aspect.getServiceModule()).getSrvMgrServiceModule().createLock(this.aspect.getName());
        GenericClientUtils.copyFromKeyToTable(this.key, lockCall.getInKeys(), 0);
        lockCall.setLockMode(1);
        ((ServiceModule)this.aspect.getServiceModule()).registerSrvMgrCallObject((ISrvMgrCall)lockCall, this.aspect);
        this.setState(1);
    }

    public void lock(LockStrategy lockStrategy) {
        if (logger.bePath()) {
            logger.pathT("entering: lock", "Key: " + this.key + " Strategy: " + lockStrategy);
        }
        if (lockStrategy == null) {
            return;
        }
        this.handleAccessAspectRow();
        this.aspect.lockAndRefresh(this, lockStrategy);
    }

    public void unlock() {
        if (logger.bePath()) {
            logger.pathT("entering: unlock", "Key: " + this.key);
        }
        this.handleAccessAspectRow();
        if (!this.getLockStateInternal().hasLock()) {
            return;
        }
        ISrvMgrUnlock unLockCall = ((ServiceModule)this.aspect.getServiceModule()).getSrvMgrServiceModule().createUnlock(this.aspect.getName());
        GenericClientUtils.copyFromKeyToTable(this.key, unLockCall.getInKeys(), 0);
        ((ServiceModule)this.aspect.getServiceModule()).registerSrvMgrCallObject((ISrvMgrCall)unLockCall, this.aspect);
        this.setState(1);
    }

    public void onCallsProcessed(ISrvMgrCall[] calls) {
    }

    void setIndex(int i) {
        this.index = i;
    }

    public IMessageList getMessages() {
        if (logger.bePath()) {
            logger.pathT("entering: getMessages", "AspectRow Key: " + this.key);
        }
        return new MessageList((ISrvMgrMessageProvider)((ServiceModule)this.aspect.getServiceModule()).getSrvMgrServiceModule().getServiceManager(), this);
    }

    public boolean isValid() {
        if (logger.bePath()) {
            logger.pathT("entering: isValid", "Key: " + this.key);
        }
        try {
            this.handleAccessAspectRow();
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    void setFlushedChangesInTransaction(boolean changes) {
        this.flushedChangesInTransaction = changes;
        if (changes) {
            LockCache cache = ((ServiceModule)this.aspect.getServiceModule()).getServiceFacade().getLockCache();
            cache.registerChangedAspectRow(this);
        }
    }

    public boolean isDirty() {
        return this.state == 2 || this.flushedChangesInTransaction;
    }

    public String getName() {
        if (logger.bePath()) {
            logger.pathT("entering: getName", this.aspect.getName());
        }
        return this.aspect.getName();
    }

    public String getRelativeKeyUrl() {
        if (logger.bePath()) {
            logger.pathT("entering: getRelativeKeyUrl", "Key: " + this.key);
        }
        if (this.key.isLocalKey()) {
            throw new IllegalStateException("can't determine relative key url for a local key");
        }
        return ((ServiceModule)this.aspect.getServiceModule()).getSrvMgrServiceModule().getServiceManager().getRelativeAspectRowKey(this.aspect.getDescriptor(), this.aspect.getWrappedEdoTable(), this.index);
    }

    public ILockState getLockState() {
        this.handleAccessAspectRow();
        return this.getLockStateInternal();
    }

    LockState getLockStateInternal() {
        return this.lockState;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.client.generic.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_client_generic/java/com/sap/tc/col/client/generic/core/AspectRow.java#1 $");
    }
}

