/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ssl;

import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.Utils;
import iaik.ssl.com.fourthpass.a;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class SecurityProvider {
    static /* synthetic */ Class c;
    public static final String ALG_CIPHER_RSA_ENCRYPT_SSL2 = "RSA/ECB/PKCS1PaddingSSL2";
    public static final String ALG_CIPHER_RSA_DECRYPT = "RSA/ECB/PKCS1Padding/Decrypt";
    public static final String ALG_CIPHER_RSA_ENCRYPT = "RSA/ECB/PKCS1Padding/Encrypt";
    public static final String ALG_CIPHER_RSA_VERIFY = "RSA/ECB/PKCS1Padding/Verify";
    public static final String ALG_CIPHER_RSA_SIGN = "RSA/ECB/PKCS1Padding/Sign";
    public static final String ALG_CIPHER_RSA = "RSA/ECB/PKCS1Padding";
    public static final String ALG_KEYEX_DH = "DH";
    public static final String ALG_KEYEX_DSA_CLIENT = "DSAClient";
    public static final String ALG_KEYEX_DSA = "DSA";
    public static final String ALG_KEYEX_RSA = "RSA";
    public static final String ALG_KEYPAIR_RSA = "RSA";
    public static final String ALG_CIPHER_AES = "AES/CBC/NoPadding";
    public static final String ALG_CIPHER_IDEA = "IDEA/CBC/NoPadding";
    public static final String ALG_CIPHER_3DES = "DESede/CBC/NoPadding";
    public static final String ALG_CIPHER_DES = "DES/CBC/NoPadding";
    public static final String ALG_CIPHER_RC2 = "RC2/CBC/NoPadding";
    public static final String ALG_CIPHER_RC4 = "RC4/ECB/NoPadding";
    public static final String ALG_SIGNATURE_MD5RSA = "MD5withRSA";
    public static final String ALG_SIGNATURE_RAWDSA = "RawDSA";
    public static final String ALG_SIGNATURE_SHADSA = "SHA1withDSA";
    public static final String ALG_HMAC_SHA = "HmacSHA1";
    public static final String ALG_HMAC_MD5 = "HmacMD5";
    public static final String ALG_DIGEST_SHA = "SHA";
    public static final String ALG_DIGEST_MD5 = "MD5";
    public static int CIPHER_DECRYPT;
    public static int CIPHER_ENCRYPT;
    public static int CIPHER_NONE;
    public static int SIGNATURE_VERIFY;
    public static int SIGNATURE_SIGN;
    public static int SIGNATURE_NONE;
    protected String providerName;
    private static Hashtable b;
    private static SecurityProvider a;
    private static final boolean d = true;
    private static final boolean e = false;
    private static final boolean f = false;
    protected static Properties configuration_;
    protected static final String CONFIGURATION_PROPERTIES = "iaik/security/ssl/SecurityProvider.properties";

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected boolean verifyRawSignature(String string, byte[] byArray, byte[] byArray2, PublicKey publicKey) throws Exception {
        Cipher cipher = this.getCipher(string, CIPHER_DECRYPT, publicKey, null, null);
        byte[] byArray3 = cipher.doFinal(byArray2);
        boolean bl = Utils.equalsBlock(byArray, byArray3);
        return bl;
    }

    public static void setSecurityProvider(SecurityProvider securityProvider) {
        a = securityProvider;
        b.clear();
    }

    static boolean b(String string) {
        Boolean bl = (Boolean)b.get(string);
        if (bl == null) {
            bl = SecurityProvider.getSecurityProvider().isImplemented(string) ? Boolean.TRUE : Boolean.FALSE;
            b.put(string, bl);
        }
        return bl;
    }

    protected boolean isImplemented(String string) {
        try {
            Object object = null;
            if (string.equals("RSA")) {
                object = a.getCipher(ALG_CIPHER_RSA_SIGN, CIPHER_NONE, null, null, null);
            } else if (string.equals(ALG_KEYEX_DSA_CLIENT)) {
                object = a.getSignature(ALG_SIGNATURE_RAWDSA, SIGNATURE_NONE, null, null);
            } else if (string.equals(ALG_KEYEX_DSA)) {
                object = a.getSignature(ALG_SIGNATURE_SHADSA, SIGNATURE_NONE, null, null);
            } else if (string.equals(ALG_KEYEX_DH)) {
                DHParameterSpec dHParameterSpec = SSLServerContext.b();
                BigInteger bigInteger = new BigInteger(160, new Random());
                object = a.getDHPrivateKey(bigInteger, dHParameterSpec.getP(), dHParameterSpec.getG());
            } else {
                object = a.getCipher(string, CIPHER_NONE, null, null, null);
            }
            return object != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected X509Certificate getX509Certificate(byte[] byArray) throws Exception {
        CertificateFactory certificateFactory = this.providerName == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.providerName);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        return x509Certificate;
    }

    protected String[] getTLSServerName(X509Certificate x509Certificate) {
        return null;
    }

    protected Signature getSignature(String string, int n2, Key key, SecureRandom secureRandom) throws Exception {
        Signature signature;
        Signature signature2 = signature = this.providerName == null ? Signature.getInstance(string) : Signature.getInstance(string, this.providerName);
        if (n2 == SIGNATURE_SIGN) {
            signature.initSign((PrivateKey)key);
        } else if (n2 == SIGNATURE_VERIFY) {
            signature.initVerify((PublicKey)key);
        }
        return signature;
    }

    public static SecurityProvider getSecurityProvider() {
        if (a == null) {
            if (configuration_ != null) {
                try {
                    String string = configuration_.getProperty("class");
                    a = (SecurityProvider)iaik.ssl.com.fourthpass.a.a(string).newInstance();
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    Class<?> clazz = Class.forName("iaik.security.ssl.IaikProvider");
                    a = (SecurityProvider)clazz.newInstance();
                }
                catch (Throwable throwable) {}
            }
            if (a == null) {
                a = new SecurityProvider();
            }
        }
        return a;
    }

    protected SecureRandom getSecureRandom() {
        return new SecureRandom();
    }

    protected RSAPublicKey getRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        KeyFactory keyFactory = this.providerName == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", this.providerName);
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        return rSAPublicKey;
    }

    protected Principal getPrincipal(byte[] byArray) throws Exception {
        return null;
    }

    protected MessageDigest getMessageDigest(String string) throws Exception {
        if (this.providerName == null) {
            return MessageDigest.getInstance(string);
        }
        return MessageDigest.getInstance(string, this.providerName);
    }

    protected Mac getMac(String string, Key key) throws Exception {
        Mac mac;
        Mac mac2 = mac = this.providerName == null ? Mac.getInstance(string) : Mac.getInstance(string, this.providerName);
        if (key != null) {
            mac.init(key);
        }
        return mac;
    }

    protected KeyPairGenerator getKeyPairGenerator(String string) throws Exception {
        if (this.providerName == null) {
            return KeyPairGenerator.getInstance(string);
        }
        return KeyPairGenerator.getInstance(string, this.providerName);
    }

    protected byte[] getEncodedPrincipal(Principal principal) {
        return null;
    }

    protected DHPublicKey getDHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws Exception {
        DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, bigInteger2, bigInteger3);
        KeyFactory keyFactory = this.providerName == null ? KeyFactory.getInstance(ALG_KEYEX_DH) : KeyFactory.getInstance(ALG_KEYEX_DH, this.providerName);
        DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(dHPublicKeySpec);
        return dHPublicKey;
    }

    protected DHPrivateKey getDHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws Exception {
        DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(bigInteger, bigInteger2, bigInteger3);
        KeyFactory keyFactory = this.providerName == null ? KeyFactory.getInstance(ALG_KEYEX_DH) : KeyFactory.getInstance(ALG_KEYEX_DH, this.providerName);
        DHPrivateKey dHPrivateKey = (DHPrivateKey)keyFactory.generatePrivate(dHPrivateKeySpec);
        return dHPrivateKey;
    }

    protected Cipher getCipher(String string, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws Exception {
        Cipher cipher;
        if (string.startsWith(ALG_CIPHER_RSA)) {
            string = ALG_CIPHER_RSA;
        }
        Cipher cipher2 = cipher = this.providerName == null ? Cipher.getInstance(string) : Cipher.getInstance(string, this.providerName);
        if (n2 != CIPHER_NONE) {
            int n3 = n2 == CIPHER_ENCRYPT ? 1 : 2;
            cipher.init(n3, key, algorithmParameterSpec, secureRandom);
        }
        return cipher;
    }

    protected byte[] calculateRawSignature(String string, byte[] byArray, PrivateKey privateKey, SecureRandom secureRandom) throws Exception {
        Cipher cipher = this.getCipher(string, CIPHER_ENCRYPT, privateKey, null, secureRandom);
        byte[] byArray2 = cipher.doFinal(byArray);
        return byArray2;
    }

    public SecurityProvider(String string) {
        this.providerName = string;
    }

    public SecurityProvider() {
        this(null);
    }

    static {
        b = new Hashtable();
        try {
            configuration_ = new Properties();
            configuration_.load((c != null ? c : (c = SecurityProvider.a("iaik.security.ssl.SecurityProvider"))).getClassLoader().getResourceAsStream(CONFIGURATION_PROPERTIES));
        }
        catch (Throwable throwable) {
            configuration_ = null;
        }
        SIGNATURE_SIGN = 1;
        SIGNATURE_VERIFY = 2;
        CIPHER_ENCRYPT = 1;
        CIPHER_DECRYPT = 2;
    }
}

