/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.views;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.dialogs.AuthenticateDialog;
import com.sap.ide.webdynpro.ecatt.exceptions.EcattException;
import com.sap.ide.webdynpro.ecatt.general.AuthenticationObject;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.ecatt.provider.HierarchyDeltaProvider;
import com.sap.ide.webdynpro.ecatt.replay.ReplayManager;
import com.sap.ide.webdynpro.ecatt.replay.ReplayResultXMLGenerator;
import com.sap.ide.webdynpro.ecatt.replay.util.ReplayUtil;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;

public class ReplayView
extends ViewPart {
    private String script;
    public Text scriptField;
    public Text messageField;
    public Text resultField;
    private Button saveResultButton;
    public Button replayButton;
    private Text applicationURLField;
    private Thread t;
    private Vector pageNames;
    private Entity entity;
    private Composite parent;
    private TextPool mTextPool = TextPool.getInstance();

    public void createPartControl(Composite parent) {
        this.parent = parent;
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        parent.setLayout((Layout)formLayout);
        Label applicationURLLabel = new Label(parent, 0x1000000);
        applicationURLLabel.setText(this.mTextPool.getText(109));
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 5);
        data1.right = new FormAttachment(10, 0);
        applicationURLLabel.setLayoutData((Object)data1);
        this.applicationURLField = new Text(parent, 2052);
        FormData data2 = new FormData();
        data2.left = new FormAttachment((Control)applicationURLLabel, 5);
        data2.right = new FormAttachment(60, 0);
        this.applicationURLField.setLayoutData((Object)data2);
        this.replayButton = new Button(parent, 2056);
        this.replayButton.setText(this.mTextPool.getText(110));
        FormData data3 = new FormData();
        data3.left = new FormAttachment((Control)this.applicationURLField, 5);
        data3.right = new FormAttachment(80, 0);
        this.replayButton.setLayoutData((Object)data3);
        this.replayButton.setEnabled(false);
        this.replayButton.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                ReplayView.this.executeReplaySteps();
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.saveResultButton = new Button(parent, 2056);
        this.saveResultButton.setText(this.mTextPool.getText(111));
        FormData data4 = new FormData();
        data4.left = new FormAttachment((Control)this.replayButton, 5);
        data4.right = new FormAttachment(100, -5);
        this.saveResultButton.setLayoutData((Object)data4);
        this.saveResultButton.setEnabled(false);
        this.saveResultButton.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                ReplayView.this.saveResultInFileSystem();
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.scriptField = new Text(parent, 2818);
        FormData data5 = new FormData();
        data5.top = new FormAttachment((Control)this.applicationURLField, 15);
        data5.bottom = new FormAttachment(75, 0);
        data5.left = new FormAttachment(0, 5);
        data5.right = new FormAttachment(50, 0);
        this.scriptField.setLayoutData((Object)data5);
        this.scriptField.setEditable(false);
        this.scriptField.setBackground(new Color(null, 255, 255, 255));
        this.resultField = new Text(parent, 2818);
        FormData data6 = new FormData();
        data6.top = new FormAttachment((Control)this.applicationURLField, 15);
        data6.bottom = new FormAttachment(75, 0);
        data6.left = new FormAttachment((Control)this.scriptField, 5);
        data6.right = new FormAttachment(100, -5);
        this.resultField.setLayoutData((Object)data6);
        this.resultField.setEditable(false);
        this.resultField.setBackground(new Color(null, 255, 255, 255));
        this.messageField = new Text(parent, 2818);
        FormData data7 = new FormData();
        data7.top = new FormAttachment((Control)this.resultField, 10);
        data7.bottom = new FormAttachment(100, -5);
        data7.left = new FormAttachment(0, 5);
        data7.right = new FormAttachment(100, -5);
        this.messageField.setLayoutData((Object)data7);
        this.messageField.setEditable(false);
        this.messageField.setBackground(new Color(null, 255, 255, 255));
        this.messageField.setForeground(new Color(null, 0, 0, 255));
    }

    public void executeReplaySteps() {
        if (ReplayUtil.isValidReplayUrl(this.applicationURLField.getText().trim()) && this.isXMLWellFormed()) {
            this.replayButton.setEnabled(false);
            this.saveResultButton.setEnabled(false);
            this.resultField.setText("");
            AuthenticateDialog authDialog = null;
            if (ReplayUtil.isAuthenticationRequired(this.applicationURLField.getText().trim())) {
                authDialog = new AuthenticateDialog();
                authDialog.open();
                if (!authDialog.isOK()) {
                    this.reportErrorMessage(this.mTextPool.getText(1050));
                    return;
                }
                this.startReplayProcess(authDialog.getAuthenticationObject());
            } else {
                this.startReplayProcess(null);
            }
        }
    }

    public void startReplayProcess(AuthenticationObject authenticationObject) {
        this.t = new ReplayManager(this, ReplayUtil.getReplayUrl(this.applicationURLField.getText().trim()), authenticationObject, this.scriptField.getText().trim());
        this.t.start();
    }

    public void setScript(String script) {
        this.script = script;
        this.scriptField.setText(script);
        this.replayButton.setEnabled(true);
        this.scriptField.setEditable(true);
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationURLField.setText(applicationUrl);
    }

    public void setFocus() {
    }

    public String getScript() {
        return this.scriptField.getText();
    }

    public void appendMessage(String message) {
        this.messageField.append("\n" + message);
    }

    public Display getDisplay() {
        return this.parent.getDisplay();
    }

    public void reportErrorMessage(String errorMessage) {
        this.messageField.append("\n" + this.mTextPool.getText(27) + ": " + errorMessage);
        this.messageField.append("\n" + this.mTextPool.getText(21));
    }

    public void showSaveResultButton(boolean value) {
        this.saveResultButton.setEnabled(value);
    }

    private boolean isXMLWellFormed() {
        ClassLoader _savedClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            DocumentBuilderFactory factory;
            try {
                factory = DocumentBuilderFactory.newInstance();
                Object var4_4 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Thread.currentThread().setContextClassLoader(_savedClassLoader);
                throw throwable;
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream byteStream = new ByteArrayInputStream(this.scriptField.getText().getBytes("UTF-8"));
            Document temp = builder.parse(byteStream);
            return true;
        }
        catch (Exception e) {
            this.reportErrorMessage(e.getMessage());
            UtilityClass.showErrorDialog(this.mTextPool.getText(29), TextPool.getInstance().getText(92));
            return false;
        }
    }

    private void saveResultInFileSystem() {
        try {
            InputDialog inputDialog = new InputDialog(this.parent.getShell(), this.mTextPool.getText(93), this.mTextPool.getText(94), null, null);
            inputDialog.open();
            String value = inputDialog.getValue();
            if (value != null && !value.equals("")) {
                value = value + ".testresult";
                ReplayResultXMLGenerator replayResultXMlGenerator = new ReplayResultXMLGenerator(this.resultField.getText(), this.applicationURLField.getText(), this.pageNames);
                Document doc = replayResultXMlGenerator.generateXMLDocument();
                this.performFileOperations(value, doc);
            }
        }
        catch (Exception e) {
            this.reportErrorMessage(e.getMessage());
        }
    }

    private void performFileOperations(String fileName, Document doc) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        try {
            IFile testScriptResultFile;
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            IFolder scriptsFolder = testsFolder.getFolder(this.getApplication().getQualifiedName());
            IFolder resultsFolder = scriptsFolder.getFolder(this.mTextPool.getText(502));
            if (!resultsFolder.exists()) {
                resultsFolder.create(true, true, null);
            }
            String scriptName = this.getFileName(this.entity.getUniqueName().toString());
            IFolder resultFolder = resultsFolder.getFolder(this.getApplication().getQualifiedName() + "_" + scriptName);
            if (!resultFolder.exists()) {
                resultFolder.create(true, true, null);
            }
            if ((testScriptResultFile = resultFolder.getFile(fileName)).exists()) {
                UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(86));
            } else {
                byte[] bytes = UtilityClass.getInstance().domToByteArray(doc);
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                testScriptResultFile.create((InputStream)in, true, null);
                this.updateSelenaModel();
            }
        }
        catch (CoreException e) {
            this.reportErrorMessage(this.mTextPool.getText(97) + ". " + this.mTextPool.getText(22) + ". " + e.getMessage());
        }
        catch (EcattException ex) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(97) + ". " + ex.getMessage());
        }
    }

    public void setPageNames(Vector pageNames) {
        this.pageNames = pageNames;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    private String getProjectName() {
        return this.entity.getModel().getUniqueName().getName();
    }

    private Application getApplication() {
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)this.getProjectName()).getDevelopmentObject(this.entity.getParent().getUniqueName());
        return (Application)developmentObject;
    }

    /*
     * WARNING - void declaration
     */
    private String getFileName(String uniqueName) {
        try {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = uniqueName.indexOf(":", endIndex)) != -1) {
                void var2_3;
                endIndex = var2_3 + true;
            }
            return uniqueName.substring(endIndex);
        }
        catch (Exception e) {
            UtilityClass.showErrorDialog(this.mTextPool.getText(1), this.mTextPool.getText(71));
            return null;
        }
    }

    private void updateSelenaModel() {
        HierarchyDeltaProvider hierarchyDeltaProvider = HierarchyDeltaProvider.getHierarchyDeltaProvider(this.getProjectName());
        UniqueName applicationUIN = this.entity.getParent().getUniqueName();
        hierarchyDeltaProvider.markChanged(applicationUIN);
        hierarchyDeltaProvider.commitUpdate();
    }

    public Image getTitleImage() {
        return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_REPLAY);
    }
}

