/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.views;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ecatt.EcattPlugin;
import com.sap.ide.webdynpro.ecatt.dialogs.SaveScriptDialog;
import com.sap.ide.webdynpro.ecatt.exceptions.EcattException;
import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.ecatt.provider.HierarchyDeltaProvider;
import com.sap.ide.webdynpro.ecatt.record.EcattServer;
import com.sap.ide.webdynpro.ecatt.replay.ScriptParser;
import com.sap.ide.webdynpro.ecatt.views.ReplayView;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecordingView
extends ViewPart {
    public Button stopRecordButton;
    private Button replayButton;
    private Text messageArea;
    private Thread t;
    private Document xmlDoc = null;
    public boolean serverRunning = false;
    private Entity entity;
    private Composite parent;
    private IFile script = null;
    private final String RECORDING_VIEW = "com.sap.ide.webdynpro.ecatt.views.recordingView";
    private final String REPLAY_VIEW = "com.sap.ide.webdynpro.ecatt.views.replayView";
    private TextPool mTextPool = TextPool.getInstance();

    public void createPartControl(Composite parent) {
        this.parent = parent;
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        Group group = new Group(parent, 0);
        FormLayout groupFormLayout = new FormLayout();
        groupFormLayout.marginHeight = 5;
        groupFormLayout.marginWidth = 5;
        group.setLayout((Layout)groupFormLayout);
        FormData groupFormData = new FormData();
        groupFormData.left = new FormAttachment(0, 5);
        group.setLayoutData((Object)groupFormData);
        this.stopRecordButton = new Button((Composite)group, 8);
        this.stopRecordButton.setText(this.mTextPool.getText(88));
        FormData stopFormData = new FormData();
        this.stopRecordButton.setLayoutData((Object)stopFormData);
        this.stopRecordButton.setEnabled(false);
        this.stopRecordButton.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                RecordingView.this.executeStopRecordingSteps();
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.replayButton = new Button((Composite)group, 8);
        this.replayButton.setText(this.mTextPool.getText(89));
        FormData replayFormData = new FormData();
        replayFormData.left = new FormAttachment((Control)this.stopRecordButton, 15);
        this.replayButton.setLayoutData((Object)replayFormData);
        this.replayButton.setEnabled(false);
        this.replayButton.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IViewPart view = page.showView("com.sap.ide.webdynpro.ecatt.views.replayView");
                    ScriptParser scriptParser = new ScriptParser(RecordingView.this.script);
                    ((ReplayView)view).setScript(scriptParser.execute());
                    UniqueName uniqueName = ModelAccess.createUniqueName((String)"EcattWebDynpro", (String)"TestScript", (String)RecordingView.this.getApplication().getQualifiedName(), (String)RecordingView.this.script.getName(), null);
                    Entity temp = ModelAccess.getModel((UniqueName)RecordingView.this.entity.getModel().getUniqueName()).findEntity(uniqueName);
                    ((ReplayView)view).setEntity(temp);
                    ((ReplayView)view).setApplicationUrl(scriptParser.getApplicationUrl());
                    ((ReplayView)view).resultField.setText("");
                    ((ReplayView)view).messageField.setText("");
                }
                catch (PartInitException ex) {
                    UtilityClass.showErrorDialog(RecordingView.this.mTextPool.getText(1), TextPool.getInstance().getText(12));
                }
                catch (ReplayException exc) {
                    UtilityClass.showErrorDialog(RecordingView.this.mTextPool.getText(1), exc.getMessage());
                }
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.messageArea = new Text(parent, 2818);
        this.messageArea.setEditable(false);
        this.messageArea.setBackground(new Color(null, 255, 255, 255));
        this.messageArea.setForeground(new Color(null, 0, 0, 255));
        FormData maFormData = new FormData();
        maFormData.left = new FormAttachment(0, 5);
        maFormData.top = new FormAttachment((Control)group, 10);
        maFormData.right = new FormAttachment(100, -5);
        maFormData.bottom = new FormAttachment(100, -5);
        this.messageArea.setLayoutData((Object)maFormData);
    }

    public void executeStopRecordingSteps() {
        try {
            if (this.t.isAlive()) {
                this.t.destroy();
                this.appendMessage(this.mTextPool.getText(10001));
            }
            this.stopRecordButton.setEnabled(false);
            this.checkPreferencePage();
            boolean carryOn = true;
            while (carryOn) {
                SaveScriptDialog saveScriptDialog = new SaveScriptDialog();
                saveScriptDialog.open();
                if (saveScriptDialog.doContinue()) {
                    if (!this.saveInFile(saveScriptDialog.getFileName(), saveScriptDialog.getDescription())) continue;
                    this.replayButton.setEnabled(true);
                    carryOn = false;
                    continue;
                }
                if (saveScriptDialog.isOKPressed()) continue;
                carryOn = false;
            }
        }
        catch (Exception e) {
            EcattPlugin.internalError(((Object)((Object)this)).getClass(), "executeStopRecordingSteps", e.getMessage(), e, true);
        }
    }

    public void startServer(int port, String applicationURL) {
        this.serverRunning = true;
        this.messageArea.setText(this.mTextPool.getText(83) + ": " + applicationURL);
        this.appendMessage("Port: " + port);
        try {
            this.t = new EcattServer(port, applicationURL, this);
            this.t.start();
        }
        catch (Exception e) {
            this.reportErrorMessage(this.mTextPool.getText(81));
        }
    }

    public void appendMessage(String message) {
        this.messageArea.append("\n" + message);
    }

    public void reportErrorMessage(String errorMessage) {
        this.messageArea.append("\n" + this.mTextPool.getText(27) + ": " + errorMessage);
        this.messageArea.append("\n" + this.mTextPool.getText(21));
    }

    public void setDOM(Document xmlDoc) {
        this.xmlDoc = xmlDoc;
    }

    private boolean saveInFile(String fileName, String description) {
        try {
            IFolder scriptFolder;
            Element generalInfoElement = (Element)UtilityClass.getInstance().getNodeByName(this.xmlDoc, "Generalinfo");
            Element descriptionElement = this.xmlDoc.createElement("description");
            descriptionElement.appendChild(this.xmlDoc.createTextNode(description));
            generalInfoElement.appendChild(descriptionElement);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
            IFolder testsFolder = project.getFolder(this.mTextPool.getText(501));
            if (!testsFolder.exists()) {
                testsFolder.create(false, true, null);
            }
            if (!(scriptFolder = testsFolder.getFolder(this.getApplication().getQualifiedName())).exists()) {
                scriptFolder.create(false, true, null);
            }
            this.script = scriptFolder.getFile(fileName);
            if (this.script.exists()) {
                UtilityClass.showErrorDialog(this.mTextPool.getText(27), this.mTextPool.getText(86));
                return false;
            }
            byte[] bytes = UtilityClass.getInstance().domToByteArray(this.xmlDoc);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.script.create((InputStream)in, true, null);
            try {
                ((InputStream)in).close();
            }
            catch (IOException ex) {
                EcattPlugin.internalError(((Object)((Object)this)).getClass(), "saveInFile", ex.getMessage(), ex, true);
            }
            this.appendMessage(this.mTextPool.getText(87));
            this.updateSelenaModel();
            return true;
        }
        catch (CoreException e) {
            this.reportErrorMessage(this.mTextPool.getText(11) + this.mTextPool.getText(22) + this.mTextPool.getText(23) + e.getMessage());
            this.replayButton.setEnabled(false);
            this.stopRecordButton.setEnabled(false);
        }
        catch (EcattException ex) {
            this.reportErrorMessage(ex.getMessage());
        }
        return false;
    }

    private void checkPreferencePage() {
        if (this.xmlDoc == null) {
            return;
        }
        IPreferenceStore store = EcattPlugin.getDefault().getPreferenceStore();
        boolean addUI = store.getBoolean("add_ui");
        if (!addUI) {
            try {
                Element root = this.xmlDoc.getDocumentElement();
                NodeList list = root.getElementsByTagName("ui");
                int i = 0;
                while (i < list.getLength()) {
                    Node uiNode = list.item(i);
                    Node parent = uiNode.getParentNode();
                    Node removedNode = parent.removeChild(uiNode);
                    this.xmlDoc.normalize();
                    ++i;
                }
            }
            catch (Exception e) {
                EcattPlugin.internalError(((Object)((Object)this)).getClass(), "checkPreferencePage", e.getMessage(), e, true);
            }
        }
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        this.replayButton.setEnabled(false);
        this.stopRecordButton.setEnabled(false);
    }

    private String getProjectName() {
        return this.entity.getModel().getUniqueName().getName();
    }

    private Application getApplication() {
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)this.getProjectName()).getDevelopmentObject(this.entity.getUniqueName());
        return (Application)developmentObject;
    }

    public Display getDisplay() {
        return this.parent.getDisplay();
    }

    public void setFocus() {
    }

    private void updateSelenaModel() {
        HierarchyDeltaProvider hierarchyDeltaProvider = HierarchyDeltaProvider.getHierarchyDeltaProvider(this.getProjectName());
        UniqueName applicationUIN = this.entity.getParent().getUniqueName();
        hierarchyDeltaProvider.markChanged(applicationUIN);
        hierarchyDeltaProvider.commitUpdate();
    }

    public Image getTitleImage() {
        return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_RECORD);
    }
}

