/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.replay.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class UrlParser {
    private String mRedirectUrl = null;
    private String mBaseUrl = null;
    private HashMap mParamHash = null;

    public UrlParser(String redirectUrl) {
        this.mRedirectUrl = redirectUrl;
        this.mParamHash = new HashMap();
        this.extractParameters();
    }

    private void extractParameters() {
        int questionIndex = this.mRedirectUrl.indexOf("?");
        if (questionIndex == -1) {
            this.mBaseUrl = this.mRedirectUrl;
            return;
        }
        this.mBaseUrl = this.mRedirectUrl.substring(0, questionIndex);
        String parameterString = this.mRedirectUrl.substring(questionIndex + 1);
        StringTokenizer mTokenizer = new StringTokenizer(parameterString, "&");
        while (mTokenizer.hasMoreTokens()) {
            String parameter = mTokenizer.nextToken();
            StringTokenizer mParamTokenizer = new StringTokenizer(parameter, "=");
            while (mParamTokenizer.hasMoreTokens()) {
                String value;
                String key = mParamTokenizer.nextToken();
                try {
                    value = mParamTokenizer.nextToken();
                }
                catch (NoSuchElementException e) {
                    value = "";
                }
                this.mParamHash.put(key, value);
            }
        }
    }

    private String generateUrl() {
        String temp = this.mBaseUrl;
        int counter = 1;
        Iterator it = this.mParamHash.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            temp = counter == 1 ? temp + "?" + key + "=" + (String)this.mParamHash.get(key) : temp + "&" + key + "=" + (String)this.mParamHash.get(key);
            ++counter;
        }
        return temp;
    }

    public String getRevisedUrl(HashMap newParameters) {
        if (newParameters == null || newParameters.isEmpty()) {
            return this.generateUrl();
        }
        this.mParamHash.putAll(newParameters);
        return this.generateUrl();
    }
}

