/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.replay.execute;

import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.AuthenticationObject;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ReplayHelper {
    private String mReplayUrl = null;
    private boolean mStopReplay = false;
    private AuthenticationObject mAuthObject = null;
    private String mScript = null;
    private String mLogOffUrl = null;
    private HashMap mXmlnsAttrs = null;
    private String mScXmlVersion = null;
    private String mScXmlSessionId = null;

    public ReplayHelper(String replayUrl, String script, AuthenticationObject authObject) {
        this.mReplayUrl = replayUrl;
        this.mScript = script;
        this.mAuthObject = authObject;
        this.mXmlnsAttrs = new HashMap();
    }

    public String getReplayUrl() {
        return this.mReplayUrl;
    }

    public void setReplayUrl(String replayUrl) {
        this.mReplayUrl = replayUrl;
    }

    public void setStopReplay(boolean stopReplay) {
        this.mStopReplay = stopReplay;
    }

    public boolean isStopReplay() {
        return this.mStopReplay;
    }

    public String getScript() {
        return this.mScript;
    }

    public void setAuthenticationObject(AuthenticationObject authObject) {
        this.mAuthObject = authObject;
    }

    public AuthenticationObject getAuthenticationObject() {
        return this.mAuthObject;
    }

    public String getLogOffUrl() {
        return this.mLogOffUrl;
    }

    public void setReplayAttributes(Document receivedDoc) throws ReplayException {
        NodeList list = receivedDoc.getElementsByTagName("SCXML");
        if (list == null || list.getLength() == 0) {
            throw new ReplayException(TextPool.getInstance().getText(11054));
        }
        Element scxmlElement = (Element)list.item(0);
        String sessionUrl = scxmlElement.getAttribute("sessionUrl");
        if (sessionUrl == null || sessionUrl.length() == 0) {
            throw new ReplayException(TextPool.getInstance().getText(11039));
        }
        this.mReplayUrl = sessionUrl;
        this.mLogOffUrl = sessionUrl + "&" + "sap.session.cmd=close";
        this.mScXmlVersion = scxmlElement.getAttribute("version");
        if (this.mScXmlVersion == null || this.mScXmlVersion.length() == 0) {
            throw new ReplayException(TextPool.getInstance().getText(11049));
        }
        NamedNodeMap map = scxmlElement.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Attr attr = (Attr)map.item(i);
            if (attr.getName().startsWith("xmlns")) {
                this.mXmlnsAttrs.put(attr.getName(), attr.getValue());
            }
            ++i;
        }
    }

    public HashMap getXmlnsAttrs() {
        return this.mXmlnsAttrs;
    }

    public String getScXmlVersion() {
        return this.mScXmlVersion;
    }

    public String getScXmlSessionId() {
        return this.mScXmlSessionId;
    }
}

