/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.replay.execute;

import com.sap.ide.webdynpro.ecatt.exceptions.EcattException;
import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.AuthenticationObject;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.general.UtilityClass;
import com.sap.ide.webdynpro.ecatt.replay.ReplayManager;
import com.sap.ide.webdynpro.ecatt.replay.execute.Connection;
import com.sap.ide.webdynpro.ecatt.replay.execute.ReplayHelper;
import com.sap.ide.webdynpro.ecatt.replay.util.ReplayEntity;
import com.sap.ide.webdynpro.ecatt.replay.util.ReplayEntityCollection;
import java.io.ByteArrayOutputStream;
import org.w3c.dom.Document;

public class ReplayExecutor {
    private ReplayManager mReplayManager = null;
    private ReplayHelper mReplayHelper = null;
    private Connection mConnection = null;
    private TextPool mTextPool = TextPool.getInstance();
    private UtilityClass mUtilityClass = UtilityClass.getInstance();

    public ReplayExecutor(ReplayManager replayManager, ReplayHelper replayHelper) {
        this.mReplayManager = replayManager;
        this.mReplayHelper = replayHelper;
        this.mConnection = new Connection(replayManager);
    }

    public void executeInitialCall() throws ReplayException {
        this.mReplayManager.appendMessage("-->" + this.mTextPool.getText(44), false);
        ByteArrayOutputStream baos = this.mConnection.httpGet(this.mReplayHelper, this.mTextPool.getText(41));
        if (baos == null || baos.size() == 0) {
            throw new ReplayException(this.mTextPool.getText(11034));
        }
        Document receivedDoc = null;
        try {
            receivedDoc = this.mUtilityClass.ByteArrayToDom(baos.toByteArray());
            this.mReplayManager.appendXML(this.mUtilityClass.domToString(receivedDoc), this.mTextPool.getText(41), true);
        }
        catch (EcattException e) {
            throw new ReplayException(this.mTextPool.getText(11035) + e.getMessage());
        }
        this.mReplayHelper.setReplayAttributes(receivedDoc);
        this.mReplayManager.appendMessage(this.mTextPool.getText(45), false);
    }

    public void executeCall(ReplayEntity replayEntity) throws ReplayException {
        this.mReplayManager.appendMessage("\n-->" + this.mTextPool.getText(49) + replayEntity.getPageName(), false);
        ByteArrayOutputStream baos = this.mConnection.httpPost(this.mReplayHelper, replayEntity);
        if (baos == null || baos.size() == 0) {
            throw new ReplayException(this.mTextPool.getText(11034));
        }
        this.mReplayManager.appendXML(UtilityClass.getInstance().indentXML(baos.toByteArray()), replayEntity.getPageName(), false);
        this.mReplayManager.appendMessage(this.mTextPool.getText(101), false);
    }

    public void executeNextApplicationCall(ReplayEntityCollection collection, ReplayEntity replayEntity) throws ReplayException {
        this.mReplayManager.appendMessage("\n-->" + this.mTextPool.getText(49) + replayEntity.getPageName(), false);
        ByteArrayOutputStream baos = this.mConnection.httpRedirectPost(this.mReplayHelper, replayEntity);
        if (baos == null) {
            throw new ReplayException(this.mTextPool.getText(11034));
        }
        Document receivedDoc = null;
        try {
            receivedDoc = this.mUtilityClass.ByteArrayToDom(baos.toByteArray());
            this.mReplayManager.appendXML(this.mUtilityClass.domToString(receivedDoc), replayEntity.getPageName(), true);
        }
        catch (EcattException e) {
            throw new ReplayException(this.mTextPool.getText(11040) + e.getMessage());
        }
        this.mReplayHelper.setReplayAttributes(receivedDoc);
        collection.updateInfoInReplayEntities(replayEntity, this.mReplayHelper.getReplayUrl());
        this.mReplayManager.appendMessage(this.mTextPool.getText(101), false);
    }

    public void closeSession(AuthenticationObject authObject) {
        this.mConnection.closeSession(this.mReplayHelper.getLogOffUrl(), authObject);
    }
}

