/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ecatt.replay.execute;

import com.sap.ide.webdynpro.ecatt.exceptions.ReplayException;
import com.sap.ide.webdynpro.ecatt.general.AuthenticationObject;
import com.sap.ide.webdynpro.ecatt.general.TextPool;
import com.sap.ide.webdynpro.ecatt.replay.ReplayManager;
import com.sap.ide.webdynpro.ecatt.replay.execute.ReplayHelper;
import com.sap.ide.webdynpro.ecatt.replay.util.ReplayEntity;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class Connection {
    private TextPool mTextPool = TextPool.getInstance();
    private ReplayManager mReplayManager = null;

    public Connection(ReplayManager replayManager) {
        this.mReplayManager = replayManager;
    }

    public ByteArrayOutputStream httpGet(ReplayHelper replayHelper, String pageName) throws ReplayException {
        HttpURLConnection con = null;
        URL replayUrl = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            replayUrl = new URL(replayHelper.getReplayUrl());
        }
        catch (MalformedURLException e) {
            throw new ReplayException(e.getMessage());
        }
        try {
            try {
                con = (HttpURLConnection)replayUrl.openConnection();
                con.setRequestMethod("GET");
                con.setDoOutput(false);
                con.setDoInput(true);
                con.setUseCaches(false);
                if (replayHelper.getAuthenticationObject() != null) {
                    con.setRequestProperty("Authorization", replayHelper.getAuthenticationObject().getBase64Representation());
                }
                con.setRequestProperty("User-Agent", "SAP-NW-eCATT/NWDS/2");
                con.connect();
                if (con.usingProxy()) {
                    throw new ReplayException(TextPool.getInstance().getText(11008));
                }
                this.openInputStream(con, baos);
            }
            catch (IOException e) {
                replayHelper.setStopReplay(true);
                this.httpGetErrorStream(con, pageName);
                Object var8_9 = null;
                con.disconnect();
            }
            Object var8_8 = null;
            con.disconnect();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            con.disconnect();
            throw throwable;
        }
        return baos;
    }

    public ByteArrayOutputStream httpPost(ReplayHelper replayHelper, ReplayEntity replayEntity) throws ReplayException {
        HttpURLConnection con = null;
        URL replayUrl = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] postBytes = null;
        try {
            replayUrl = new URL(replayHelper.getReplayUrl());
            postBytes = replayEntity.getReplaySnippet().getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new ReplayException(e.getMessage());
        }
        try {
            try {
                con = (HttpURLConnection)replayUrl.openConnection();
                HttpURLConnection.setFollowRedirects(false);
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setUseCaches(false);
                con.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
                if (replayHelper.getAuthenticationObject() != null) {
                    con.setRequestProperty("Authorization", replayHelper.getAuthenticationObject().getBase64Representation());
                }
                con.setRequestProperty("Content-length", String.valueOf(postBytes.length));
                con.setRequestProperty("User-Agent", "SAP-NW-eCATT/NWDS/2");
                this.openOutputStream(con, postBytes);
                this.mReplayManager.appendMessage(TextPool.getInstance().getText(50), false);
                if (con.getResponseCode() == 302) {
                    throw new ReplayException(this.mTextPool.getText(11030));
                }
                this.openInputStream(con, baos);
            }
            catch (IOException e) {
                replayHelper.setStopReplay(true);
                this.httpGetErrorStream(con, replayEntity.getPageName());
                Object var9_10 = null;
                con.disconnect();
            }
            Object var9_9 = null;
            con.disconnect();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            con.disconnect();
            throw throwable;
        }
        return baos;
    }

    public ByteArrayOutputStream httpRedirectPost(ReplayHelper replayHelper, ReplayEntity replayEntity) throws ReplayException {
        HttpURLConnection con = null;
        URL replayUrl = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] postBytes = null;
        try {
            replayUrl = new URL(replayHelper.getReplayUrl());
            postBytes = replayEntity.getReplaySnippet().getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new ReplayException(e.getMessage());
        }
        try {
            block8: {
                try {
                    con = (HttpURLConnection)replayUrl.openConnection();
                    HttpURLConnection.setFollowRedirects(false);
                    con.setRequestMethod("POST");
                    con.setDoOutput(true);
                    con.setDoInput(true);
                    con.setUseCaches(false);
                    con.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
                    if (replayHelper.getAuthenticationObject() != null) {
                        con.setRequestProperty("Authorization", replayHelper.getAuthenticationObject().getBase64Representation());
                    }
                    con.setRequestProperty("Content-length", String.valueOf(postBytes.length));
                    con.setRequestProperty("User-Agent", "SAP-NW-eCATT/NWDS/2");
                    this.openOutputStream(con, postBytes);
                    this.mReplayManager.appendMessage(TextPool.getInstance().getText(50), false);
                    if (con.getResponseCode() == 302) {
                        String redirectUrl = con.getHeaderField("Location").trim();
                        con.disconnect();
                        replayHelper.setReplayUrl(redirectUrl);
                        baos = this.httpGet(replayHelper, replayEntity.getPageName());
                        break block8;
                    }
                    replayHelper.setStopReplay(true);
                    this.httpGetRedirectErrorStream(con, replayEntity.getPageName());
                }
                catch (IOException e) {
                    replayHelper.setStopReplay(true);
                    this.httpGetErrorStream(con, replayEntity.getPageName());
                    Object var9_11 = null;
                    con.disconnect();
                }
            }
            Object var9_10 = null;
            con.disconnect();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            con.disconnect();
            throw throwable;
        }
        return baos;
    }

    public void closeSession(String url, AuthenticationObject authObject) {
        if (url == null || url.length() == 0) {
            return;
        }
        HttpURLConnection con = null;
        try {
            try {
                URL mUrl = new URL(url);
                con = (HttpURLConnection)mUrl.openConnection();
                con.setRequestMethod("GET");
                con.setDoOutput(false);
                con.setDoInput(true);
                con.setUseCaches(false);
                if (authObject != null) {
                    con.setRequestProperty("Authorization", authObject.getBase64Representation());
                }
                con.setRequestProperty("User-Agent", "SAP-NW-eCATT/NWDS/2");
                con.connect();
                BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                in.close();
            }
            catch (Exception e) {
                Object var7_8 = null;
                con.disconnect();
                return;
            }
            Object var7_7 = null;
            con.disconnect();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            con.disconnect();
            throw throwable;
        }
    }

    private void httpGetErrorStream(HttpURLConnection con, String pageName) throws ReplayException {
        int responseCode = -1;
        try {
            responseCode = con.getResponseCode();
        }
        catch (IOException e) {
            throw new ReplayException(this.mTextPool.getText(103) + e.getMessage());
        }
        if (responseCode == 401) {
            throw new ReplayException(TextPool.getInstance().getText(1060));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.openErrorStream(con, baos);
        }
        catch (IOException e) {
            throw new ReplayException(this.mTextPool.getText(11032) + e.getMessage());
        }
        try {
            this.mReplayManager.appendXML(baos.toString("UTF-8"), pageName, true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ReplayException(this.mTextPool.getText(11033) + e.getMessage());
        }
        throw new ReplayException(this.mTextPool.getText(102));
    }

    private void httpGetRedirectErrorStream(HttpURLConnection con, String pageName) throws ReplayException {
        int responseCode = -1;
        try {
            responseCode = con.getResponseCode();
        }
        catch (IOException e) {
            throw new ReplayException(this.mTextPool.getText(103) + e.getMessage());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.openErrorStream(con, baos);
        }
        catch (IOException e) {
            throw new ReplayException(this.mTextPool.getText(11032) + e.getMessage());
        }
        try {
            this.mReplayManager.appendXML(baos.toString("UTF-8"), pageName, true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ReplayException(this.mTextPool.getText(11033) + e.getMessage());
        }
        throw new ReplayException(this.mTextPool.getText(102) + "\n" + this.mTextPool.getText(11026));
    }

    private void openInputStream(HttpURLConnection con, ByteArrayOutputStream baos) throws IOException {
        BufferedInputStream in = new BufferedInputStream(con.getInputStream());
        baos.reset();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        baos.close();
        in.close();
    }

    private void openOutputStream(HttpURLConnection con, byte[] bytes) throws IOException {
        OutputStream out = con.getOutputStream();
        out.write(bytes);
        out.flush();
        out.close();
    }

    private void openErrorStream(HttpURLConnection con, ByteArrayOutputStream baos) throws IOException {
        BufferedInputStream in = new BufferedInputStream(con.getErrorStream());
        baos.reset();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        baos.close();
        in.close();
    }
}

